// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.text.*;

/**
 * Υ֤֤ܥȥƥȥꥢݻ륯饹
 * 
 * Element's class like LUW, SUW, IPU...
 * include Button + TextArea + some windows
 */
public class UIElement
    implements java.awt.event.ActionListener,
	       javax.swing.event.TreeSelectionListener,
	       javax.swing.event.ListSelectionListener,
	       java.awt.event.ItemListener,
	       javax.swing.event.DocumentListener
{
    /**
     * log4j logger
     */
    static Logger logger =
	Logger.getLogger(UIElement.class);
    
    static final String ROOT_NAME = "()";
    boolean isTreeLocked = false;
    boolean isCursorInText = false;
    
    JFrame dialog;
    String elementString = "";
    String elementTextString = "";
    
    // for main dialog
    JToggleButton elementButton = null;
    JTextArea attributeArea = null;
    JScrollPane inputArea = null;
    
    // for option dialog
    JTree tree = null;
    JList list = null;
    JTextField textField = null;
    Document text = null;
    JCheckBox not = null;
    JComboBox select = null;
    String[] selectMenu = {"=", ">", "<", "!=", ">=", "<="};
    //String[] SelectMenu = {"eq", "gt", "lt", "ne", "ge", "le"};
    
    // Tree Holder?
    DefaultTreeModel treeModel;

    Vector attributes = null;
    
    // depth of the tree (ex. Talk=0 IPU=1 LUW=2...)
    int depth = 0;
    // # in the same depth (ex. LUW=0, Noise=1...)
    int number = 0;
    
    /**
     * 줾TAG̾Υܥ򲡤˸
     * WINDOWνԤ
     * 
     * initialize UI Element by Element name and Attibutes.
     *
     * SchemeLoaderǼϡ"0,1"Τ褦ˤʤäƤ뤬
     * Ǥd=0, n=1ȤƻѤ롣
     *
     * @param d depth of the element in the tree.
     * @param n # of the element in the same depth.
     * @param elementName XML's english element name.
     * @param elementText XML's japanese element name which is printed
     *                    on the Button.
     * @param attributesList vector<String> of the names of the attributes of
     *                       the element.
     * @param attributesTextsList japanese version of the AttributesList.
     */
    public UIElement(int d, int n,
		     String elementName,
		     String elementText,
		     Vector attributesList,
		     Vector attributesTextsList)
    {
	logger.debug("UIElement - entering " + elementName + " " + elementText);

	// first, intialize
	depth = d;
	number = n;
	elementString = elementName;
	elementTextString = elementText;
	elementButton = new JToggleButton(elementTextString);
	elementButton.addActionListener(this);
	attributeArea = new JTextArea();
	attributeArea.setRows(2);
	attributeArea.setColumns(10);
	attributeArea.setEditable(false);
	inputArea = new JScrollPane(attributeArea);
	
	attributes = new Vector();
	
	String tip = "<html>°";

	// add AND and OR to Vector
	attributes.addElement("and");
	attributes.addElement("or");

	if (attributesList != null&&attributesTextsList != null&&
	    attributesList.size() == attributesTextsList.size())
	    {
		// foreach(List) do InsertRecord
		for (int i = 0;i < attributesList.size();i ++)
		    {
			attributes.addElement((String)attributesTextsList.get(i) +
					      "(" +
					      (String)attributesList.get(i) +
					      ")");
			// ޥСλ˥ݥåץåפ
			tip = tip + "<p>" +
			    (String)attributesTextsList.get(i) +
			    "(" +
			    (String)attributesList.get(i) +
			    ")";
		    }
		tip = tip + "</html>";
		elementButton.setToolTipText(tip);
	    }
	
	// then, make dialog
	makeDialog();
	
	logger.debug("UIElement - exiting");
	return ;
    }
    
    private void toggleDialog()
    {
	if (elementButton.isSelected())
	    {
		dialog.setVisible(true);
	    }
	else
	    {
		dialog.setVisible(false);
	    }
	return ;
    }
    
    private void makeDialog()
    {
	dialog = new JFrame();
	dialog.setTitle("Ｐ - " + elementTextString 
			+ "(" + elementString + ")");
        dialog.setSize(900,500);
	

	// initialize tree
	DefaultMutableTreeNode rootTreeNode =
	    new DefaultMutableTreeNode(ROOT_NAME);
	treeModel = new DefaultTreeModel(rootTreeNode);
	tree = new JTree(treeModel);
	tree.addTreeSelectionListener(this);
	// Editable -> strange exception handling
	tree.setRootVisible(true);
	// Editable -> many errors
	tree.setEditable(false);
	
	JScrollPane scrollPane = new JScrollPane();
	scrollPane.getViewport().setView(tree);
	
	// initialize JList
	list = new JList(attributes);
	list.addListSelectionListener(this);
	
	JScrollPane scrollPane2 = new JScrollPane();
	scrollPane2.getViewport().setView(list);
	
	//initialize TextField
	textField = new JTextField("");
	textField.setEditable(true);
	text = textField.getDocument();
	text.addDocumentListener(this);
	textField.setFont(new Font("SansSerif",Font.PLAIN,20));
	JScrollPane scrollPane3 =
	    new JScrollPane(textField,
			    JScrollPane.VERTICAL_SCROLLBAR_NEVER,
			    JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	
	// install UI
	GridBagLayout gridBagDialog = new GridBagLayout();
	dialog.getContentPane().setLayout(gridBagDialog);
	
	GridBagConstraints gbc = new GridBagConstraints();	
	
	gbc.gridx = 0;
	gbc.gridy = 0;
	gbc.gridwidth  = 1;
	gbc.gridheight = 11;
	gbc.weightx = 2;
	gbc.weighty = 0.6;
	gbc.insets = new Insets(4, 4, 4, 4);
	gbc.fill = GridBagConstraints.BOTH;
	gridBagDialog.setConstraints(scrollPane, gbc);
	dialog.getContentPane().add(scrollPane);
	
	JLabel note2 = new JLabel("°μ");
	note2.setFont(new Font("SansSerif",Font.PLAIN,14));
	note2.setOpaque(false);
	gbc.gridx = 1;
	gbc.gridy = 1;
	gbc.gridwidth = 1;
	gbc.gridheight = 1;
	gbc.weightx = 0.4;
	gbc.insets = new Insets(0, 0, 0, 0);
	gbc.fill = GridBagConstraints.NONE;
	gridBagDialog.setConstraints(note2, gbc);
	dialog.getContentPane().add(note2);
	
	gbc.gridx = 1;
	gbc.gridy = 2;
	gbc.gridwidth = 3;
	gbc.gridheight = 5;
	gbc.weightx = 0.4;
	gbc.weighty = 3.6;
	gbc.insets = new Insets(4, 4, 4, 4);
	gbc.fill = GridBagConstraints.BOTH;
	gridBagDialog.setConstraints(scrollPane2, gbc);
	dialog.getContentPane().add(scrollPane2);
	
	JLabel note = new JLabel("°");
	note.setFont(new Font("SansSerif",Font.PLAIN,14));
	note.setOpaque(false);
	gbc.gridx = 1;
	gbc.gridy = 7;
	gbc.gridwidth = 1;
	gbc.gridheight = 1;
	gbc.weightx = 0.4;
	gbc.weighty = 0.6;
	gbc.insets = new Insets(0, 0, 0, 0);
	gbc.fill = GridBagConstraints.NONE;
	gridBagDialog.setConstraints(note, gbc);
	dialog.getContentPane().add(note);
	
	JLabel notea = new JLabel("͡ʸϼư̤ޤʤ٤ʸ\'\'ȤǰϤǲ");
	notea.setFont(new Font("SansSerif",Font.PLAIN,12));
	notea.setOpaque(false);
	gbc.gridx = 1;
	gbc.gridy = 8;
	gbc.gridwidth = 3;
	gbc.gridheight = 1;
	gbc.weightx = 0.4;
	gbc.weighty = 0.6;
	gbc.insets = new Insets(0, 0, 0, 0);
	gbc.fill = GridBagConstraints.NONE;
	gridBagDialog.setConstraints(notea, gbc);
	dialog.getContentPane().add(notea);

	gbc.gridx = 1;
	gbc.gridy = 9;
	gbc.gridwidth = 3;
	gbc.gridheight = 1;
	gbc.weightx = 0.4;
	gbc.insets = new Insets(4, 4, 4, 4);
	gbc.fill = GridBagConstraints.HORIZONTAL;
	gridBagDialog.setConstraints(scrollPane3, gbc);
	dialog.getContentPane().add(scrollPane3);

	gbc.weightx = 0.4;
	gbc.fill = GridBagConstraints.NONE;

	// NOT Check BOX
	not = new JCheckBox("");
	not.addItemListener(this);
	gbc.gridx = 1;
	gbc.gridy = 10;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(not, gbc);
	dialog.getContentPane().add(not);
	
	// select = , < , > ... by PullDownMenu
        select = new JComboBox(selectMenu);
	select.addActionListener(this);
	select.setEditable(false);
	gbc.gridx = 2;
	gbc.gridy = 10;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(select, gbc);
	dialog.getContentPane().add(select);
	
	JButton ok = new JButton("Ĥ");
	ok.setActionCommand("Ok");
	ok.addActionListener(this);
	gbc.gridx = 3;
	gbc.gridy = 10;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(ok, gbc);
	dialog.getContentPane().add(ok);
	
	JButton add = new JButton("ɲ");
	add.setActionCommand("Add");
	add.addActionListener(this);
	gbc.gridx = 1;
	gbc.gridy = 0;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(add, gbc);
	dialog.getContentPane().add(add);

	JButton addTree = new JButton("(AND/OR)ɲ");
	addTree.setActionCommand("AddTree");
	addTree.addActionListener(this);
	gbc.gridx = 2;
	gbc.gridy = 0;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(addTree, gbc);
	dialog.getContentPane().add(addTree);
	
	JButton delete = new JButton("");
	delete.setActionCommand("Delete");
	delete.addActionListener(this);
	gbc.gridx = 3;
	gbc.gridy = 0;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(delete, gbc);
	dialog.getContentPane().add(delete);
	
	// Place dialog window at the center.
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension frameSize = dialog.getSize();
	if (frameSize.height > screenSize.height)
	    {
		frameSize.height = screenSize.height;
	    }
	if (frameSize.width > screenSize.width)
	    {
		frameSize.width = screenSize.width;
	    }
	dialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	
        /* specify what to do when [X] was clicked */
	dialog.addWindowListener(new WindowAdapter()
	    {
                public void windowClosing(WindowEvent evt)
		{
		    elementButton.setSelected(false);
		    dialog.setVisible(false);
		}
            }
				 );
	return ;
    }

    
    /**
     * The element of the tree was selected.
     */
    public void valueChanged(TreeSelectionEvent e)
    {
	JTree tree = (JTree)e.getSource();
	DefaultMutableTreeNode node =
	    (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
	if (node == null)
	    {
		return ;
	    }
	
	// ignore OR or AND
	if (((String)node.getUserObject()).equals("or")||
	    ((String)node.getUserObject()).equals("and"))
	    {
		isTreeLocked = true;
		// Clear: 1,2,3
		// 1.
		int index = attributes.indexOf(node.getUserObject());
		list.setSelectedIndex(index);
		// 2.
		textField.setText("");
		// 3.
		not.setSelected(false);
		isTreeLocked = false;
		return ;
	    }
	
	// lock listener of the Items
	isTreeLocked = true;
	refreshItems(node);
	isTreeLocked = false;
	return ;
    }
    
    /**
     * The element Button was pressed.
     */
    public void actionPerformed(ActionEvent e)
    {
	if (e.getSource() == elementButton)
	    {
		toggleDialog();
		return ;
	    }
	String action = e.getActionCommand();
	if (action.equals("Ok"))
	    {
		elementButton.setSelected(false);
		dialog.setVisible(false);
		return ;
	    }
	if (e.getSource() == select)
	    {
		valueChanged();
	    }
	// Tree control buttons (BUG?)
	else
	    {
		// get selected path in the Tree
		TreePath path = tree.getSelectionPath();

		// 򤵤ƤʤưŪ˥롼Ȥ򤷤صϤ		
		if (path == null)
		    {	
			// λϡֲä
			if (action.equals("Delete"))
			    {
				tree.setSelectionPath(tree.getPathForRow(tree.getRowCount()-1));
			    }
			// ɲäλϥ롼ȡ
			else
			    {
				tree.setSelectionPath(tree.getPathForRow(0));
			    }
			path = tree.getSelectionPath();
		    }
		
		DefaultMutableTreeNode lastPath = 
		    (DefaultMutableTreeNode)path.getLastPathComponent();
		
		// λʳϿƤOR or AND or ROOT_NAMEǤʤФʤʤ
		if (!action.equals("Delete"))
		    {
			// ξ˹ʤϡƵŪ˲ˤ
			int cnt = path.getPathCount();
			String parent = path.getPathComponent(cnt-1).toString();
			while (!(parent.equals("and")||parent.equals("or")||parent.equals(ROOT_NAME)))
			    {
				cnt --;
				parent = path.getPathComponent(cnt-1).toString();
			    }
			lastPath = (DefaultMutableTreeNode)path.getPathComponent(cnt-1);
		    }

		if (action.equals("Delete"))
		    {
			lastPath.removeFromParent();
			treeModel.reload();
		    }
		else if (action.equals("Add"))
		    {
			if (attributes.size() < 3)
			    {
				JOptionPane.showMessageDialog(dialog.getContentPane(),
							      "ä°Ĥޤ\n");
				return ;
			    }
			lastPath.add(new DefaultMutableTreeNode("@" + (String)attributes.get(2) + " = \' \'"));
			treeModel.reload();
		    }
		else if (action.equals("AddTree"))
		    {
			lastPath.add(new DefaultMutableTreeNode("or"));
			treeModel.reload();
		    }
		else
		    {
			;
		    }
	    }
	return ;
    }
    
    /**
     * List was changed.
     * update Tree's element
     */
    public void valueChanged(ListSelectionEvent e)
    {
	// When the element in the tree is selected,
	// this function is called, so I have to
	// check it and stop changing values
	// in the Items.
	if (isTreeLocked)
	    {
		return ;
	    }

	if (e.getValueIsAdjusting())
	    {
		return ;
	    }
	
	JList theList = (JList)e.getSource();
	
	if (theList.isSelectionEmpty())
	    {
		theList.setSelectedIndex(0);
	    }
	
	DefaultMutableTreeNode node =
	    (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
	
	if (list.getSelectedValue().equals("and")||
	    list.getSelectedValue().equals("or"))
	    {
		// produce warning when selected OR os AND
		if (!textField.getText().equals(""))
		    {
			int value =
			    JOptionPane.showConfirmDialog(dialog.getContentPane(),
							  "ANDOR֤°ͤʸˤʤޤ\n³ޤ",
							  "",
							  JOptionPane.YES_NO_OPTION);
			
			if (value != JOptionPane.YES_OPTION)
			    {
				Object attr =
				    QueryCompiler.getAttributeName((String)node.getUserObject());
				int index = attributes.indexOf(attr);
				list.setSelectedIndex(index);
				return ;
			    }
		    }
	    }

	// get selected path in the Tree
	TreePath path = null;
	path = tree.getSelectionPath();
	if (path == null)
	    {
		JOptionPane.showMessageDialog(dialog.getContentPane(),
					      "Ǥ򤵤Ƥޤ\nǤ򤷤Ƥ\n");
		return ;
	    }
	
	// check if it has a child or children
	if ((!list.getSelectedValue().equals("and")&&
	     !list.getSelectedValue().equals("or"))&&!node.isLeaf())
	    {
		JOptionPane.showMessageDialog(dialog.getContentPane(),
					      "Ǥ˻ҤΤORANDʳѹǤޤ\n");
		Object attr =
		    QueryCompiler.getAttributeName((String)node.getUserObject());
		int index = attributes.indexOf(attr);
		list.setSelectedIndex(index);
		return ;
	    }
	
	updateTreeElement();
	return ;
    }
    
    /**
     * Text was changed.
     * update Tree's element
     */
    public void changedUpdate(DocumentEvent e)
    {
	isCursorInText = true;
	Document source = e.getDocument();
	if (source == text)
	    {
		updateTreeElement();
		isCursorInText = false;
	    }
	return ;
    } 
    
    public void removeUpdate(DocumentEvent e)
    {
	changedUpdate(e);
	return ;
    }
    
    public void insertUpdate(DocumentEvent e)
    {
	changedUpdate(e);
	return ;
    }
    
    /**
     * Not was changed.
     * update Tree's element
     */
    public void itemStateChanged(ItemEvent e)
    {
	JCheckBox source = (JCheckBox)e.getItemSelectable();
	
	if (source == not)
	    {
		updateTreeElement();
	    }
	return ;
    }
    
    /**
     * Select was changed.
     * update Tree's element
     */
    public void valueChanged()
    {
	updateTreeElement();
	return ;
    }
    
    /**
     * Auto convert String into 'String'
     * String -> 'String'
     * 'String' -> 'String'
     * number -> number
     */
    private String autoConvertString(String str)
    {
	String convertedString = "";
	if(str.length() < 1)
	    return "\'\'";
	if(str.length() == 1&&str.charAt(0) == '\'')
	    return "\'\'";
	// check if the given STR is number.
	try
	    {
		Double.parseDouble(str);
	    }
	catch(java.lang.NumberFormatException e)
	    {
		// STR is not a number.
		if (str.charAt(0) != '\'')
		    {
			convertedString = "\'" + str;
		    }
		else
		    {
			convertedString = str;
		    }

		if (str.charAt(str.length()-1) != '\'')
		    {
			convertedString = 
			    convertedString + "\'";
		    }
		return convertedString;
	    }
	// STR is a number.
	return str;
    }
    
    /**
     * Tree was Changed.
     * Collect info from List/Text/Not/Select and update element.
     */
    private void refreshItems(DefaultMutableTreeNode selectedNode)
    {
	// Refresh: 1,2,3,4
	String temp;
	
	// 1.JList List
	Object attr = QueryCompiler.getAttributeName((String)selectedNode.getUserObject());
	int index = attributes.indexOf(attr);
	list.setSelectedIndex(index);
	
	// 2.JTextField Text
	
	// to avoid Exception like
	// java.lang.IllegalStateException: Attempt to mutate in notification
	// at javax.swing.text.AbstractDocument.writeLock(AbstractDocument.java:1336)
	// at javax.swing.text.AbstractDocument.replace(AbstractDocument.java:657)
	// at javax.swing.text.JTextComponent.setText(JTextComponent.java:1403)
	// lock JText. 
	//   synchronized(Text){}
	// is better, though.)
	if (!isCursorInText)
	    {
		temp = QueryCompiler.getValue((String)selectedNode.getUserObject());
		textField.setText(temp);
	    }
	
	// 3.JCheckBox Not
	temp = QueryCompiler.checkNotString((String)selectedNode.getUserObject());
	if (temp.equals("not"))
	    {
		not.setSelected(true);
	    }
	else
	    {
		not.setSelected(false);
	    }
	
	// 4.JComboBox Select
	temp = QueryCompiler.getExpression((String)selectedNode.getUserObject());
	select.setSelectedItem(temp);
	return ;
    }
    
    /**
     * Collect info from List/Text/Not/Select and update element.
     */
    private void updateTreeElement()
    {
	// When the element in the tree is selected,
	// this function is called, so I have to
	// check it and stop changing values
	// in the Items.
	if (isTreeLocked)
	    {
		return ;
	    }
	
	// get selected path in the Tree
	TreePath path = null;
	path = tree.getSelectionPath();

	if (path == null)
	    {
		JOptionPane.showMessageDialog(dialog.getContentPane(),
					      "Ǥ򤵤Ƥޤ\nǤ򤷤Ƥ\n");
		return ;
	    }
	
	// make tree's address like
	// ()/OR/@ID = '1'
	int cnt = path.getPathCount();
	StringBuffer sb = new StringBuffer();
	for (int i = 0; i < cnt; i++)
	    {
		String s =
		    path.getPathComponent(i).toString();
		sb.append(s);
		if (i + 1 != cnt)
		    sb.append("/");
	    }
	
	// and check operation to ROOT node
	if (sb.toString().equals(ROOT_NAME))
	    {
		JOptionPane.showMessageDialog(dialog.getContentPane(),
					      "롼ȤФϤǤޤ\nҤ򤷤Ƥ\n");
		return ;
	    }
	
	// ex. "not (@(BirthPlace) != \'\')";	
	//      Not   List             Select Text
	String newElementString = "";
	// AND or OR
	if (list.getSelectedValue().equals("and")||
	    list.getSelectedValue().equals("or"))
	    {
		newElementString = (String)list.getSelectedValue();
	    }
	// normal expression
	else
	    {
		if (not.isSelected())
		    {
			newElementString =
			    "not (@" + list.getSelectedValue() + " " +
			    select.getSelectedItem() + " " +
			    autoConvertString(textField.getText()) + ")";
		    }
		else
		    {
			newElementString =
			    "@" + list.getSelectedValue() + " " +
			    select.getSelectedItem() + " " +
			    autoConvertString(textField.getText());
		    }
	    }

	// Then, update selected element
	DefaultMutableTreeNode lastPath = 
	    (DefaultMutableTreeNode)path.getLastPathComponent();
	
	// replace node string
	lastPath.setUserObject(newElementString);
	treeModel.reload();
	// select automatically again :-)
	tree.setSelectionPath(path);

	// update Text in the main interface
	updateText();

	return ;
    }

    /**
     * ᥤ󥦥ɥɽɽ
     * 򹹿
     * 
     * This function must be called when the
     * text in the sub window are changed.
     */
    private void updateText()
    {
	String test = toXQueryString("");
	
	attributeArea.setText(test);
	attributeArea.setToolTipText(test);
    }
    
    /**
     * ڤXQueryʸǼ
     *
     * @param prefix 줾ξＰդʸ
     */
    public String toXQueryString(String prefix)
    {
	return toXQueryString(prefix, (DefaultMutableTreeNode)treeModel.getRoot());
    }

    private String toXQueryString(String prefix, DefaultMutableTreeNode treeNode)
    {
	String queryString = "";
	String nodeString = (String)treeNode.getUserObject();

	if (nodeString.equals(ROOT_NAME))
	    {
		nodeString = "and";
	    }
	
	if (nodeString.equals("or")||nodeString.equals("and"))
	    {
		if (!treeNode.isLeaf())
		    {
			for (int i = 0;i < treeNode.getChildCount();i ++)
			    {
				DefaultMutableTreeNode childTreeNode =
				    (DefaultMutableTreeNode)treeNode.getChildAt(i);
				if (childTreeNode != null)
				    {
					String childString = toXQueryString(prefix, childTreeNode);
					if (!childString.equals(""))
					    {
						if (!queryString.equals(""))
						    {
							queryString = queryString + " " + nodeString + " ";
						    }
						queryString = queryString + childString;
					    }
				    }
			    }
		    }
		if (!queryString.equals(""))
		    {
			queryString = "(" + queryString + ")";
		    }
	    }
	else
	    {
		queryString = QueryCompiler.getEngExpression(nodeString, prefix);
	    }
	
	return queryString;
    }
    
    /**
     * JTreeξ֤DOMѴ
     */
    public org.w3c.dom.Element toNode()
    {
	TreeDOM treeDOM = new TreeDOM();
	return treeDOM.treeNodeToNode((DefaultMutableTreeNode)treeModel.getRoot());
    }

    /**
     * JTreeξ֤Ƹ
     */
    public void loadNode(org.w3c.dom.Node node)
    {
	TreeDOM treeDOM = new TreeDOM();
	treeModel.setRoot(treeDOM.nodeToTreeNode(node));
	
	treeModel.reload();
	// update Text in the main interface
	updateText();
	return ;
    }
    
    public String toString()
    {
	return toXQueryString("");
    }
}
