// Play wav Graphic Interface
// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.text.*;

import javax.sound.sampled.*;
import javax.sound.midi.*;

import java.io.*;

/**
 * ꤵ줿wavޤ(Threadб)
 *
 * <p>wavեstart/end timeȤ˲ޤ</p>
 * <p>ƥȲե</p>
 * <pre>java.lang.IllegalArgumentException:<br/>
 * No line matching interface Clip supporting format <br/>
 * PCM_SIGNED, 16000.0 Hz, 16 bit, mono, little-endian, <br/>
 * audio data, and buffers of 23715232 to 23715232 bytes is supported.<br/>
 * </pre>
 * <p>ʤΤClipϻǰʤȤʤ褦ǤˤҤȤĤβե
 * 礭ΤClipܤǤ礦</p>
 */
public class UIPlay
    extends Thread
    implements java.awt.event.ActionListener
{
    /**
     * log4j logger
     */
    static Logger logger =
	Logger.getLogger(UIPlay.class);

    /**
     * Window
     */
    JFrame playDialog = null;
    
    /**
     * Thread
     */
    Thread playThread = null;
    
    /**
     * Хåե
     */
    private static final int EXTERNAL_BUFFER_SIZE = 65536;
    
    /**
     * Window¾ν
     */
    public UIPlay()
    {
	logger.debug("UIPlay - entering");
	
	// ߥξ (debug)
	Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
	for (int i = 0;i < mixerInfo.length; i++)
	    {
		logger.debug("UIPlay - device[" + i + "] " +
			     mixerInfo[i].getName() +
			     mixerInfo[i].getVendor());
	    }
	
	logger.debug("UIPlay - exiting");
	return ;
    }
    
    /**
     * ꤵ줿FilestartstopޤǤޤ
     * 
     * <p>ޤ֤ޤThreadƤФޤ</p>
     * <p>⤷stop&lt;startästop=0ʻϺǸޤǺޤ</p>
     * <p> http://www.hellohiro.com/sound.htm</p>
     *
     * @param FileName оݥե̾
     * @param start ϲս(microseconds)
     * @param stop ߲ս(microseconds)
     */
    public void play(String fileName,
		     long start,
		     long stop)
    {
	if (fileName == null)
	    {
		fileName = "";
	    }
	
	logger.debug("play - entering " + fileName + " " +
		     start + "ms -> " + stop + "ms");
	File soundFile = null;
	try
	    {
		soundFile = new File(fileName);
	    }
	catch (NullPointerException e)
	    {
		// ե뤬Ĥʤϲǥå餷
		return ;
	    }
	
	// ǥϥȥ꡼ޤ
	AudioInputStream audioInputStream = null;
	try
	    {
		audioInputStream =
		    AudioSystem.getAudioInputStream(soundFile);
	    }
	catch(Exception e)
	    {
		// ե뤬ʤȤPermissionʤȤ
		logger.error("play - getAudioInputStream failed: file open/read error: "
			     + fileName + ".");
		return ;
	    }
	// ǥޤ
	AudioFormat audioFormat =
	    audioInputStream.getFormat();
	
	logger.info("play - audio format of " + fileName + ": " +
		    audioFormat.toString());
	
	// ǡ饤ξ󥪥֥Ȥޤ
	DataLine.Info info =
	    new DataLine.Info(SourceDataLine.class,audioFormat);

	// ꤵ줿ǡ饤˰פ饤ޤ
	SourceDataLine line = null;
	try
	    {
		line = (SourceDataLine) AudioSystem.getLine(info);
		// ꤵ줿ǥǥ饤򳫤ޤ
		line.open(audioFormat);
		// 饤ǤΥǡϤǽˤޤ
		line.start();
		
		// seek
		// float getFrameRate()
		// int getFrameSize()
		// ˵դʤڤΤƤ
		
		// 㤨мʸǤ10SEEKޤ
		// audioInputStream.skip(
		//   10*audioFormat.getChannels()*
		//      (long)(audioFormat.getFrameSize()*audioFormat.getFrameRate()));
		
		logger.debug("play - (int)channel / (float)rate / (int)size = " +
			     audioFormat.getChannels() + " / " + audioFormat.getFrameRate() +
			     " / " + audioFormat.getFrameSize() + "");
		
		float seek = start * ((float)audioFormat.getChannels()) *
		    ((float)audioFormat.getFrameSize()) *
		    audioFormat.getFrameRate();
		
		int seekAvail = audioInputStream.available();
		logger.debug("play - seek available:" + seekAvail + " byte(s)");
		logger.debug("play - seek try:" + (long)(seek/1000) + " byte(s)");
		// աblackdown-jre 1.4.2ϡseekޤ
		long seeked = audioInputStream.skip((long)(seek/1000));
		logger.debug("play - seek done:" + seeked + " byte(s)");
		
		// Ȥɤ뤫
		float frest = (stop - start) * ((float)audioFormat.getChannels()) *
		    ((float)audioFormat.getFrameSize()) *
		    audioFormat.getFrameRate();
		long rest = (long)(frest/1000);
		logger.debug("play - rest " + (long)(rest/1000) + " byte(s)");
		
		int nBytesRead = 0;
		byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
		int read = 0;
		
		while (true)
		    {
			// ⤷߲ս꤬ϲսʤ
			// ǸޤǺ
			if (rest <= 0)
			    {
				read = abData.length;
			    }
			// ߲ս꤬ä
			else
			    {
				// Ĥ꤬Хåե礭äᤤäѤɤ
				if (rest > abData.length)
				    {
					read = abData.length;
					rest = rest - abData.length;
				    }
				// Ĥ꤬Хåեʲʤ餽ɤ
				else
				    {
					read = (int)rest;
					rest = 0;
				    }
			    }
			
			// ǥȥ꡼फǡɤ߹ߤޤ
			// إåϵˤʤɤ褦Ǥ
			nBytesRead = audioInputStream.read(abData, 0, read);
			if (nBytesRead >= 0)
			    {
				// ǥǡߥ˽񤭹ߤޤ
				int nBytesWritten = line.write(abData, 0, nBytesRead);
				logger.debug("play - line.write " + nBytesRead + " rest:" + rest);
			    }
			
			if (nBytesRead < abData.length)
			    {
				break;
			    }
		    }
		
		// 饤󤫤饭塼äƤǡӽФޤ
		line.drain();
		// 饤Ĥޤ
		line.close();
	    }
	catch (Exception e)
	    {
		logger.error("play - line failed ?");
		return ;
	    }
	
	return ;
    }
    
    /**
     * ܥ󤬲줿ʤɤLISTENER
     */
    public void actionPerformed(ActionEvent e)
    {
	String action = e.getActionCommand();
	if (action.equals("CancelDoc"))
	    {
		return ;
	    }
	else
	    {
		return ;
	    }
    }
}
