// Copyright (C) 2004 Teru KAMOGASHIRA

package jp.go.kokken.Ankou;

import org.apache.log4j.Logger;

import java.util.Vector;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.text.*;

/**
 * Selector's class like LUW, SUW, IPU...
 * include Button + TextArea + some windows
 */
public class UISelect
    implements java.awt.event.ActionListener,
	       javax.swing.event.TreeSelectionListener,
	       javax.swing.event.ListSelectionListener
{
    /**
     * log4j logger
     */
    static Logger logger =
	Logger.getLogger(UIElement.class);

    static final String ROOT_NAME = "(ɽ)";
    boolean isTreeLocked = false;
    
    JFrame dialog;
    String elementString = "";
    String elementTextString = "";
    
    // for main dialog
    JToggleButton elementButton = null;
    JTextArea attributeArea = null;
    JScrollPane inputArea = null;
    
    // for option dialog
    JTree tree = null;
    JList list = null;
    JComboBox select = null;
    
    // ٤ƻȤΤˤʤʤΤǺ
    // ̤Τޤ...Interfaceפʤʤ롩
    // String[] selectMenu = {"", "preceding", "following",
    // "preceding-sibling", "following-sibling",};
    
    // Tree Holder?
    DefaultTreeModel treeModel;

    Vector attributes = null;
    
    // depth of the tree (ex. Talk=0 IPU=1 LUW=2...)
    int depth = 0;
    // # in the same depth (ex. LUW=0, Noise=1...)
    int number = 0;
    
    /**
     * initialize UI Element by Element name and Attibutes.
     *
     * @param d depth of the element in the tree.
     * @param n # of the element in the same depth.
     * @param elementName XML's english element name.
     * @param elementText XML's japanese element name which is printed
     *                    on the Button.
     * @param attributesList vector<String> of the names of the attributes of
     *                       the element.
     * @param attributesTextsList japanese version of the AttributesList.
     */
    public UISelect(int d, int n,
		     String elementName,
		     String elementText,
		     Vector attributesList,
		     Vector attributesTextsList)
    {
	logger.debug("UISelect - entering " + elementName + " " + elementText);
	
	// first, intialize
	depth = d;
	number = n;
	elementString = elementName;
	elementTextString = elementText;
	elementButton = new JToggleButton(elementTextString);
	elementButton.addActionListener(this);
	
	attributeArea = new JTextArea();
	attributeArea.setRows(2);
	attributeArea.setColumns(10);
	attributeArea.setEditable(false);
	inputArea = new JScrollPane(attributeArea);
	
	attributes = new Vector();
	
	String tip = "<html>°";
	
	if (attributesList != null&&attributesTextsList != null&&
	    attributesList.size() == attributesTextsList.size())
	    {
		// foreach(List) do InsertRecord
		for (int i = 0;i < attributesList.size();i ++)
		    {
			attributes.addElement((String)attributesTextsList.get(i) +
					      "(" +
					      (String)attributesList.get(i) +
					      ")");
			tip = tip + "<p>" +
			    (String)attributesTextsList.get(i) +
			    "(" +
			    (String)attributesList.get(i) +
			    ")";
		    }
		tip = tip + "</html>";
		elementButton.setToolTipText(tip);
	    }	
	// then, make dialog
	makeDialog();
	
	logger.debug("UISelect - exiting");
	return ;
    }
    
    private void toggleDialog()
    {
	if (elementButton.isSelected())
	    {
		dialog.setVisible(true);
	    }
	else
	    {	
		dialog.setVisible(false);
	    }
	return ;
    }
    
    private void makeDialog()
    {
	dialog = new JFrame();
	dialog.setTitle("ɽ - " + elementTextString 
			+ "(" + elementString + ")");
        dialog.setSize(500,600);
	

	// initialize tree
	DefaultMutableTreeNode rootTreeNode =
	    new DefaultMutableTreeNode(ROOT_NAME);
	treeModel = new DefaultTreeModel(rootTreeNode);
	tree = new JTree(treeModel);
	tree.addTreeSelectionListener(this);
	// Editable -> strange exception handling
	tree.setRootVisible(true);
	// Editable -> many errors
	tree.setEditable(false);
	
	JScrollPane scrollPane = new JScrollPane();
	scrollPane.getViewport().setView(tree);
	
	// initialize JList
	list = new JList(attributes);
	list.addListSelectionListener(this);
	
	JScrollPane scrollPane2 = new JScrollPane();
	scrollPane2.getViewport().setView(list);
	
	// install UI
	GridBagLayout gridBagDialog = new GridBagLayout();
	dialog.getContentPane().setLayout(gridBagDialog);
	
	GridBagConstraints gbc = new GridBagConstraints();	
	
	gbc.gridx = 0;
	gbc.gridy = 0;
	gbc.gridwidth  = 2;
	gbc.gridheight = 5;
	gbc.weightx = 2;
	gbc.weighty = 1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gbc.fill = GridBagConstraints.BOTH;
	gridBagDialog.setConstraints(scrollPane, gbc);
	dialog.getContentPane().add(scrollPane);
	
	JLabel note2 = new JLabel("ɽ°μ");
	note2.setFont(new Font("SansSerif",Font.PLAIN,14));
	note2.setOpaque(false);
	gbc.gridx = 2;
	gbc.gridy = 1;
	gbc.gridwidth = 2;
	gbc.gridheight = 1;
	gbc.weightx = 1;
	gbc.weighty = 0.1;
	gbc.insets = new Insets(0, 0, 0, 0);
	gbc.fill = GridBagConstraints.NONE;
	gridBagDialog.setConstraints(note2, gbc);
	dialog.getContentPane().add(note2);
	
	gbc.gridx = 2;
	gbc.gridy = 2;
	gbc.gridwidth = 2;
	gbc.gridheight = 2;
	gbc.weightx = 1;
	gbc.weighty = 2;
	gbc.insets = new Insets(4, 4, 4, 4);
	gbc.fill = GridBagConstraints.BOTH;
	gridBagDialog.setConstraints(scrollPane2, gbc);
	dialog.getContentPane().add(scrollPane2);	
	
	// select = 켫Ρĸ ... by PullDownMenu
	/*
	  select = new JComboBox(selectMenu);
	  select.addActionListener(this);
	  select.setEditable(false);
	  gbc.gridx = 2;
	  gbc.gridy = 4;
	  gbc.gridwidth  = 1;
	  gbc.gridheight = 1;
	  gbc.weightx = 1;
	  gbc.weighty = 0.1;
	  gbc.insets = new Insets(4, 4, 4, 4);
	  gridBagDialog.setConstraints(select, gbc);
	  dialog.getContentPane().add(select);
	*/

	JButton ok = new JButton("Ĥ");
	ok.setActionCommand("Ok");
	ok.addActionListener(this);
	gbc.gridx = 3;
	gbc.gridy = 4;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.weightx = 1;
	gbc.weighty = 0.1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(ok, gbc);
	dialog.getContentPane().add(ok);
	
	JButton add = new JButton("ɽΤɲ");
	add.setActionCommand("Add");
	add.addActionListener(this);
	gbc.gridx = 2;
	gbc.gridy = 0;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.weightx = 1;
	gbc.weighty = 0.1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(add, gbc);
	dialog.getContentPane().add(add);
	
	JButton delete = new JButton("");
	delete.setActionCommand("Delete");
	delete.addActionListener(this);
	gbc.gridx = 3;
	gbc.gridy = 0;
	gbc.gridwidth  = 1;
	gbc.gridheight = 1;
	gbc.weightx = 1;
	gbc.weighty = 0.1;
	gbc.insets = new Insets(4, 4, 4, 4);
	gridBagDialog.setConstraints(delete, gbc);
	dialog.getContentPane().add(delete);
	
	// Place dialog window at the center.
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension frameSize = dialog.getSize();
	if (frameSize.height > screenSize.height)
	    {
		frameSize.height = screenSize.height;
	    }
	if (frameSize.width > screenSize.width)
	    {
		frameSize.width = screenSize.width;
	    }
	dialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	
        /* specify what to do when [X] was clicked */
	dialog.addWindowListener(new WindowAdapter()
	    {
                public void windowClosing(WindowEvent evt)
		{
		    elementButton.setSelected(false);
		    dialog.setVisible(false);
		}
            }
				 );
	return ;
    }
    
    /**
     * The element of the tree was selected.
     */
    public void valueChanged(TreeSelectionEvent e)
    {
	JTree tree = (JTree)e.getSource();
	DefaultMutableTreeNode node =
	    (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
	if (node == null)
	    {
		return ;
	    }
	
	// lock listener of the Items
	isTreeLocked = true;
	refreshItems(node);
	isTreeLocked = false;
	return ;
    }
    
    /**
     * The element Button was pressed.
     */
    public void actionPerformed(ActionEvent e)
    {
	if (e.getSource() == elementButton)
	    {
		toggleDialog();
		return ;
	    }
	String action = e.getActionCommand();
	if (action.equals("Ok"))
	    {
		elementButton.setSelected(false);
		dialog.setVisible(false);
		return ;
	    }
	// Tree control buttons (BUG?)
	else
	    {
		// get selected path in the Tree
		TreePath path = null;
		path = tree.getSelectionPath();
		
		// 򤵤ƤʤưŪ˥롼Ȥ򤷤صϤ		
		if (path == null)
		    {	
			// λϡֲä
			if (action.equals("Delete"))
			    {
				tree.setSelectionPath(tree.getPathForRow(tree.getRowCount()-1));
			    }
			// ɲäλϥ롼ȡ
			else
			    {
				tree.setSelectionPath(tree.getPathForRow(0));
			    }
			path = tree.getSelectionPath();
		    }
		
		DefaultMutableTreeNode lastPath = 
		    (DefaultMutableTreeNode)path.getLastPathComponent();
		
		if (action.equals("Delete"))
		    {
			lastPath.removeFromParent();
			treeModel.reload();
		    }
		else if (action.equals("Add"))
		    {
			int cnt = path.getPathCount();
			
			// Check if the Parent is OR or AND or ROOT_NAME
			// parent = ROOT
			if (cnt != 0)
			    {
				String parent = path.getPathComponent(cnt-1).toString();
				// Ǥ򤷤ޤޤλ롼Ȥ򤷤ʤ
				if (!parent.equals(ROOT_NAME))
				    {
					tree.setSelectionPath(tree.getPathForLocation(0,0));
					path = tree.getSelectionPath();
					lastPath = 
					    (DefaultMutableTreeNode)path.getLastPathComponent();
				    }
			    }
			
			if (attributes.size() < 0)
			    {
				JOptionPane.showMessageDialog(dialog.getContentPane(),
							      "ä°Ĥޤ\n");
				return ;
			    }
			lastPath.add(new DefaultMutableTreeNode("@" + (String)attributes.get(0)));
			treeModel.reload();
		    }
		else
		    {
			;
		    }

		// update Text in the main interface
		updateText();
	    }
	return ;
    }
    
    /**
     * List was changed.
     * update Tree's element
     */
    public void valueChanged(ListSelectionEvent e)
    {
	// When the element in the tree is selected,
	// this function is called, so I have to
	// check it and stop changing values
	// in the Items.
	if (isTreeLocked)
	    {
		return ;
	    }

	if (e.getValueIsAdjusting())
	    {
		return ;
	    }
	
	JList theList = (JList)e.getSource();
	
	if (theList.isSelectionEmpty())
	    {
		theList.setSelectedIndex(0);
	    }
	
	DefaultMutableTreeNode node =
	    (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
	updateTreeElement();
	return ;
    }

    /**
     * Select was changed.
     * update Tree's element
     */
    public void valueChanged()
    {
	updateTreeElement();
	return ;
    }
    
    /**
     * Auto convert String into 'String'
     * String -> 'String'
     * 'String' -> 'String'
     * number -> number
     */
    private String autoConvertString(String str)
    {
	String convertedString = "";
	if(str.length() < 1)
	    return "\'\'";
	if(str.length() == 1&&str.charAt(0) == '\'')
	    return "\'\'";
	// check if the given STR is number.
	try
	    {
		Double.parseDouble(str);
	    }
	catch(java.lang.NumberFormatException e)
	    {
		// STR is not a number.
		if (str.charAt(0) != '\'')
		    {
			convertedString = "\'" + str;
		    }
		else
		    {
			convertedString = str;
		    }

		if (str.charAt(str.length()-1) != '\'')
		    {
			convertedString = 
			    convertedString + "\'";
		    }
		return convertedString;
	    }
	// STR is a number.
	return str;
    }
    
    /**
     * ĥ꡼Click줿˼¹Ԥޤ
     * ꥹȤ򹹿ޤ
     * Collect info from List/Text/Not/Select and update element.
     */
    private void refreshItems(DefaultMutableTreeNode selectedNode)
    {
	logger.debug("refreshItems - entering " + selectedNode);
	// Refresh: 1,2,3,4
	String temp;
	
	// 1.JList List
	// @
	Object attr =
	    selectedNode.toString().substring(1, selectedNode.toString().length());
	int index = attributes.indexOf(attr);
	logger.debug("refreshItems - select: "+ attr);
	list.setSelectedIndex(index);
	
	logger.debug("refreshItems - exiting ");
	return ;
    }
    
    /**
     * Collect info from List/Text/Not/Select and update element.
     */
    private void updateTreeElement()
    {
	// When the element in the tree is selected,
	// this function is called, so I have to
	// check it and stop changing values
	// in the Items.
	if (isTreeLocked)
	    {
		return ;
	    }
	
	// get selected path in the Tree
	TreePath path = null;
	path = tree.getSelectionPath();
	if (path == null)
	    {
		JOptionPane.showMessageDialog(dialog.getContentPane(),
					      "Ǥ򤵤Ƥޤ\nǤ򤷤Ƥ\n");
		return ;
	    }
	int cnt = path.getPathCount();
	StringBuffer sb = new StringBuffer();
	for (int i = 0; i < cnt; i++)
	    {
		String s =
		    path.getPathComponent(i).toString();
		sb.append(s);
		if (i + 1 != cnt)
		    sb.append("/");
	    }
	
	// and check operation to ROOT node
	if (sb.toString().equals(ROOT_NAME))
	    {
		JOptionPane.showMessageDialog(dialog.getContentPane(),
					      "롼ȤФϤǤޤ\nҤ򤷤Ƥ\n");
		return ;
	    }
	
	String newElementString = "";
	newElementString =
	    "@" + list.getSelectedValue();
	
	// Then, update selected element
	DefaultMutableTreeNode lastPath = 
	    (DefaultMutableTreeNode)path.getLastPathComponent();
	
	// replace node string
	lastPath.setUserObject(newElementString);
	treeModel.reload();
	// select automatically again :-)
	tree.setSelectionPath(path);

	// update Text in the main interface
	updateText();

	return ;
    }

    /**
     * Listʸ
     * __\nưŪ˲äޤ
     * 
     * @param prefix 줾Ǥ˲äʸ
     * @param postfix 줾Ǥθ˲äʸ
     * @param sep 줾Ǵ֤Τ˲äʸ ǸǸˤ
     *                դޤ
     * @return prefix+ELEMENT+postfix+(,)+"\n" ...
     */
    public String buildStringFromList(String prefix,
				      String postfix,
				      String sep)
    {
	return buildStringFromList(prefix, postfix, sep, 0);
    }
    
    /**
     * Listʸ
     * __\nưŪ˲äޤ
     * 
     * @param prefix 줾Ǥ˲äʸ
     * @param postfix 줾Ǥθ˲äʸ
     * @param sep 줾Ǵ֤Τ˲äʸ ǸǸˤ
     *                դޤ
     * @param mode mode=0λܸ(Ѹ)򡢤ʳλ
     *             ñ˱Ѹ֤ޤ
     * @return prefix+ELEMENT+postfix+(,)+"\n" ...
     */
    public String buildStringFromList(String prefix, String postfix, String sep, int mode)
    {
	// compile tree and update JTextArea
	// get selected path in the Tree	
	TreePath path = tree.getPathForLocation(0, 0);
	DefaultMutableTreeNode root = 
	    (DefaultMutableTreeNode)path.getLastPathComponent();
	if (root.isLeaf())
	    {
		return "";
	    }
	String texts = "";
	for (int i = 0;i < root.getChildCount();i ++)
	    {
		String child = root.getChildAt(i).toString();
		if (mode == 0)
		    {
			child = root.getChildAt(i).toString();
		    }
		else
		    {
			child = "@" + QueryCompiler.getInsideBrace(root.getChildAt(i).toString());
		    }
		if (i != root.getChildCount()-1)
		    {
			texts = texts +
			    prefix + child + postfix + sep + "\n";
		    }
		else
		    {
			texts = texts +
			    prefix + child + postfix + "\n";
		    }
	    }
	return texts;
    }

    /**
     * ᥤ󥦥ɥɽɽ
     * 򹹿
     * 
     * This function must be called when the
     * text in the sub window are changed.
     */
    public void updateText()
    {
	// compile tree and update JTextArea
	// get selected path in the Tree	
	TreePath path = tree.getPathForLocation(0, 0);
	DefaultMutableTreeNode root = 
	    (DefaultMutableTreeNode)path.getLastPathComponent();
	attributeArea.setText(buildStringFromList("", "", ","));
	attributeArea.setToolTipText("<html>" +
				     buildStringFromList("<p>", "", ",") +
				     "</html>");
	return ;
    }
    
    /**
     * JTreeξ֤DOMѴ
     */
    public org.w3c.dom.Element toNode()
    {
	TreeDOM treeDOM = new TreeDOM();
	return treeDOM.treeNodeToNode((DefaultMutableTreeNode)treeModel.getRoot());
    }

    /**
     * JTreeξ֤Ƹ
     */
    public void loadNode(org.w3c.dom.Node node)
    {
	TreeDOM treeDOM = new TreeDOM();
	treeModel.setRoot(treeDOM.nodeToTreeNode(node));
	
	treeModel.reload();
	// update Text in the main interface
	updateText();
	return ;
    }

    public String toString()
    {
	return buildStringFromList("","","");
    }
}
