// -*- C++ -*-
#ifndef _word_h_included_
#define _word_h_included_

#include <list>
#include "misc.h"

class Ident;
class Stamp;
class Attr;
class Word;

class Sign {
public:
  Sign(Stamp stamp, const char *user, bool is_ok);
  char *m_user;
  Stamp m_stamp;
  bool m_is_ok;

  //
  Attr *m_owner;
};

class Attr {
public:
  Attr(Word *w, const char *a);
  char *m_attr;
  std::list<Sign *> m_signs;

  Sign *add_sign(const char *user, Stamp stamp, bool ok);

  //
  Word *m_owner;
};

class Word {
public:
  char *m_index;
  char *m_word;
  std::list<Attr *> m_attrs;

  Attr *find_attr(const char *attr);
};

void init_word();
void set_encoding(const char *encoding);
char *to_utf8(const char *w);
int word_hash(const char *idx, const char *word);


#endif
