#include <stdio.h>
#include "context.h"

static struct {
  int key;
  char *str;
} key_tab[] = {
  {UKey_Backspace, "backspace"},
  {UKey_Delete, "delete"},
  {UKey_Escape, "escape"},
  {UKey_Return, "return"},
  {UKey_Tab, "tab"},
  {UKey_Left, "left"},
  {UKey_Up, "up"},
  {UKey_Right, "right"},
  {UKey_Down, "down"},
  {UKey_Prior, "prior"},
  {UKey_Next, "next"},
  {UKey_Home, "home"},
  {UKey_End, "end"},
  {UKey_Zenkaku_Hankaku, "zenkaku-hankaku"},
  {0,0}
};

int
uim_key_sym_to_int(LISP sym_)
{
  char *sym = uim_get_c_string(sym_);
  int res = 0;
  int i;
  for (i = 0; key_tab[i].key; i++) {
    if (!strcmp(key_tab[i].str,sym)) {
      res = key_tab[i].key;
    }
  }
  free(sym);
  return res;
}

static char *
get_sym(int key)
{
  int i;
  char *res = NULL;
  for (i = 0; key_tab[i].key; i++) {
    if (key_tab[i].key == key) {
      res = key_tab[i].str;
    }
  }
  return res;
}

static int
keycode_to_sym(int key, char *buf)
{
  char *s = get_sym(key);
  if (!s) {
    if (key > 128) {
      return -1;
    }
    snprintf(buf, 19, "%d", key);
  } else {
    snprintf(buf, 19, "'%s", s);
  }
  return 0;
}

static void
handle_key(uim_context uc, char *p, int key, int state)
{
  char buf[100];
  char keybuf[20];
  int rv;

  rv = keycode_to_sym(key, keybuf);
  if (rv == -1) {
    return;
  }
  snprintf(buf, 99, "(key-%s-handler %d %s %d)", p,
	   uc->id, keybuf, state);
  uim_eval_string(uc, buf);
}

int
uim_press_key(uim_context uc, int key, int state)
{
  uc->commit_raw_flag = 0;
  handle_key(uc, "press", key, state);
  return uc->commit_raw_flag;
}

int
uim_release_key(uim_context uc, int key, int state)
{
  uc->commit_raw_flag = 0;
  handle_key(uc, "release", key, state);
  return uc->commit_raw_flag;
}
