/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;

public class FontLoader {
    private Map<String, TrueTypeFont> fonts = new HashMap<String, TrueTypeFont>();
    private Map<TrueTypeFont, File> files = new HashMap<TrueTypeFont, File>();

    public FontLoader(File fontDir) {
        this.load(fontDir);
        TrueTypeFont serif = this.get("YuMincho-Regular");
        TrueTypeFont serifBold = this.get("YuMincho-Demibold");
        TrueTypeFont sansSerif = this.get("YuGothic-Regular");
        TrueTypeFont sansSerifBold = this.get("YuGothic-Bold");
        if (serif != null && serifBold != null && sansSerif != null && sansSerifBold != null) {
            try {
                this.register("serif", serif);
                this.register("serif-Bold", serifBold);
                this.register("sansSerif", sansSerif);
                this.register("sansSerif-Bold", sansSerifBold);
                this.register("sans-Serif", sansSerif);
                this.register("sans-Serif-Bold", sansSerifBold);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<TrueTypeFont> listFonts() {
        ArrayList<TrueTypeFont> list = new ArrayList<TrueTypeFont>(this.fonts.values());
        Collections.sort(list, new Comparator<TrueTypeFont>(){

            @Override
            public int compare(TrueTypeFont o1, TrueTypeFont o2) {
                try {
                    return o1.getName().compareTo(o2.getName());
                }
                catch (IOException e) {
                    return 0;
                }
            }
        });
        return list;
    }

    public TrueTypeFont get(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        TrueTypeFont ttf = this.fonts.get(this.normalize(name));
        if (ttf != null) {
            return ttf;
        }
        ttf = this.fonts.get(this.normalize(name + "-Regular"));
        if (ttf != null) {
            return ttf;
        }
        ttf = this.fonts.get(this.normalize(name + "-\u6a19\u6e96"));
        if (ttf != null) {
            return ttf;
        }
        return null;
    }

    public File getFile(TrueTypeFont ttf) throws IOException {
        return this.files.get(ttf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File dir) {
        File[] ttcFiles;
        File[] ttfFiles;
        TTFParser parser = new TTFParser();
        for (File file : ttfFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttf");
            }
        })) {
            try {
                TrueTypeFont ttf = parser.parse(file);
                this.register(ttf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (final File file : ttcFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttc");
            }
        })) {
            TrueTypeCollection ttc = null;
            try {
                ttc = new TrueTypeCollection(file);
                ttc.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    public void process(TrueTypeFont ttf) throws IOException {
                        FontLoader.this.register(ttf);
                        FontLoader.this.files.put(ttf, file);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (ttc != null) {
                    try {
                        ttc.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void register(TrueTypeFont ttf) throws IOException {
        this.register(null, ttf);
    }

    public void register(String name, TrueTypeFont ttf) throws IOException {
        String postScriptName;
        if (name != null) {
            this.fonts.put(this.normalize(name), ttf);
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        String fontName = ttf.getName();
        if (fontName != null && !fontName.isBlank()) {
            names.add(this.normalize(fontName));
        }
        NamingTable table = ttf.getNaming();
        String fontFamily = table.getFontFamily();
        String fontSubFamily = table.getFontSubFamily();
        if (fontFamily != null && !fontFamily.isBlank() && fontSubFamily != null && !fontSubFamily.isBlank()) {
            names.add(this.normalize(fontFamily + "-" + fontSubFamily));
        }
        if ((postScriptName = table.getPostScriptName()) != null && !postScriptName.isBlank()) {
            names.add(this.normalize(postScriptName));
        }
        HashSet<Integer> languages = new HashSet<Integer>();
        HashMap<Integer, String> fontFamilies1 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontSubFamilies2 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontFamilies16 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontSubFamilies17 = new HashMap<Integer, String>();
        List records = table.getNameRecords();
        for (NameRecord record : records) {
            if (record.getNameId() == 1) {
                languages.add(record.getLanguageId());
                fontFamilies1.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() == 2) {
                languages.add(record.getLanguageId());
                fontSubFamilies2.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() == 16) {
                languages.add(record.getLanguageId());
                fontFamilies16.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() != 17) continue;
            languages.add(record.getLanguageId());
            fontSubFamilies17.put(record.getLanguageId(), record.getString());
        }
        for (Integer languageId : languages) {
            fontFamily = (String)fontFamilies1.get(languageId);
            if (fontFamily != null && !fontFamily.isBlank()) {
                fontSubFamily = (String)fontSubFamilies2.get(languageId);
                if (fontSubFamily != null && !fontSubFamily.isBlank()) {
                    names.add(this.normalize(fontFamily + "-" + fontSubFamily));
                } else {
                    names.add(this.normalize(fontFamily));
                }
            }
            if ((fontFamily = (String)fontFamilies16.get(languageId)) == null || fontFamily.isBlank()) continue;
            fontSubFamily = (String)fontSubFamilies17.get(languageId);
            if (fontSubFamily != null && !fontSubFamily.isBlank()) {
                names.add(this.normalize(fontFamily + "-" + fontSubFamily));
                continue;
            }
            names.add(this.normalize(fontFamily));
        }
        for (String s : names) {
            this.fonts.put(s, ttf);
        }
    }

    private String normalize(String name) {
        String s = name.replace('\t', '-').replace('\u3000', '-').replace(' ', '-').toLowerCase();
        while (s.contains("--")) {
            s = s.replace("--", "-");
        }
        s = Normalizer.normalize(s, Normalizer.Form.NFKC);
        Object[] tokens = s.split("-");
        Arrays.sort(tokens);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            sb.append((String)tokens[i]);
            if (i + 1 >= tokens.length) continue;
            sb.append('-');
        }
        return sb.toString();
    }
}

