/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.instruction;

import java.util.List;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.instruction.Instruction;

public class Box
extends Instruction {
    private double p1;
    private double p2;
    private double p3;
    private double p4;

    public Box(int indent, List<Object> params) {
        super(indent, params);
        if (params.size() != 4) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(0) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(1) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(2) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(3) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        this.p1 = ((Number)params.get(0)).doubleValue();
        this.p2 = ((Number)params.get(1)).doubleValue();
        this.p3 = ((Number)params.get(2)).doubleValue();
        this.p4 = ((Number)params.get(3)).doubleValue();
    }

    @Override
    public void process(PdfBrewer brewer, Context context) {
        double bottom;
        double right;
        Context parent = context.getParent();
        double left = this.p1 >= 0.0 ? parent.getLeft() + this.p1 : parent.getRight() + this.p1;
        double top = this.p2 >= 0.0 ? parent.getTop() + this.p2 : parent.getBottom() + this.p2;
        if (this.p3 > 0.0) {
            right = left + this.p3;
        } else if (this.p1 < 0.0) {
            right = left;
            left += this.p3;
        } else {
            right = parent.getRight() + this.p3;
        }
        if (this.p4 > 0.0) {
            bottom = top + this.p4;
        } else if (this.p2 < 0.0) {
            bottom = top;
            top += this.p4;
        } else {
            bottom = parent.getBottom() + this.p4;
        }
        context.setBox(left, top, right, bottom);
    }
}

