/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.cui;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.osdn.aoiro.AccountSettlement;
import net.osdn.aoiro.ErrorMessage;
import net.osdn.aoiro.Util;
import net.osdn.aoiro.loader.yaml.AccountTitlesLoader;
import net.osdn.aoiro.loader.yaml.JournalEntriesLoader;
import net.osdn.aoiro.loader.yaml.ProportionalDivisionsLoader;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.ProportionalDivision;
import net.osdn.aoiro.report.BalanceSheet;
import net.osdn.aoiro.report.GeneralJournal;
import net.osdn.aoiro.report.GeneralLedger;
import net.osdn.aoiro.report.ProfitAndLoss;
import net.osdn.aoiro.report.StatementOfChangesInEquity;
import net.osdn.aoiro.report.layout.BalanceSheetLayout;
import net.osdn.aoiro.report.layout.ProfitAndLossLayout;
import net.osdn.aoiro.report.layout.StatementOfChangesInEquityLayout;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.util.io.AutoDetectReader;

public class Main {
    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        try {
            File fontDir;
            Path inputDir;
            boolean skipSettlement = false;
            boolean showMonthlyTotal = false;
            Boolean isSoloProprietorship = null;
            String filename = null;
            if (args.length >= 1) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-o")) {
                        skipSettlement = true;
                    }
                    if (args[i].equals("-m")) {
                        showMonthlyTotal = true;
                    }
                    if (args[i].equals("-p")) {
                        isSoloProprietorship = Boolean.TRUE;
                    }
                    if (!args[i].equals("-c")) continue;
                    isSoloProprietorship = Boolean.FALSE;
                }
                filename = args[args.length - 1];
            }
            if (filename == null) {
                System.out.println("Usage: aoiro.exe <options> <\u4ed5\u8a33\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb>");
                System.out.println("Options:");
                System.out.println("  -o    \u6c7a\u7b97\u51e6\u7406\u3092\u305b\u305a\u306b\u4ed5\u8a33\u5e33\u3068\u7dcf\u52d8\u5b9a\u5143\u5e33\u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
                System.out.println("  -m    \u7dcf\u52d8\u5b9a\u5143\u5e33\u306b\u6708\u8a08\u3092\u5370\u5b57\u3057\u307e\u3059\u3002");
                System.out.println("  -p    \u500b\u4eba\u4e8b\u696d\u4e3b\u7528\u306e\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                System.out.println("  -c    \u6cd5\u4eba\u7528\u306e\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                System.out.println();
                Main.pause();
                return;
            }
            Path journalEntryPath = Paths.get(filename, new String[0]);
            if (!Files.exists(journalEntryPath, new LinkOption[0]) || Files.isDirectory(journalEntryPath, new LinkOption[0])) {
                System.err.println("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + journalEntryPath);
                Main.pause();
                return;
            }
            journalEntryPath = journalEntryPath.toAbsolutePath().normalize();
            if (isSoloProprietorship == null) {
                isSoloProprietorship = Main.isSoloProprietorship(journalEntryPath);
            }
            Path defaultDir = Util.getApplicationDirectory().resolve("default");
            if (isSoloProprietorship.booleanValue()) {
                System.out.println("\u6b21\u306e\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u3066\u51e6\u7406\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
                defaultDir = defaultDir.resolve("\u500b\u4eba");
            } else {
                System.out.println("\u6b21\u306e\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u3066\u51e6\u7406\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
                defaultDir = defaultDir.resolve("\u6cd5\u4eba");
            }
            Path outputDir = inputDir = journalEntryPath.getParent();
            int processNumber = 0;
            Path accountTitlesPath = Main.getAccountTitlePath(inputDir, defaultDir);
            if (accountTitlesPath == null) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] \u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: \u52d8\u5b9a\u79d1\u76ee.yml");
            }
            System.out.println(" (" + ++processNumber + ") \u52d8\u5b9a\u79d1\u76ee | " + accountTitlesPath);
            AccountTitlesLoader accountTitlesLoader = new AccountTitlesLoader(accountTitlesPath);
            Set<AccountTitle> accountTitles = accountTitlesLoader.getAccountTitles();
            Path proportionalDivisionsPath = null;
            if (isSoloProprietorship.booleanValue() && (proportionalDivisionsPath = Main.getProportionalDivisionsPath(inputDir, defaultDir)) == null) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] \u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: \u5bb6\u4e8b\u6309\u5206.yml");
            }
            List<ProportionalDivision> proportionalDivisions = null;
            if (proportionalDivisionsPath != null) {
                System.out.println(" (" + ++processNumber + ") \u5bb6\u4e8b\u6309\u5206 | " + proportionalDivisionsPath);
                ProportionalDivisionsLoader proportionalDivisionsLoader = new ProportionalDivisionsLoader(proportionalDivisionsPath, accountTitles);
                proportionalDivisions = proportionalDivisionsLoader.getProportionalDivisions();
            }
            JournalEntriesLoader journalsLoader = new JournalEntriesLoader(journalEntryPath, accountTitles);
            List<JournalEntry> journalEntries = journalsLoader.getJournalEntries();
            System.out.println(" (" + ++processNumber + ") \u4ed5\u8a33\u3000\u3000 | " + journalEntryPath + " (" + journalEntries.size() + "\u4ef6)");
            System.out.println();
            accountTitlesLoader.validate();
            if (!skipSettlement) {
                System.out.println("\u6c7a\u7b97\u51e6\u7406\u3092\u5b9f\u884c\u3057\u3066\u3044\u307e\u3059 . . .");
                AccountSettlement accountSettlement = new AccountSettlement(accountTitles, isSoloProprietorship);
                accountSettlement.setPrintStream(System.out);
                accountSettlement.addClosingEntries(journalEntries, proportionalDivisions);
                System.out.println("");
            }
            if (skipSettlement) {
                System.out.println("\u5e33\u7c3f\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059 . . .");
            } else {
                System.out.println("\u5e33\u7c3f\u3068\u6c7a\u7b97\u66f8\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059 . . .");
            }
            GeneralJournal generalJournal = new GeneralJournal(journalEntries, isSoloProprietorship);
            GeneralLedger generalLedger = new GeneralLedger(accountTitles, journalEntries, isSoloProprietorship, showMonthlyTotal);
            HashSet<String> fontFileNames = new HashSet<String>();
            if (Files.isDirectory(Util.getApplicationDirectory().resolve("fonts"), new LinkOption[0])) {
                fontDir = Util.getApplicationDirectory().resolve("fonts").toFile();
                fontFileNames.addAll(FontLoader.FILENAMES_NOTO_GOTHIC);
                fontFileNames.addAll(FontLoader.FILENAMES_NOTO_MINCHO);
                fontFileNames.addAll(FontLoader.FILENAMES_IPA_GOTHIC);
                fontFileNames.addAll(FontLoader.FILENAMES_IPA_MINCHO);
            } else {
                fontDir = FontLoader.getDefaultFontDir();
                fontFileNames.addAll(FontLoader.FILENAMES_YUGOTHIC);
                fontFileNames.addAll(FontLoader.FILENAMES_YUMINCHO);
            }
            FontLoader fontLoader = new FontLoader(fontDir, fontFileNames, null);
            generalJournal.setFontLoader(fontLoader);
            generalJournal.writeTo(outputDir.resolve("\u4ed5\u8a33\u5e33.pdf"));
            System.out.println("  \u4ed5\u8a33\u5e33.pdf \u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
            generalLedger.setFontLoader(fontLoader);
            generalLedger.writeTo(outputDir.resolve("\u7dcf\u52d8\u5b9a\u5143\u5e33.pdf"));
            System.out.println("  \u7dcf\u52d8\u5b9a\u5143\u5e33.pdf \u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
            if (!skipSettlement) {
                ProfitAndLossLayout plLayout = accountTitlesLoader.getProfitAndLossLayout();
                ProfitAndLoss pl = new ProfitAndLoss(plLayout, journalEntries, isSoloProprietorship);
                pl.setFontLoader(fontLoader);
                pl.writeTo(outputDir.resolve("\u640d\u76ca\u8a08\u7b97\u66f8.pdf"));
                System.out.println("  \u640d\u76ca\u8a08\u7b97\u66f8.pdf \u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
                BalanceSheetLayout bsLayout = accountTitlesLoader.getBalanceSheetLayout();
                BalanceSheet bs = new BalanceSheet(bsLayout, journalEntries, isSoloProprietorship);
                bs.setFontLoader(fontLoader);
                bs.writeTo(outputDir.resolve("\u8cb8\u501f\u5bfe\u7167\u8868.pdf"));
                System.out.println("  \u8cb8\u501f\u5bfe\u7167\u8868.pdf \u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
                if (!isSoloProprietorship.booleanValue()) {
                    StatementOfChangesInEquityLayout sceLayout = accountTitlesLoader.getStatementOfChangesInEquityLayout();
                    StatementOfChangesInEquity ce = new StatementOfChangesInEquity(sceLayout, journalEntries);
                    ce.setFontLoader(fontLoader);
                    ce.writeTo(outputDir.resolve("\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8.pdf"));
                    System.out.println("  \u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8.pdf \u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
                }
                if (bs.getWarnings().size() > 0) {
                    System.out.println();
                    for (String warning : bs.getWarnings()) {
                        System.out.println(warning);
                    }
                }
                System.out.println("");
                System.out.println("\u7e70\u8d8a\u51e6\u7406\u3092\u5b9f\u884c\u3057\u3066\u3044\u307e\u3059 . . .");
                bs.createNextOpeningJournalEntriesCompat(outputDir.resolve("\u6b21\u5e74\u5ea6\u306e\u958b\u59cb\u4ed5\u8a33.yml"));
                System.out.println("  \u6b21\u5e74\u5ea6\u306e\u958b\u59cb\u4ed5\u8a33.yml \u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
            }
            System.out.println();
            System.out.println("\u3059\u3079\u3066\u306e\u51e6\u7406\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        catch (ErrorMessage e) {
            System.err.println("\r\n" + e.getMessage() + "\r\n");
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace();
        }
        Main.pause();
    }

    private static Path getAccountTitlePath(Path inputPath, Path defaultPath) {
        Path path = inputPath.resolve("\u52d8\u5b9a\u79d1\u76ee.yml");
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        path = defaultPath.resolve("\u52d8\u5b9a\u79d1\u76ee.yml");
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    private static Path getProportionalDivisionsPath(Path inputPath, Path defaultPath) {
        Path path = inputPath.resolve("\u5bb6\u4e8b\u6309\u5206.yml");
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        path = defaultPath.resolve("\u5bb6\u4e8b\u6309\u5206.yml");
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    public static boolean isSoloProprietorship(Path journalEntryPath) throws IOException {
        String yaml = AutoDetectReader.readAll((Path)journalEntryPath);
        return yaml.contains("\u5143\u5165\u91d1");
    }

    private static void pause() {
        System.out.println("\u7d9a\u884c\u3059\u308b\u306b\u306fEnter\u30ad\u30fc\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044 . . .");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

