/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.instruction;

import java.io.IOException;
import java.util.List;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.Horizontal;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.Vertical;
import net.osdn.pdf_brewer.instruction.Instruction;

public class Align
extends Instruction {
    private Horizontal hAlign;
    private Vertical vAlign;

    public Align(int indent, List<Object> params) {
        super(indent, params);
        for (int i = 0; i < params.size(); ++i) {
            Object obj = params.get(i);
            if (!(obj instanceof String)) continue;
            String s = ((String)obj).toLowerCase();
            if (s.equals("left")) {
                this.hAlign = Horizontal.Left;
                continue;
            }
            if (s.equals("right")) {
                this.hAlign = Horizontal.Right;
                continue;
            }
            if (s.equals("top")) {
                this.vAlign = Vertical.Top;
                continue;
            }
            if (s.equals("bottom")) {
                this.vAlign = Vertical.Bottom;
                continue;
            }
            if (s.equals("center")) {
                if (this.hAlign == null) {
                    this.hAlign = Horizontal.Center;
                }
                if (this.vAlign != null) continue;
                this.vAlign = Vertical.Center;
                continue;
            }
            if (s.matches("h.*?center")) {
                this.hAlign = Horizontal.Center;
                continue;
            }
            if (!s.matches("v.*?center")) continue;
            this.vAlign = Vertical.Center;
        }
    }

    @Override
    public void process(PdfBrewer brewer, Context context) throws IOException {
        if (this.hAlign != null) {
            context.setHorizontalAlignment(this.hAlign);
        }
        if (this.vAlign != null) {
            context.setVerticalAlignment(this.vAlign);
        }
    }
}

