# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import gtk
import gtk.glade
import pygtk
import gobject
    
from logic import AoisoLogic


class AoisoMainWindow:
    """This is an Aoiso application"""
    
    def __init__(self):

        #Set the Glade file
        self.gladefile = "aoisora.glade" 
        self.wTree = gtk.glade.XML(self.gladefile)
        
        #Get the Main Window, and connect the "destroy" event
        self.window = self.wTree.get_widget("AoisoMainWindow")
        if (self.window):
            self.window.connect("destroy", gtk.main_quit)

        #Get Glade widgets
        self.treeView = self.wTree.get_widget("treeviewAoisoMain")
        self.editor   = self.wTree.get_widget("textviewAoisoMain")

        self.title_entry = self.wTree.get_widget("entryNodeTitle")
        
        #TreeModel
        self.model = gtk.TreeStore(gobject.TYPE_STRING,gobject.TYPE_PYOBJECT)
        column = gtk.TreeViewColumn("aaa",gtk.CellRendererText(),text=0)
        self.treeView.append_column(column)
        self.treeView.set_model(self.model)

        self.current_iter = None;

        #LogicClass
        self.logic = AoisoLogic(self.model)

        #DummyData
        self.logic.makeDummy()
        
        #Create our dictionay and connect it
        dic = { "on_treeview4_cursor_changed"  : self.showSelectedItem
                ,"on_tbtnNew_clicked"          : self.newDocument
                ,"on_mitemNew_activate"        : self.newDocument
                ,"on_mitemAppendNode_activate" : self.appendNode
                ,"on_tbtnAppendNode_clicked"   : self.appendNode
                ,"on_mitemAppendChildNode_activate" : self.appendChildNode
                ,"on_tbtnAppendChildNode_clicked"   : self.appendChildNode
                ,"on_tbtnSave_clicked"     : self.saveDocument
                ,"on_mitemSave_activate"   : self.saveDocument
                ,"on_tbtnOpen_clicked"     : self.openDocument
                ,"on_mitemOpen_activate"   : self.openDocument
                ,"on_tbtnNodeLeft_clicked" : self.moveNodeLeft
                ,"on_tbtnNodeRight_clicked" : self.moveNodeRight
                ,"on_tbtnNodeUp_clicked"    : self.moveNodeUp
                ,"on_tbtnNodeDown_clicked"  : self.moveNodeDown
                ,"on_tbtnTrashNode_clicked" : self.moveNodeTrash
                ,"on_tbtnOpenText_clicked"  : self.openText
                ,"on_mitemOpenText_activate" : self.openText
                ,"on_tbtnSaveText_clicked"   : self.saveText
                ,"on_mitemSaveText_activate" : self.saveText
                }
        self.wTree.signal_autoconnect(dic)
        self.editor.connect("event-after",self.on_editor_changed)
        self.title_entry.connect("event-after",self.on_title_entry_changed)
        
        self.treeView.set_cursor(0)


    def on_editor_changed(self,widget,event):
        #print "on_editor_changed"
        if self.current_iter==None:
            return None
        buffer = self.editor.get_buffer() 
        text = buffer.get_text(buffer.get_start_iter(),buffer.get_end_iter())
        self.logic.store_node_text(self.current_iter,text)

    def on_title_entry_changed(self,widget,event):
        #print "on_title_editor_changed"
        if self.current_iter==None:
            return None
        title = self.title_entry.get_text()
        self.logic.store_node_title(self.current_iter,title)
        
    def newDocument(self, widget):
        print "clicked!"
        self.logic.clearDocument()
        iter = self.model.append(None)
        self.logic.resetNode(iter)
        self.treeView.set_cursor(0)
        
    def showSelectedItem(self, widget):
        #print "selected!"
        model,iter = self.treeView.get_selection().get_selected()
        self.current_iter = iter
        node = model.get_value(iter,1)
        self.editor.get_buffer().set_text(node.text)
        self.title_entry.set_text(node.title)

    def appendNode(self,widget):
        print "appendNode"
        iter = self.model.insert_after(self.model.iter_parent(self.current_iter)
                                       ,self.current_iter)
        self.logic.resetNode(iter)
        self.treeView.expand_to_path(self.model.get_path(iter))
        self.treeView.get_selection().select_iter(iter)
        self.showSelectedItem(widget)
        
    def appendChildNode(self,widget):
        print "appendChildNode"
        iter = self.model.append(self.current_iter)
        self.logic.resetNode(iter)
        self.treeView.expand_to_path(self.model.get_path(iter))
        self.treeView.get_selection().select_iter(iter)
        self.showSelectedItem(widget)        
        
    def saveDocument(self,widget):
        self.logic.saveDocument()
        
    def openDocument(self,weight):
        self.logic.openDocument()
        self.treeView.set_cursor(0)

    def openText(self,widget):
        print "test1"
        self.logic.openWZText()
        self.treeView.set_cursor(0)
        
    def saveText(self,widget):
        print "test2"
        self.logic.saveWZText()
        
    def moveNodeLeft(self,widget):
        print "moveNodeLeft"

    def moveNodeRight(self,widget):
        print "moveNodeRight"

    def moveNodeUp(self,widget):
        print "moveNodeUp"

    def moveNodeDown(self,widget):
        print "moveNodeDown"

    def moveNodeTrash(self,widget):
        print "moveNodeTrash"
