#include "InOrderURISelector.h"

#include <cppunit/extensions/HelperMacros.h>

#include "Exception.h"
#include "util.h"
#include "array_fun.h"
#include "FileEntry.h"

namespace aria2 {

class InOrderURISelectorTest:public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(InOrderURISelectorTest);
  CPPUNIT_TEST(testSelect);
  CPPUNIT_TEST_SUITE_END();
private:
  FileEntry _fileEntry;

  SharedHandle<InOrderURISelector> sel;
  
public:
  void setUp()
  {
    static const char* urisSrc[] = {
      "http://alpha/file",
      "ftp://alpha/file",
      "http://bravo/file"
    };
    std::deque<std::string> uris;
    uris.assign(&urisSrc[0], &urisSrc[arrayLength(urisSrc)]);
    
    _fileEntry.setUris(uris);

    sel.reset(new InOrderURISelector());
  }

  void tearDown() {}

  void testSelect();
};


CPPUNIT_TEST_SUITE_REGISTRATION(InOrderURISelectorTest);

void InOrderURISelectorTest::testSelect()
{
  CPPUNIT_ASSERT_EQUAL(std::string("http://alpha/file"),
		       sel->select(&_fileEntry));
  CPPUNIT_ASSERT_EQUAL(std::string("ftp://alpha/file"),
		       sel->select(&_fileEntry));
  CPPUNIT_ASSERT_EQUAL(std::string("http://bravo/file"),
		       sel->select(&_fileEntry));
  CPPUNIT_ASSERT_EQUAL(std::string(""), sel->select(&_fileEntry));
}

} // namespace aria2
