#include "BtSuggestPieceMessage.h"

#include <cstring>
#include <cppunit/extensions/HelperMacros.h>

#include "bittorrent_helper.h"

namespace aria2 {

class BtSuggestPieceMessageTest:public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(BtSuggestPieceMessageTest);
  CPPUNIT_TEST(testCreate);
  CPPUNIT_TEST(testGetMessage);
  CPPUNIT_TEST(testToString);
  CPPUNIT_TEST_SUITE_END();
private:

public:
  void setUp() {
  }

  void testCreate();
  void testGetMessage();
  void testToString();
};


CPPUNIT_TEST_SUITE_REGISTRATION(BtSuggestPieceMessageTest);

void BtSuggestPieceMessageTest::testCreate() {
  unsigned char msg[9];
  bittorrent::createPeerMessageString(msg, sizeof(msg), 5, 13);
  bittorrent::setIntParam(&msg[5], 12345);
  SharedHandle<BtSuggestPieceMessage> pm = BtSuggestPieceMessage::create(&msg[4], 5);
  CPPUNIT_ASSERT_EQUAL((uint8_t)13, pm->getId());
  CPPUNIT_ASSERT_EQUAL((size_t)12345, pm->getIndex());

  // case: payload size is wrong
  try {
    unsigned char msg[10];
    bittorrent::createPeerMessageString(msg, sizeof(msg), 6, 13);
    BtSuggestPieceMessage::create(&msg[4], 2);
    CPPUNIT_FAIL("exception must be thrown.");
  } catch(...) {
  }
  // case: id is wrong
  try {
    unsigned char msg[9];
    bittorrent::createPeerMessageString(msg, sizeof(msg), 5, 14);
    BtSuggestPieceMessage::create(&msg[4], 1);
    CPPUNIT_FAIL("exception must be thrown.");
  } catch(...) {
  }
}

void BtSuggestPieceMessageTest::testGetMessage() {
  BtSuggestPieceMessage msg;
  msg.setIndex(12345);
  unsigned char data[9];
  bittorrent::createPeerMessageString(data, sizeof(data), 5, 13);
  bittorrent::setIntParam(&data[5], 12345);
  CPPUNIT_ASSERT(memcmp(msg.getMessage(), data, 9) == 0);
}

void BtSuggestPieceMessageTest::testToString() {
  BtSuggestPieceMessage msg;
  msg.setIndex(12345);

  CPPUNIT_ASSERT_EQUAL(std::string("suggest piece index=12345"),
                       msg.toString());
}

} // namespace aria2
