/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ArchiveOutputStream
extends FilterOutputStream {
    protected OutputStream frontStream;
    protected long written;
    private boolean closed;

    public ArchiveOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            throw new IllegalStateException("stream is null");
        }
        this.frontStream.write(n);
        ++this.written;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            throw new IllegalStateException("stream is null");
        }
        this.frontStream.write(byArray, n, n2);
        this.written += (long)n2;
    }

    public void flush() throws IOException {
        this.ensureOpen();
        if (this.frontStream != null) {
            this.frontStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.closed = true;
            try {
                this.out.flush();
                super.close();
            }
            finally {
                this.frontStream = null;
            }
        }
    }
}

