/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.IOException;
import java.io.OutputStream;
import jp.sourceforge.armadillo.io.BitOutputStream;
import jp.sourceforge.armadillo.lzh.HuffmanTableBuilder;
import jp.sourceforge.armadillo.lzh.LzhException;
import jp.sourceforge.armadillo.lzh.LzssEncoderWritable;

public final class LzhHuffmanEncoder
implements LzssEncoderWritable {
    private static final int BUFFER_SIZE = 4096;
    private BitOutputStream out;
    private int threshold;
    private int index;
    private int[] symbolBuffer;
    private int[] offsetBuffer;
    private int[] ct1;
    private int[] lt1;
    private int[] ct2;
    private int[] lt2;
    private int[] ct3;
    private int[] lt3;
    private int t1size;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhHuffmanEncoder(OutputStream outputStream, int n) {
        this.out = new BitOutputStream(outputStream);
        this.threshold = n;
        this.index = 0;
        this.symbolBuffer = new int[4096];
        this.offsetBuffer = new int[4096];
    }

    public void writeSymbol(int n) throws IOException {
        this.symbolBuffer[this.index++] = n;
        if (this.index >= 4096) {
            this.encode();
        }
    }

    public void writeCode(int n, int n2) throws IOException {
        if (!$assertionsDisabled && n2 < this.threshold) {
            throw new AssertionError();
        }
        this.symbolBuffer[this.index] = n2 - this.threshold + 256;
        this.offsetBuffer[this.index++] = n - 1;
        if (this.index >= 4096) {
            this.encode();
        }
    }

    public void flush() throws IOException {
        this.encode();
    }

    private void encode() throws IOException {
        if (this.index == 0) {
            return;
        }
        try {
            this.createTables();
            this.outputCodes();
        }
        catch (RuntimeException runtimeException) {
            LzhException lzhException = new LzhException("huffman encoding error");
            lzhException.initCause(runtimeException);
            throw lzhException;
        }
        finally {
            this.index = 0;
            this.ct1 = null;
            this.lt1 = null;
            this.ct2 = null;
            this.lt2 = null;
            this.ct3 = null;
            this.lt3 = null;
        }
    }

    private void createTables() {
        int n;
        int n2;
        HuffmanTableBuilder huffmanTableBuilder = new HuffmanTableBuilder();
        int[] nArray = new int[512];
        for (n2 = 0; n2 < this.index; ++n2) {
            int n3;
            int n4 = n3 = this.symbolBuffer[n2];
            nArray[n4] = nArray[n4] + 1;
        }
        huffmanTableBuilder.build(nArray);
        this.ct1 = huffmanTableBuilder.getCodeTable();
        this.lt1 = huffmanTableBuilder.getCodeLengthTable();
        this.t1size = LzhHuffmanEncoder.getTrimmedSize(this.lt1);
        n2 = LzhHuffmanEncoder.getTrimmedSize(this.lt1);
        int[] nArray2 = new int[512];
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            if ((n6 = this.lt1[n5++]) == 0) {
                n = 1;
                while (n5 < n2 && this.lt1[n5] == 0) {
                    ++n5;
                    ++n;
                }
                if (n <= 2) {
                    nArray2[0] = nArray2[0] + n;
                    continue;
                }
                if (n <= 18) {
                    nArray2[1] = nArray2[1] + 1;
                    continue;
                }
                if (n == 19) {
                    nArray2[0] = nArray2[0] + 1;
                    nArray2[1] = nArray2[1] + 1;
                    continue;
                }
                nArray2[2] = nArray2[2] + 1;
                continue;
            }
            int n7 = n = n6 + 2;
            nArray2[n7] = nArray2[n7] + 1;
        }
        int[] nArray3 = nArray2;
        huffmanTableBuilder.build(nArray3);
        this.ct2 = huffmanTableBuilder.getCodeTable();
        this.lt2 = huffmanTableBuilder.getCodeLengthTable();
        int[] nArray4 = new int[17];
        for (n = 0; n < this.index; ++n) {
            if (this.symbolBuffer[n] < 256) continue;
            int n8 = this.offsetBuffer[n];
            int n9 = 0;
            while (n8 >= 1 << n9) {
                ++n9;
            }
            int n10 = n9;
            nArray4[n10] = nArray4[n10] + 1;
        }
        huffmanTableBuilder.build(nArray4);
        this.ct3 = huffmanTableBuilder.getCodeTable();
        this.lt3 = huffmanTableBuilder.getCodeLengthTable();
    }

    private void outputCodes() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = LzhHuffmanEncoder.getTrimmedSize(this.lt2);
        this.out.writeBits(this.index, 16);
        this.out.writeBits(n4, 5);
        int n5 = 0;
        while (n5 < n4) {
            if ((n3 = this.lt2[n5++]) <= 6) {
                this.out.writeBits(n3, 3);
            } else {
                this.out.writeBits(-1, n3 - 4);
                this.out.writeBits(0, 1);
            }
            if (n5 != 3) continue;
            while (n5 < 6 && this.lt2[n5] == 0) {
                ++n5;
            }
            this.out.writeBits(n5 - 3, 2);
        }
        this.out.writeBits(this.t1size, 9);
        n5 = 0;
        while (n5 < this.t1size) {
            if ((n3 = this.lt1[n5++]) == 0) {
                n2 = 1;
                while (n5 < this.t1size && this.lt1[n5] == 0) {
                    ++n5;
                    ++n2;
                }
                if (n2 <= 2) {
                    for (n = 0; n < n2; ++n) {
                        this.out.writeBits(this.ct2[0], this.lt2[0]);
                    }
                    continue;
                }
                if (n2 <= 18) {
                    this.out.writeBits(this.ct2[1], this.lt2[1]);
                    this.out.writeBits(n2 - 3, 4);
                    continue;
                }
                if (n2 == 19) {
                    this.out.writeBits(this.ct2[0], this.lt2[0]);
                    this.out.writeBits(this.ct2[1], this.lt2[1]);
                    this.out.writeBits(15, 4);
                    continue;
                }
                this.out.writeBits(this.ct2[2], this.lt2[2]);
                this.out.writeBits(n2 - 20, 9);
                continue;
            }
            this.out.writeBits(this.ct2[n3 + 2], this.lt2[n3 + 2]);
        }
        n5 = LzhHuffmanEncoder.getTrimmedSize(this.lt3);
        this.out.writeBits(n5, 4);
        n3 = 0;
        while (n3 < n5) {
            if ((n2 = this.lt3[n3++]) <= 6) {
                this.out.writeBits(n2, 3);
                continue;
            }
            this.out.writeBits(-1, n2 - 4);
            this.out.writeBits(0, 1);
        }
        for (n3 = 0; n3 < this.index; ++n3) {
            n2 = this.symbolBuffer[n3];
            this.out.writeBits(this.ct1[n2], this.lt1[n2]);
            if (n2 < 256) continue;
            n = this.offsetBuffer[n3];
            int n6 = 1;
            while (n >= 1 << n6) {
                ++n6;
            }
            if (n == 0) {
                n6 = 0;
            }
            this.out.writeBits(this.ct3[n6], this.lt3[n6]);
            if (n6 <= 1) continue;
            this.out.writeBits(n, n6 - 1);
        }
        this.out.flush();
    }

    private static int getTrimmedSize(int[] nArray) {
        int n;
        for (n = nArray.length; n > 0 && nArray[n - 1] == 0; --n) {
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
    }

    static {
        $assertionsDisabled = !LzhHuffmanEncoder.class.desiredAssertionStatus();
    }
}

