/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import jp.sourceforge.armadillo.io.ArchiveOutputStream;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipHeader;

public final class ZipOutputStream
extends ArchiveOutputStream {
    private ZipHeader header = new ZipHeader();
    private Deflater deflater = new Deflater(-1, true);
    private CRC32 crc = new CRC32();
    private ZipEntry nextEntry;

    public ZipOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    public ZipOutputStream(OutputStream outputStream, String string) {
        super(outputStream);
        this.frontStream = outputStream;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.ensureOpen();
        if (this.nextEntry != null) {
            this.closeEntry();
        }
        if (zipEntry.lastModified == -1L) {
            zipEntry.setLastModified(System.currentTimeMillis());
        }
        if (zipEntry.method == -1) {
            zipEntry.method = 8;
        }
        switch (zipEntry.method) {
            case 8: {
                zipEntry.version = (short)20;
                if (zipEntry.crc != -1L && zipEntry.compressedSize != -1L && zipEntry.size != -1L) {
                    zipEntry.option = 0;
                } else if (zipEntry.crc == -1L && zipEntry.compressedSize == -1L && zipEntry.size == -1L) {
                    zipEntry.option = (short)8;
                } else {
                    throw new ZipException("invalid ZipEntry (crc, compressed-size or size)");
                }
                this.frontStream = new DeflaterOutputStream(this.out, this.deflater);
                break;
            }
            case 0: {
                long l;
                long l2 = l = zipEntry.size >= 0L ? zipEntry.size : zipEntry.compressedSize;
                if (l < 0L || zipEntry.crc < 0L) {
                    throw new ZipException("invalid ZipEntry (crc, compressed-size or size)");
                }
                zipEntry.version = (short)10;
                zipEntry.compressedSize = l;
                zipEntry.size = l;
                break;
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        this.nextEntry = zipEntry;
        this.header.write(this.out, zipEntry);
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        this.flush();
        if (this.frontStream instanceof DeflaterOutputStream) {
            DeflaterOutputStream deflaterOutputStream = (DeflaterOutputStream)this.frontStream;
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
            this.frontStream = this.out;
        }
        if (this.nextEntry.hasEXT()) {
            this.nextEntry.crc = this.crc.getValue();
            this.nextEntry.compressedSize = this.deflater.getTotalOut();
            this.nextEntry.size = this.deflater.getTotalIn();
            this.header.writeEXT(this.out, this.nextEntry);
        } else if (this.nextEntry.method == 8 ? this.crc.getValue() != this.nextEntry.crc || (long)this.deflater.getTotalOut() != this.nextEntry.compressedSize || (long)this.deflater.getTotalIn() != this.nextEntry.size : this.nextEntry.size > 0L && this.crc.getValue() != this.nextEntry.crc) {
            throw new ZipException("invalid header info");
        }
        this.deflater.reset();
        this.crc.reset();
        this.nextEntry = null;
    }

    public void write(int n) throws IOException {
        super.write(n);
        this.crc.update(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
            this.header.writeEND(this.out);
            this.deflater.end();
        }
        finally {
            try {
                super.close();
            }
            finally {
                this.header = null;
                this.deflater = null;
                this.crc = null;
                this.nextEntry = null;
            }
        }
    }
}

