package jp.sourceforge.armadillo.lzh;

/**
 * LZHk@B
 */
public final class LzhMethod {

    /**
     * <code>LHD</code>
     */
    public static final String LHD = "-lhd-";

    /**
     * <code>LH0</code>
     */
    public static final String LH0 = "-lh0-";

    /**
     * <code>LH4</code>
     */
    public static final String LH4 = "-lh4-";

    /**
     * <code>LH5</code>
     */
    public static final String LH5 = "-lh5-";

    /**
     * <code>LH6</code>
     */
    public static final String LH6 = "-lh6-";

    /**
     * <code>LH7</code>
     */
    public static final String LH7 = "-lh7-";

    private final String methodName;
    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;

    /**
     * LzhMethod̐B
     * @param methodName \bh
     * @throws LzhException \bhT|[gĂȂꍇ
     */
    public LzhMethod(String methodName) throws LzhException {
        this.methodName = methodName;
        if (methodName.matches("-lh[d0]-")) {
            dictionarySize = 0;
            matchSize = 0;
            threshold = 0;
        } else if (methodName.matches("-lh[4567]-")) {
            switch (methodName.charAt(3)) {
                case '4':
                    dictionarySize = 4096;
                    break;
                case '5':
                    dictionarySize = 8192;
                    break;
                case '6':
                    dictionarySize = 32768;
                    break;
                case '7':
                    dictionarySize = 65536;
                    break;
                default:
                    throw new IllegalStateException();
            }
            matchSize = 256;
            threshold = 3;
        } else {
            throw new LzhException("unsupported method: " + methodName);
        }
    }

    /**
     * methodName̎擾B
     * @return methodName
     */
    public String getMethodName() {
        return methodName;
    }

    /**
     * dictionarySize̎擾B
     * @return dictionarySize
     */
    public int getDictionarySize() {
        return dictionarySize;
    }

    /**
     * matchSize̎擾B
     * @return matchSize
     */
    public int getMatchSize() {
        return matchSize;
    }

    /**
     * threshold̎擾B
     * @return threshold
     */
    public int getThreshold() {
        return threshold;
    }

    /**
     * k邩ǂԂB
     * @return kȂ <code>true</code>AłȂ <code>false</code>
     */
    public boolean isCompressing() {
        return dictionarySize == 0;
    }

}
