package jp.sourceforge.armadillo.tar;

import java.io.*;

/**
 * TAR`A[JCũGgB
 */
public final class TarEntry {

    /**
     * <code>EMPTY_STRING</code>
     */
    private static final String EMPTY_STRING = "";

    /**
     * <code>DEFAULT_DIR_MODE</code>
     */
    public static final int DEFAULT_DIR_MODE = 0;

    String name;
    int mode;
    int uid;
    int gid;
    long size;
    long lastModified;
    int chksum;
    char typeFlag;
    String linkName;
    String magic;
    String version;
    String uname;
    String gname;
    String devmajor;
    String devminor;
    String prefix;

    /**
     * TarEntry̐B
     */
    private TarEntry() {
        this.name = EMPTY_STRING;
        this.mode = 0100666;
        this.uid = 0;
        this.gid = 0;
        this.size = 0L;
        this.lastModified = 0L;
        this.chksum = 0;
        this.typeFlag = '0';
        this.linkName = EMPTY_STRING;
        this.magic = EMPTY_STRING;
        this.version = EMPTY_STRING;
        this.uname = EMPTY_STRING;
        this.gname = EMPTY_STRING;
        this.devmajor = EMPTY_STRING;
        this.devminor = EMPTY_STRING;
        this.prefix = EMPTY_STRING;
    }

    /**
     * TarEntry̐B
     * @param name Gg
     */
    public TarEntry(String name) {
        this();
        this.name = name;
        this.magic = "ustar ";
    }

    /**
     * TarEntry̐B
     * @param file t@C
     */
    public TarEntry(File file) {
        this(file.getPath().replace('\\', '/'));
        this.size = file.length();
        this.lastModified = file.lastModified();
        this.typeFlag = file.isDirectory() ? '5' : '0';
    }

    /**
     * fBNgǂԂB
     * @return fBNgȂ <code>true</code>AłȂ <code>false</code>
     */
    public boolean isDirectory() {
        return name.endsWith("/");
    }

    /**
     * name̎擾B
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * name̐ݒB
     * @param name name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * mode̎擾B
     * @return mode
     */
    public int getMode() {
        return mode;
    }

    /**
     * mode̐ݒB
     * @param mode mode
     */
    public void setMode(int mode) {
        this.mode = mode;
    }

    /**
     * uid̎擾B
     * @return uid
     */
    public int getUid() {
        return uid;
    }

    /**
     * uid̐ݒB
     * @param uid uid
     */
    public void setUid(int uid) {
        this.uid = uid;
    }

    /**
     * gid̎擾B
     * @return gid
     */
    public int getGid() {
        return gid;
    }

    /**
     * gid̐ݒB
     * @param gid gid
     */
    public void setGid(int gid) {
        this.gid = gid;
    }

    /**
     * size̎擾B
     * @return size
     */
    public long getSize() {
        return size;
    }

    /**
     * size̐ݒB
     * @param size size
     */
    public void setSize(long size) {
        this.size = size;
    }

    /**
     * lastModified̎擾B
     * @return lastModified TARwb_"mtime"Javã~bɕϊlB
     */
    public long getLastModified() {
        return lastModified;
    }

    /**
     * lastModified̐ݒB
     * @param lastModified lastModified
     */
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    /**
     * chksum̎擾B
     * @return chksum
     */
    public int getChksum() {
        return chksum;
    }

    /**
     * chksum̐ݒB
     * @param chksum chksum
     */
    public void setChksum(int chksum) {
        this.chksum = chksum;
    }

    /**
     * typeFlag̎擾B
     * @return typeFlag
     */
    public char getTypeFlag() {
        return typeFlag;
    }

    /**
     * typeFlag̐ݒB
     * @param typeFlag typeFlag
     */
    public void setTypeFlag(char typeFlag) {
        this.typeFlag = typeFlag;
    }

    /**
     * linkName̎擾B
     * @return linkName
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * linkName̐ݒB
     * @param linkName linkName
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    /**
     * magic̎擾B
     * @return magic
     */
    public String getMagic() {
        return magic;
    }

    /**
     * magic̐ݒB
     * @param magic magic
     */
    public void setMagic(String magic) {
        this.magic = magic;
    }

    /**
     * version̎擾B
     * @return version
     */
    public String getVersion() {
        return version;
    }

    /**
     * version̐ݒB
     * @param version version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * uname̎擾B
     * @return uname
     */
    public String getUname() {
        return uname;
    }

    /**
     * uname̐ݒB
     * @param uname uname
     */
    public void setUname(String uname) {
        this.uname = uname;
    }

    /**
     * gname̎擾B
     * @return gname
     */
    public String getGname() {
        return gname;
    }

    /**
     * gname̐ݒB
     * @param gname gname
     */
    public void setGname(String gname) {
        this.gname = gname;
    }

    /**
     * devmajor̎擾B
     * @return devmajor
     */
    public String getDevmajor() {
        return devmajor;
    }

    /**
     * devmajor̐ݒB
     * @param devmajor devmajor
     */
    public void setDevmajor(String devmajor) {
        this.devmajor = devmajor;
    }

    /**
     * devminor̎擾B
     * @return devminor
     */
    public String getDevminor() {
        return devminor;
    }

    /**
     * devminor̐ݒB
     * @param devminor devminor
     */
    public void setDevminor(String devminor) {
        this.devminor = devminor;
    }

    /**
     * prefix̎擾B
     * @return prefix
     */
    public String getPrefix() {
        return prefix;
    }

    /**
     * prefix̐ݒB
     * @param prefix prefix
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

}
