package jp.sourceforge.armadillo.zip;

import java.io.*;
import java.util.zip.*;

import jp.sourceforge.armadillo.io.*;

/**
 * ZIP`A[JCu̓̓Xg[B
 */
public final class ZipInputStream extends ArchiveInputStream {

    private ZipHeader header;
    private Inflater inflater;
    private ZipEntry nextEntry;

    /**
     * ZipInputStream̐B
     * ftHgZbggpB
     * @param is InputStream
     */
    public ZipInputStream(InputStream is) {
        this(is, null);
    }

    /**
     * ZipInputStream̐B
     * @param is InputStream
     * @param charsetName Zbg
     *                    ftHgZbggpꍇ <code>null</code> w肷
     */
    public ZipInputStream(InputStream is, String charsetName) {
        super(new RewindableInputStream(is, 4096));
        this.header = new ZipHeader(charsetName);
        this.inflater = new Inflater(true);
    }

    /**
     * ̃Gg擾B
     * @return ZipEntry ̃Ggꍇ <code>null</code>
     * @throws IOException o̓G[ꍇ
     */
    public ZipEntry getNextEntry() throws IOException {
        ensureOpen();
        if (nextEntry != null) {
            closeEntry();
        }
        ZipEntry entry = header.read(in);
        if (entry == null) {
            return null;
        }
        switch (entry.getMethod()) {
            case ZipEntry.DEFLATED:
                frontStream = new InflaterInputStream(in, inflater, 512);
                break;
            case ZipEntry.STORED:
                frontStream = in;
                break;
            default:
                throw new IOException("invalid method: " + entry.getMethod());
        }
        remaining = entry.getSize();
        return nextEntry = entry;
    }

    /**
     * ݂̃GgB
     * @throws IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        ensureOpen();

        if (!nextEntry.isDirectory()) {
            // KvΎ̃wb_܂ŃXLbv
            if (remaining > 0 && nextEntry.getCompressedSize() < nextEntry.getSize()) {
                while (remaining > 0) {
                    skip(remaining);
                }
            }
            // inflater̃obt@Ƀf[^cĂꍇ͏߂
            int inflaterRemaining = inflater.getRemaining();
            if (inflaterRemaining > 0) {
                ((RewindableInputStream)in).rewind(inflaterRemaining);
            }
        }

        // KvEXTwb_ǂݍ
        if (nextEntry.hasEXT()) {
            ZipEntry entry = header.readEXT(in);
            if (entry != null) {
                nextEntry.crc = entry.crc;
                nextEntry.compressedSize = entry.compressedSize;
                nextEntry.size = entry.size;
            }
            remaining = 0;
        } else if (!nextEntry.isDirectory()) {
            long rest = nextEntry.getCompressedSize() - inflater.getTotalIn();
            if (rest != 0) {
                // ǂݍ񂾃TCYkTCYƈقȂꍇ̑Ώ
                if (rest > 0) {
                    in.skip(rest);
                } else {
                    throw new IOException("unexpected state");
                }
            }
        }
        assert remaining == 0 : "remaining: " + remaining;

        // Zbg
        nextEntry = null;
        inflater.reset();
        frontStream = in;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#close()
     */
    public void close() throws IOException {
        header = null;
        inflater = null;
        nextEntry = null;
        super.close();
    }

}
