/*
 * Decompiled with CFR 0.152.
 */
package asanhtmlparser;

import asanhtmlparser.HtmlElement;
import asanhtmlparser.HtmlParserException;
import asanhtmlparser.HtmlScanner;
import asanhtmlparser.IHtmlNode;
import asanhtmlparser.util.Logger;
import asanhtmlparser.util.NetUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;

public class HtmlParser {
    private static Logger logger;
    HtmlScanner scanner = new HtmlScanner();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArrayList parse(URL url) throws IOException, HtmlParserException {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        byte[] bytes = NetUtil.downloadContents(url);
        String charset = this.parseCharset(bytes);
        if (charset == null) {
            charset = "JISAutoDetect";
        }
        String source = new String(bytes, charset);
        return this.parse(source, url);
    }

    public ArrayList parse(String source, URL url) throws HtmlParserException {
        IHtmlNode t;
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        this.scanner.setSource(source, url);
        logger.debug(source);
        ArrayList<IHtmlNode> taglist = new ArrayList<IHtmlNode>();
        while ((t = this.scanner.getToken()) != null) {
            logger.debug(t);
            taglist.add(t);
        }
        return taglist;
    }

    public String parseCharset(byte[] bytes) throws UnsupportedEncodingException {
        IHtmlNode t;
        String source = new String(bytes, "utf-8");
        this.scanner.setSource(source, null);
        logger.debug(source);
        while ((t = this.scanner.getToken()) != null) {
            int pos;
            String content;
            logger.debug(t);
            if (!(t instanceof HtmlElement)) continue;
            HtmlElement elem = (HtmlElement)t;
            if (!elem.tagname.equalsIgnoreCase("meta") || (content = elem.getAttributeValue("content")) == null || (pos = content.toLowerCase().indexOf("charset")) == -1 || (pos = content.indexOf(61, pos)) == -1) continue;
            String charset = content.substring(pos + 1).trim();
            logger.debug("charset=[" + charset + "]");
            return charset;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("HtmlParser.main()");
        long start = System.currentTimeMillis();
        if (args.length == 0) {
            System.out.println("usage:java HtmlParser <url>");
            return;
        }
        URL url = new URL(args[0]);
        System.out.println("url=" + url);
        HtmlParser parser = new HtmlParser();
        ArrayList taglist = parser.parse(url);
        for (int i = 0; i < taglist.size(); ++i) {
            IHtmlNode node = (IHtmlNode)taglist.get(i);
            System.out.println(node);
        }
        System.out.println("complete. " + (System.currentTimeMillis() - start) + "msec");
    }

    static {
        $assertionsDisabled = !HtmlParser.class.desiredAssertionStatus();
        logger = Logger.getLogger(HtmlParser.class);
    }
}

