/*
 * Decompiled with CFR 0.152.
 */
package asanhtmlparser.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, String charsetName) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && charsetName == null) {
            throw new AssertionError();
        }
        String source = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while (reader.ready()) {
                String line = reader.readLine();
                source = source + line + "\n";
            }
            String string = source;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String readTextFile(File file) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return FileUtil.readTextFile(file, Charset.defaultCharset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryFile(File file) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file.length() > Integer.MAX_VALUE) {
            throw new AssertionError(file.length());
        }
        byte[] bytes = new byte[(int)file.length()];
        BufferedInputStream in = null;
        int off = 0;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            while (in.available() > 0) {
                int len = in.available();
                off += in.read(bytes, off, len);
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFile(File file, byte[] contents) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && contents == null) {
            throw new AssertionError();
        }
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(contents);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean same(File f1, File f2) throws IOException {
        return FileUtil.readBinaryFile(f1).equals(FileUtil.readBinaryFile(f2));
    }

    public static ArrayList collectFiles(File dir) {
        if (!$assertionsDisabled && dir == null) {
            throw new AssertionError();
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            result.add(files[i]);
            if (!files[i].isDirectory()) continue;
            result.addAll(FileUtil.collectFiles(files[i]));
        }
        return result;
    }

    public static Collection loadLines(File file) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while (reader.ready() && (line = reader.readLine()) != null) {
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result;
    }

    public static void saveLines(File file, Collection collect) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        Iterator ite = collect.iterator();
        while (ite.hasNext()) {
            writer.println(ite.next());
        }
        writer.close();
    }

    static {
        $assertionsDisabled = !FileUtil.class.desiredAssertionStatus();
    }
}

