/*
 * 쐬: 2008/05/22
 */
package asanhtmlparser.util;

/**
 * AsañeLXg֌W֗̕ȃ[eBeB.
 * 
 *
 * @author a-san
 */
public class TextUtil {
	/**
	 * u.
	 * ꕶɕ̕ϊΏۂꍇAׂĂ̕u܂B
	 * @param	str		ΏۂƂȂ镶
	 * @param	src		ϊO(ex."&lt;")
	 * @param	dst		ϊ(ex."&amp;lt;")
	 * @return			uꂽ
	 */
	public static String replace(String str, String src, String dst) {
		assert str != null;
		assert src != null;
		assert dst != null;
		String newStr = "";
		int lastpos = 0;
		for(;;) {
			int pos = str.indexOf(src, lastpos);
			if(pos==-1) break;
			newStr += str.substring(lastpos, pos);
			newStr += dst;
			lastpos = pos + src.length();
		}
		return newStr + str.substring(lastpos);
	}
	/**
	 * XML̕R[hϊs܂B
	 * &amp;,&lt;,>," &amp;amp; &amp;lt; &amp;gt; &amp;quot;ɕϊ܂.
	 * ƂāAnull̏ꍇA"&lt;null/>"Ԃ܂B
	 * @param	str	ϊO̕BnullB
	 * @return	ϊꂽB
	 */
	public static String encodeXml(String str) {
		if (str == null) return "<null/>";
		str = replace(str, "&", "&amp;");
		str = replace(str, "<", "&lt;");
		str = replace(str, ">", "&gt;");
		str = replace(str, "\"", "&quot;");
		return str;
	}	
	/**
	 * XML̕R[hϊɖ߂܂B
	 * &amp;amp; &amp;lt; &amp;gt; &amp;quot;&amp;,&lt;,>," ɕϊ܂.
	 * @param	str	XML̓ꕶɕϊĂ镶Bnulls.
	 * @return	XML̓ꕶɖ߂܂B 
	 */
	public static String decodeXml(String str) {
		assert str != null;
		if (str.compareTo("<null/>") == 0) return null;
		str = replace(str, "&lt;", "<");
		str = replace(str, "&gt;", ">");
		str = replace(str, "&quot;", "\"");
		str = replace(str, "&amp;", "&");
		return str;
	}
	/**
	 * JavãGXP[vV[PXϊ܂B
	 * F"ABCs\n^u\t" => "ABCs\\n^u\\t"
	 * TODO:Java̍\ɍ̂ŁAL`ƓȂB
	 * @param text	ϊÕeLXg
	 * @return	ϊ̃eLXg
	 */
	public static String encodeJavaEscape(String text) {
		String result = TextUtil.replace(text, "\n", "\\n");
		result = TextUtil.replace(result, "\t", "\\t");
		result = TextUtil.replace(result, "\"", "\\\"");
		return result;
	}
	/**
	 * strcountJԂԂB
	 *  times("../", 3) => "../../../"
	 * @param	str		JԂBnulls
	 * @param	count	JԂB0ȏB
	 * @return	strcountJԂꂽԂB
	 */
	public static String times(String str, int count) {
		assert str != null;
		assert count >= 0: count;
		String result = "";
		for (int i=0; i<count; i++) {
			result += str;
		}
		return result;
	}
// 2008/11/20 str.split("\n"); Ŏł邽ߍ폜B
//	/**
//	 * sƂɕ𕪊B
//	 * @param text
//	 * @return
//	 */
//	public static String[] splitLine(String text) {
//		ArrayList list = new ArrayList();
//		int pos = text.indexOf("\n");
//		while (pos != -1) {
//			list.add(text.substring(0, pos+1));
//			text = text.substring(pos+1);
//			pos = text.indexOf("\n");
//		}
//		if (text.length() > 0) list.add(text);
//		String[] result = new String[list.size()];
//		for (int i=0; i<list.size(); i++) {
//			result[i] = (String) list.get(i);
//		}
//		return result;
//	}
}
