/*

*/

#include	"dsgwd_pi.h"
#include	"dprs.h"
#include	"dprs_symbol.h"
#include	"version.h"

#define	MaxDprsReConnectCnt	30


void    DPRS_AutoReLinkSet(void);
void    DPRS_Connect (void);
void    DprsBeacon_Send(void);

enum
	{
		DPRS_HOME = 0,
		DPRS_ACCEPT_DONE,
		DPRS_LOOP
	} DprsState = DPRS_HOME;

unsigned char	DprsSet;
unsigned char	ReDprsConnectCnt;
unsigned char	ReDprsConnectCount;
unsigned char	DprsOpen;
unsigned char	AprsMessageSend;
time_t	Timer;
time_t	DprsBeaconTimer = 0;
time_t	AprsMsgRecvTimer;


unsigned char	InetLat[8], InetLong[9];
unsigned char	InetCall[8];
unsigned char	InetMsg[20];
unsigned char	InetAtitude[6];
unsigned char	InetSpeed[3];
unsigned char	InetDirection[3];
unsigned char	RadioLat[8], RadioLong[9];
unsigned char	RadioCall[8];
unsigned char	RadioMsg[20];
unsigned char	RadioAtitude[6];
unsigned char	RadioSpeed[3];
unsigned char	RadioDirection[3];
unsigned char	Radio_GPS_A_MSG[120];
unsigned char	Inet_GPS_A_MSG[120];
char	Inet_GPS_A_Msg_send;
unsigned char	InetDprsSend;
char	dprs_text[128];

void	dprs(void)
{
	int	len;
	int	i, k;
	int	n;

	switch (DprsState)
	{
		case DPRS_HOME:
        		len = recv(dprsSocket, DprsTemp, 50, 0);
        		if ((len > 2) && !memcmp(DprsTemp, "# ", 2))
        		{
				DPRS_Connect();
                		break;
			}
			break;

                case DPRS_ACCEPT_DONE:
                        len = recv (dprsSocket, DprsTemp, 200, 0);
                        if (len > 80) len = 80;
                        DprsTemp[len] = 0x00;
                        logfile = fopen (LOGFILE, "a");
                        now = time(NULL);
                        fprintf (logfile, "%24.24s %s", ctime(&now), DprsTemp);
                        fclose (logfile);

                        if ((len > 10) && !memcmp(DprsTemp, "# logresp ", 10))
                        {
                                i = 10;
                                while (DprsTemp[i] != ' ') i++;
                                if (!memcmp (&DprsTemp[i+1], "verified",8))
                                {
                                        logfile = fopen (LOGFILE, "a");
                                        now = time(NULL);
                                        fprintf (logfile, "%24.24s Accepted the ID & Validation code from APRS Server.\n",ctime(&now));
                                        fclose (logfile);
                                        DprsOpen = 1;
                                        RadioDprsSend = FALSE;
                                        InetDprsSend = FALSE;
                                        Radio_GPS_A_Msg_send = FALSE;
                                        Inet_GPS_A_Msg_send = FALSE;
                                        memset (RadioDirection, 0x00, 3);
                                        memset (RadioSpeed, 0x00, 3);
                                        memset (RadioAtitude, 0x00, 6);
                                        memset (InetDirection, 0x00, 3);
                                        memset (InetSpeed, 0x00, 3);
                                        memset (InetAtitude, 0x00, 6);
                                        memset (DprsMsgDstCallSignSave, 0x20, 9);
                                        //ReqLoadAprsCallCheck = TRUE;
                                } else {
                                        logfile = fopen (LOGFILE, "a");
                                        now = time(NULL);
                                        fprintf (logfile, "%24.24s Did not accept the ID & Validation code from APRS Server.\n", ctime(&now));
                                        fclose (logfile);
                                        DprsOpen = 0;
                                        close (dprsSocket);
                                }
                                DprsState = DPRS_LOOP;
                                break;
                        }
                        if((time(NULL)-Timer) > 5)      /* wait 5 seconds */
                        {
                        	//DprsState = DPRS_ACCEPT;
                                if (ReDprsConnectCnt++ > 5)
                                {
                                        DprsState = DPRS_HOME;
                                        close (dprsSocket);
                                }
                        }
                        break;

		case DPRS_LOOP:
			GetDprsMessage();
			break;
	}
}

void	DPRS_Connect (void)
{
	int	k;
	int	n;
	int	i;

	DprsState = DPRS_ACCEPT_DONE;
	ReDprsConnectCnt = 0;
	logfile = fopen (LOGFILE, "a");
	now = time(NULL);
	fprintf (logfile, "%24.24s Connected to APRS Server. (Read Only)\n", ctime(&now));
	fclose (logfile);
	ReDprsConnectCnt = 0;

        memcpy (dprs_text, "user ", 5);
        k = 0;
        for (i = 0 ; i < 8 ; i++)
        {
        	if (DPRS.CallSign[i] != 0x20)
                {
                	DprsTemp[k] = DPRS.CallSign[i];
                        k++;
                }
                else
                {
                	if (k > 0)
                        {
                        	if(DprsTemp[k-1] != '-')
                                {
                                	DprsTemp[k] = '-';
                                        k++;
                                }
                        }
		}
	}
        memcpy (&dprs_text[5], DprsTemp, k);
        n = k + 5;
        memcpy (&dprs_text[n], " pass ", 6);
        n += 6;
        for (i = 0 ; i < 8 ; i++)
        {
        	if ((DPRS.ValidCode[i] < 0x30) || (DPRS.ValidCode[i] > 0x39)) break;
        }
        memcpy (&dprs_text[n], DPRS.ValidCode, i);
        n += i;
        memcpy (&dprs_text[n], " vers dsgwd_pi " VERSION "\n\r", 23);
        n += 23;
        send (dprsSocket, dprs_text, n, 0);
        logfile = fopen (LOGFILE, "a");
        now = time(NULL);
        fprintf (logfile, "%24.24s Send ID & Validation Code to APRS Server.\n", ctime(&now));
        fclose (logfile);
        ReDprsConnectCnt = 0;
        AprsMsgRecvTimer = time(NULL);
	DprsOpen = 2;
}

void	DprsBeacon_Send(void)
{
	char	id[9];
	char	msg_len;
	long int i;
	int	k;
	int	n;


	i = labs(DPRS.Lat) % 10000;
	i = i * 6 + 5;
	i /= 10;
	sprintf ((char *)RadioLat, "%02ld%02ld.%02ld" ,labs(DPRS.Lat)/10000, i/100, i%100);
	if (DPRS.Lat >= 0) RadioLat[7] = 'N';
	else RadioLat[7] = 'S';

	i = labs(DPRS.Long) % 10000;
	i = i * 6 + 5;
	i /= 10;
	sprintf ((char *)RadioLong, "%03ld%02ld.%02ld",labs(DPRS.Long)/10000, i/100, i%100);
	if (DPRS.Long >= 0) RadioLong[8] = 'E';
	else RadioLong[8] = 'W';
    
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;

	msg_len = strlen((char *)DPRS.Comment);
	if (msg_len > 20) msg_len = 20;
	memcpy (dprs_text, id, k);
	n = k;
	memcpy (&dprs_text[n], ">APEG3X,TCPIP*,qAC,", 19);
	n += 19;
	memcpy (&dprs_text[n], id, k);
	n += k;
	memcpy (&dprs_text[n], ":=", 2);
	n += 2;
	memcpy (&dprs_text[n], RadioLat, 8);
	n += 8;
	dprs_text[n] = 'D';
	n++;
	memcpy (&dprs_text[n], RadioLong, 9);
	n += 9;
	dprs_text[n] = '&';
	n++;
	if (msg_len > 0)
	{
		memcpy (&dprs_text[n], DPRS.Comment, msg_len);
		n += msg_len;
	}
	memcpy (&dprs_text[n], "\r\n", 2);
	n += 2;
	send (dprsSocket, dprs_text, n, 0);
	DprsBeaconTimer = time(NULL);;
}

void	RadioDprs_Send()
{
	char	id[9];
	char	msg_len;
	int	l, n;
	int	k;
	int	i;
	int	m;

	if ((time(NULL) - AprsRadioTimer) <= 59) return;

	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;
	msg_len = 4;
	while (RadioMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;

	n = 0;
	l = 9999;
	while (memcmp(aprs_symbol[n][1], "    ", 4))
	{
		if (!memcmp(aprs_symbol[n][1], RadioMsg, 4))
		{
			l = n;
			break;
		}
		n++;
	}
	if (l == 9999) l = 29;	// car
	memcpy (dprs_text, RadioCall, strlen(RadioCall));
	m += strlen(RadioCall);
	memcpy (&dprs_text[m], ">APEG3X,DSTAR*,qAR,", 19);
	m += 19;
	memcpy (&dprs_text[m], id, k);
	m += k;
	if (msg_len)
	{
		memcpy (&dprs_text[m], ":=", 2);
	}
	else 
	{
		memcpy (&dprs_text[m], ":!", 2);
	}
	m += 2;
	memcpy (&dprs_text[m], RadioLat, 8);
	m += 8;
	dprs_text[m] = aprs_symbol[l][0][0];
	m++;
	memcpy (&dprs_text[m], RadioLong, 9);
	m += 9;
	dprs_text[m] = aprs_symbol[l][0][1];
	m++;
	if (RadioDirection[0] != 0x00)
	{
		memcpy (&dprs_text[m], RadioDirection, 3);
	}
	else
	{
		memcpy (&dprs_text[m], "000", 3);
	}
	m += 3;
		
	dprs_text[m] = '/';
	m++;
	if (RadioSpeed[0] != 0x00)
		memcpy (&dprs_text[m], RadioSpeed, 3);
	else
		memcpy (&dprs_text[m], "000", 3);
	m += 3;
	memcpy (&dprs_text[m], "/A=", 3);
	m += 3;
	if (RadioAtitude[0] != 0x00)
		memcpy (&dprs_text[m], RadioAtitude, 6);
	else
		memcpy (&dprs_text[m], "000000", 6);
	m += 6;
	msg_len = 4;
	while (RadioMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;
	if (msg_len) 
	{
		memcpy (&dprs_text[m], &RadioMsg[4], msg_len);
		m += msg_len;
	}
	memcpy (&dprs_text[m], "\r\n", 2);
	m += 2;
	send (dprsSocket, dprs_text, m, 0);

	RadioDprsSend = FALSE;		
	memset (RadioDirection, 0x00, 3);
	memset (RadioSpeed, 0x00, 3);
	memset (RadioAtitude, 0x00, 6);
	AprsRadioTimer = time(NULL);
}

void	Radio_GPS_A_Send()
{
	if ((time(NULL) - AprsRadioTimer) > 59)
	{
		send (dprsSocket, Radio_GPS_A_MSG, strlen(Radio_GPS_A_MSG), 0);
		Radio_GPS_A_Msg_send = FALSE;
		AprsRadioTimer = time(NULL);
	}
}

void	AprsMsgSend()
{
	char	seqID[8];
	int	k;
	int	n;
	int	i;

	AprsMessageSend = FALSE;

	for (i = 0 ; i < 9 ; i++)
	{
		if (AprsDest[i] <= 0x20) AprsDest[i] = 0x00;
	}
	if (AprsDest[0] == 0x00) return;

	if (!strlen((char *)AprsMessage))return;

	
	memcpy (dprs_text, AprsSenderCall, strlen(AprsSenderCall));
	n += strlen(AprsSenderCall);
	memcpy (&dprs_text[n], ">APEG3X,TCPIP*::", 16);
	n += 16;
	k = strlen (AprsDest);
	if (k > 9) k = 9;
	memcpy (&dprs_text, AprsDest, k);
	n += k;
	k = 9 - k;
	if (k) memset (&dprs_text[n], 0x20, k);
	n += k;
	dprs_text[n] = ':';
	n++;
	memcpy (&dprs_text[n], AprsMessage, strlen(AprsMessage));
	n += strlen(AprsMessage);
	dprs_text[n] = '{';
	n++;
	sprintf ((char *)seqID, "%-ld", AprsSeq);
	memcpy (&dprs_text[n], seqID, strlen(seqID));
	n += strlen(seqID);
	memcpy (&dprs_text[n], "\r\n", 2);
	n += 2;
	send (dprsSocket, dprs_text, n, 0);
}

