/*

*/

#include	"dsgwd_pi.h"
#include	"dprs.h"


void    DprsAck(char SeqID[]);
void    DprsMsgSend(char Msg[]);

void	GetDprsMessage()
{
	char 	*msg, *msge, *msgstart, *msgend, *dstpnt, *msglast, *dprscall;
	int	len, k1;
	int	i, k;
	char	id[10];
	struct	AprsCallTable	*NextTable;

	len = recv(dprsSocket, DprsTemp, 500, 0);
	if (len == 0) return;
	DprsTemp[len] = 0x00;

	msgstart = (char *)&DprsTemp;	
	msglast = msgstart + len - 1;
	DprsTemp[len++] = 0x00;
	DprsTemp[len] = 0x00;
	
	dstpnt = strstr(msgstart, "::");
skip:
	if (!dstpnt) return;
	if (*(dstpnt-1) == '`')
	{
		dstpnt = strstr(dstpnt+2, "::");
		goto skip;
	}

next:
	if (msgstart >= msglast) return;
	msgend = strstr (msgstart, "\r\n");	
	if (!msgend) return;
	if (msgend < dstpnt)
	{
		msgstart = msgend + 2;
		goto next;
	}
	*msgend = 0x00;

	if (dstpnt+11 > msgend)
	{
		msgstart = msgend + 2;
		goto next;
	}		
	if (*(dstpnt+11) != ':')
	{
		msgstart = msgend + 2;
		goto next;
	}		

	msg = strstr (msgstart, "qAC");
	if (!msg) msg = strstr (msgstart, "qAS");
	if (!msg) msg = strstr (msgstart, "qAR");
	if (!msg) return;
	if (!memcmp(msg+4, "AE5PL-JF", 8)) return;
	if (*(dstpnt+12) == 0x00) return;

	if ((dstpnt+14) <= msgend)
	{
		memset (id, 0x20, 9);
		if (strstr(dstpnt+12, "ack"))
		{
			if (memcmp(dstpnt+2, AprsSenderCall, strlen((char *)AprsSenderCall))) return;
			/* skip ack message */
			RcvAprsSeq = atol (dstpnt+15);
			return; 			
		}
	}		

	msge = strchr (msgstart, '>');
	if (!msge) return;
	k1 = msge - msgstart;	/* skip space */
	if (!k1) return;
	memcpy (DprsMsgDstCallSign, dstpnt+2, 9);
	dprscall = strchr (dstpnt+2, '-');
	if (dprscall)
	{
		k = dprscall - dstpnt - 2;
		if (k < 8)
		{
			DprsMsgDstCallSign[k] = 0x20;
			DprsMsgDstCallSign[7] = DprsMsgDstCallSign[k+1];
			for (i = k ; i < 7 ; i++)
			{
				DprsMsgDstCallSign[i] = 0x20;
			}
		}
	}
	NextTable = AprsCallTablePnt;
	while  (NextTable)
	{
		if (!memcmp (&DprsMsgDstCallSign, NextTable->CallSign, 8)) goto Find;
		NextTable = NextTable->Next;
	}
	return;

Find:

	memset (DprsMsgSrcCallSign, 0x20, 9);
	memcpy (DprsMsgSrcCallSign, msgstart, k1);

	DprsMsgSend(dstpnt+12);

	msg = strchr (dstpnt+12, '{');
	if (!msg) return;

	msg++;
	msge = msg;
	if (msge >= msgend) return;
	while (*msge != 0x00)
	{
		if (msge >= msgend) break;
		msge++;
	}
	if (msg == msge) return;
	*msge = 0x00;
	if ((msge - msg) <= 5)  DprsAck(msg); 
}

void	DprsMsgSend(char Msg[])
{
	char	tmp[138];
	int	len, i, k, j;

	memset (tmp, 0x20, 40);
	memcpy (tmp, DprsMsgSrcCallSign, 9);
	memcpy (&tmp[10], DprsMsgDstCallSign, 9);
	len = strlen ((char *)Msg);
	if (!len) return;
	k = 0;
	for (i = 0 ; i < len ; i++)
	{
		if ((Msg[i] == '{') || (Msg[i] == 0x00)) break;
		k++;			 	
	}
	if (k == 0) return;
	if (k > 67) k = 67;
	j = k;
	if (j > 20) j = 20;
	if (j > 0)
	{
		memcpy (&tmp[20], Msg, j);
		//if (!memcmp (AprsMsgTX, "ON" , 2)) xQueueSend( xDstarDprsMsgQueue, tmp, 0 );
		mq_send (dprs_qid, tmp, 40, 0);
	}
}

void    DprsAck(char SeqID[])
{
	char	dprs_text[128];
        char    PathID[9];
        long int i, kk;
        int     n;


        kk = 0;
        for (i = 0 ; i < 9 ; i++)
        {
                if (DprsMsgDstCallSign[i] != 0x20) kk++;
        }

        memcpy (dprs_text, DprsMsgDstCallSign, kk);
        n = kk;
        memcpy (&dprs_text[n], ">APEG3X,TCPIP*,qAC,", 19);
        n += 19;

        kk = 0;
        for (i = 0 ; i < 8 ; i++)
        {
                if (DPRS.CallSign[i] != 0x20)
                {
                        PathID[kk] = DPRS.CallSign[i];
                        kk++;
                }
                else
                {
                        if (kk > 0)
                        {
                                if(PathID[kk-1] != '-')
                                {
                                        PathID[kk] = '-';
                                        kk++;
                                }
                        }
                }
        }
        PathID[kk] = 0x00;

        memcpy (&dprs_text[n], PathID, kk);
        n += kk;
        memcpy (&dprs_text[n], "::", 2);
        n += 2;
        memcpy (&dprs_text[n], DprsMsgSrcCallSign, 9);
        n += 9;
        memcpy (&dprs_text[n], ":ack", 4);
        n += 4;
        i = strlen ((char *)SeqID);
        memcpy (&dprs_text[n], SeqID, i);
        n += i;
        memcpy (&dprs_text[n], "\r\n", 2);
        n += 2;
        send (dprsSocket, dprs_text, n, 0);
}
