<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Anno.php 68 2006-04-01 14:27:55Z sakamoto $
 */

/**
 * Ame[V̏ێNX
 * ̃NX𒼐ځARXgNg邱Ƃ͂܂B
 * ́AAutoSOAP_Anno::parseReflector(Reflector);łނ͂łB
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Anno {
    private $commnet;
    private $parameters = array();

    /**
     * RgZbg܂B
     * 
     * @param string $comment 
     */
    public function setComment($commnet)
    {
        $this->commnet = $commnet;
    } 

    /**
     * Rg擾܂B
     */
    public function getComment()
    {
        return $this->commnet;
    } 

    /**
     * Ame[VCǉ܂B
     * 
     * @param AutoSOAP_Anno_Line $param
     */
    public function appendLine(AutoSOAP_Anno_Line $param)
    {
        $this->parameters[] = $param;
    } 

    /**
     * R}hs܂B
     * 
     * @param AutoSOAP_Anno_Command $exec R}hIuWFNg
     */
    public function execute(AutoSOAP_Anno_Command $exec)
    {
        foreach($this->parameters as $parameter) {
            $parameter->accept($exec);
        } 
        return $exec->getResult();
    } 

    /**
     * tNVIuWFNggetDocComment()𗘗pāAAme[V擾܂B
     * 
     * @static 
     * @param Reflector $ref tNVIuWFNg
     */
    static public function parseReflector(Reflector $ref)
    {
        $engine = AutoSOAP_Anno_ParseEngine :: getInstance();
        return $engine->parse($ref->getDocComment());
    } 
} 

/**
 * Ame[VsR}hC^[tF[X
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
interface AutoSOAP_Anno_Command {
    /**
     * Ame[VR}hR}hԂ
     * 
     * @access public 
     */
    public function getCode();
    /**
     * Ame[VR}hʂԂ܂
     * 
     * @access public 
     */
    public function getResult();
    /**
     * Ame[VR}h܂
     * 
     * @access public 
     * @param string $value Ame[VR}h̑΂镶
     */
    public function execute($value);
} 

/**
 * Ame[VC
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Anno_Line
{
    private $key;
    private $value;

    /**
     * RXgN^
     * 
     * @access public 
     * @param string $key Ame[VR}h
     * @param string $value Ame[VR}h̑΂镶
     */
    public function __construct($key, $value)
    {
        $this->key = preg_quote($key);
        $this->value = trim($value);
    } 

    /**
     * Ame[VR}h̏sׂ̃R}ĥ󂯌(Visitorp^[)
     * 
     * @access public 
     * @param AutoSOAP_Anno_Command $command sAme[VR}h
     */
    public function accept(AutoSOAP_Anno_Command $command)
    {
        if (preg_match('/^' . $this->key . '$/i', $command->getCode())) {
            $command->execute($this->value);
        } 
    } 
} 

/**
 * Ame[Vꂽp[X܂B
 * Singletonp^[KĂ܂B
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Anno_ParseEngine {
    private static $instance;

    /**
     * RXgN^
     * 
     * @access private 
     */
    private function __construct()
    {
    } 

    /**
     * CX^̎擾
     * 
     * @access public 
     */
    public static function getInstance()
    {
        if (is_null(self :: $instance)) {
            $class = __CLASS__;
            self :: $instance = new $class();
        } 
        return self :: $instance;
    } 

    /**
     * p[X
     * 
     * @access public 
     * @param string $doc Ame[Vꂽ
     */
    public function parse($doc)
    {
        $annotation = new AutoSOAP_Anno();
        $args = array();
        preg_match_all("/^[ \t]*\*[^\/][ \t]*(.{2,})/m", $doc, $args, PREG_SET_ORDER);
        $p_key = '';
        $p_val = '';
        foreach($args as $lines) {
            $matches = array();
            if (preg_match("/^@([^ \t\n\r]+)[ \t]*(.*)/", $lines[1], $matches)) {
                $this->appendData($annotation, $p_key, $p_val);
                $p_key = $matches[1];
                $p_val = $matches[2];
            } else {
                $p_val .= $lines[1];
            } 
        } 
        $this->appendData($annotation, $p_key, $p_val);

        return $annotation;
    } 

    /**
     * Ame[VClass $annotation֒ǉĂ܂B
     * 
     * @access private 
     * @param AutoSOAP_Anno $annotation Ame[VێNX
     * @param string $p_key Ame[VR}h
     * @param string $p_val Ame[VR}h̑΂镶
     */
    private function appendData(&$annotation, $p_key, $p_val)
    {
        if ('' != $p_val) {
            if ('' != $p_key) {
                $annotation->appendLine(new AutoSOAP_Anno_Line($p_key, $p_val));
            } else {
                $annotation->setComment($p_val);
            } 
        } 
    } 
} 

?>