<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2SoapXsdVisitor.class.php 74 2006-04-05 14:29:06Z sakamoto $
 */

/**
 * NXSOAPbZ[WؗpXSDf[^ւ̕ϊprW^[NX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2SoapXsdVisitor extends AutoSOAP_class2soapVisitor implements AutoSOAP_ReflectionVisitor {
    /**
     * 
     */
    public function init($target_uri, $soapenv_uri = null, $soapenc_uri = null)
    { 
        
        $root = $this->_schema->createRoot($target_uri);
        $class2xsd = new AutoSOAP_class2xsdVisitor();
        $class2xsd->init($root);
        parent :: init($target_uri, $root, $class2xsd); 
        // SOAPGu[uXL[}C|[g
        $xml = AutoSOAP_XMLogic_XMLFactory :: getInstance();
        if (is_null($soapenv_uri))
            $soapenv_uri = AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV;
        if (is_null($soapenc_uri))
            $soapenc_uri = AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC;
        $this->_root->add($this->_schema->createImport(AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV, $soapenv_uri));
        $this->_root->add($xml->xmlns('soapenv', AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV));

        $this->_root->add($this->_schema->createImport(AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC, $soapenc_uri));
        $this->_root->add($xml->xmlns('soapenc', AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC));
    } 

    /**
     * \bhǉ
     */
    public function appendMethod(AutoSOAP_ReflectionAccept $method, $annotation)
    {
        $method_name = $method->getName();

        /**
         * NGXg\bhǉ
         */
        $request_name = $method_name . "Request";
        $request = $this->_schema->createComplexType($request_name);

        /**
         * p[^ǉ
         */
        $parameters = $method->getParameters()->accept($this);
        if (0 < count($parameters)) {
            $seq = $this->_schema->createSequence();
            foreach($parameters as $param) {
                $seq->add($param);
            } 
            $request->add($seq);
        } 
        $request->add($this->_schema->createAnyAttribute("##other", "lax"));
        $this->_root->add($request);

        /**
         * ʖǉĂ
         */
        $alias = $this->_schema->createComplexType($method_name);
        $alias_tmp = $this->_schema->createComplexContent();
        $alias_tmp->add($this->_schema->createExtensionBase($request_name, $this->_Target_uri));
        $alias->add($alias_tmp);
        $this->_root->add($alias);

        /**
         * X|X\bhǉ
         */
        $response_name = $method_name . "Response";
        $datatype = null;
        $restriction = (isset($annotation['restrictions']['#return'])) ? $annotation['restrictions']['#return'] : null ;
        $restriction_name = (isset($annotation['restriction_names']['#return'])) ? $annotation['restriction_names']['#return'] : null ;

        if (is_array($annotation['return'])) {
            $return_types = $annotation['return'][0]; 
            // ^w肪Pp^[ȊOׂ͂NULLɂ
            if (1 == count($return_types)) {
                $datatype = $return_types[0];
            } 
        } 
        $response = $this->_class2xsd->getDataTypeElement($response_name, $datatype, $restriction, $restriction_name);
        $this->_root->add($response);
    } 

    /**
     * ǉ
     */
    public function appendParameter(AutoSOAP_ReflectionAccept $param, $datatype, $restriction, $restriction_name, $options)
    {
        return $this->_class2xsd->getDataTypeElement($param->getName(), $datatype, $restriction, $restriction_name, $options);
    } 
}
?>