<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2soapVisitor.class.php 73 2006-04-05 13:26:00Z sakamoto $
 */

/**
 * NXSOAPpXML𐶐ׂ̃rW^[eNX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
abstract class AutoSOAP_class2soapVisitor implements AutoSOAP_ReflectionVisitor {
    // XMLf[^ێIuWFNg
    protected $_root; 
    // ^[Qbgl[Xy[X
    protected $_Target_uri; 
    // ClassXSDNX
    protected $_class2xsd; 
    // XMLXL[}^ONX
    protected $_schema; 
    // \bh̃Ame[Vꎞۑp
    private $_method_annotation;

    public function __construct()
    {
        $this->_schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();
    } 

    /**
     * 
     */
    public function init($target_uri, $root, $class2xsd)
    {
        $this->_Target_uri = $target_uri;
        $this->_root = $root;
        $this->_class2xsd = $class2xsd;
    } 

    /**
     * NX}bvԂ
     */
    public function getClassmap()
    {
        return $this->_class2xsd->getClassmap();
    } 

    /**
     * z}bvԂ
     */
    public function getArraymap()
    {
        return $this->_class2xsd->getArraymap();
    } 

    /**
     * ʂԂ
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        $text = new AutoSOAP_XMLogic_exportTextVisitor();
        if ($this->_root->accept($text)) {
            return $text->getResult($to_encoding, $from_encoding);
        } 
        return null;
    } 

    /**
     * NX
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class)
    { 
        // \bhǉ
        $class->getMethods()->accept($this);
    } 

    /**
     * \bh
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method)
    {
        $method_name = $method->getName(); 
        // ANZX public oȂꍇ́AǉȂ
        if (!$method->isPublic()) {
            return null;
        } 

        /**
         * /\bh̓Ɂu_vꍇ́AǉȂ
         * if(preg_match("/^_/i",$method_name)) {
         * return null;
         * }//
         */

        /**
         * Ame[V̎擾
         */
        $annotation = AutoSOAP_Anno :: parseReflector($method);
        $this->_method_annotation = array(); 
        // ANZX擾
        $anno_access = $annotation->execute(new AutoSOAP_Anno_AccessCmd());
        if ('public' !== $anno_access && !is_null($anno_access)) {
            return ;
        } 
        // ^擾
        $this->_method_annotation['types'] = $annotation->execute(new AutoSOAP_Anno_ParamCmd()); 
        // p[^̐擾
        $this->_method_annotation['restrictions'] = $annotation->execute(new AutoSOAP_Anno_RestrictionCmd()); 
        // p[^̐擾
        $this->_method_annotation['restriction_names'] = $annotation->execute(new AutoSOAP_Anno_RestrictionNameCmd()); 
        // Ԓl擾
        $this->_method_annotation['return'] = $annotation->execute(new AutoSOAP_Anno_ReturnCmd());

        return $this->appendMethod($method, $this->_method_annotation);
    } 

    /**
     * 
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param)
    {
        $options = array();
        $ref_class = $param->getClass();
        $options['default'] = $param->isDefaultValueAvailable();

        $datatype = null;
        if (is_null($ref_class)) {
            if (isset($this->_method_annotation['types']['$' . $param->getName()])) {
                $datatype = $this->_method_annotation['types']['$' . $param->getName()][0];
            } 
        } else {
            $datatype = $ref_class;
        } 

        $restriction = (isset($this->_method_annotation['restrictions']['$' . $param->getName()]))
                     ? $this->_method_annotation['restrictions']['$' . $param->getName()]
                     : null;
        $restriction_name = (isset($this->_method_annotation['restriction_names']['$' . $param->getName()]))
                     ? $this->_method_annotation['restriction_names']['$' . $param->getName()]
                     : null;

        return $this->appendParameter($param, $datatype, $restriction, $restriction_name, $options);
    } 

    /**
     * q
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children)
    {
        $itr = $children->getIterator();
        if (!$itr->valid()) {
            return ;
        } 
        $type = $itr->current()->getReflectionType();
        switch ($type) {
        case 'ReflectionMethod':
            while ($itr->valid()) {
                $itr->current()->accept($this);
                $itr->next();
            } 
            return ;

        case 'ReflectionParameter':
            $result = array();
            while ($itr->valid()) {
                $tmp = $itr->current()->accept($this);
                if (!is_null($tmp))
                    $result[] = $tmp;
                $itr->next();
            } 
            return $result;
        } 
        return null;
    } 

    /**
     * vpeB
     */
    final public function visitProperty(AutoSOAP_ReflectionAccept $property)
    {
    } 
    /**
     * ֐
     */
    final public function visitFunction(AutoSOAP_ReflectionAccept $func)
    {
    } 
    /**
     * IuWFNg
     */
    final public function visitObject(AutoSOAP_ReflectionAccept $object)
    {
    } 
    /**
     * GNXeV
     */
    final public function visitExtension(AutoSOAP_ReflectionAccept $extension)
    {
    } 

    /**
     * \bhǉ
     */
    abstract public function appendMethod(AutoSOAP_ReflectionAccept $method, $annotation);

    /**
     * ǉ
     */
    abstract public function appendParameter(AutoSOAP_ReflectionAccept $param, $datatype, $restriction, $restriction_name, $options);
} 

?>