<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2xsdVisitor.class.php 74 2006-04-05 14:29:06Z sakamoto $
 */

/**
 * NXXSDf[^ւ̕ϊprW^[NX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2xsdVisitor implements AutoSOAP_ReflectionVisitor {
    private $_root;

    private $_xml;
    private $_schema;
    private $_array_fctry;

    private $_ArrayMap;
    private $_classMap;
    private $_RestrictionMap;
    private $_restrictionCount;

    static private $_xsd_var_types = array(
            'anyType',
            'string',
            'boolean',
            'float',
            'double',
            'decimal',
            'integer',
            'nonPositiveInteger',
            'negativeInteger',
            'long',
            'int',
            'short',
            'byte',
            'nonNegativeInteger',
            'unsignedLong',
            'unsignedInt',
            'unsignedShort',
            'unsignedByte',
            'positiveInteger',
            'date',
            'time',
            'anyURI',
            'base64Binary',
            'hexBinary',
            'dateTime',
            'duration',
            'ENTITIES',
            'ENTITY',
            'gDay',
            'gMonth',
            'gMonthDay',
            'gYear',
            'gYearMonth',
            'ID',
            'IDREF',
            'IDREFS',
            'language',
            'Name',
            'NCName',
            'NMTOKEN',
            'NMTOKENS',
            'normalizedString',
            'NOTATION',
            'QName',
            'token',
    );
    /**
     * 
     */
    public function init($root, $array_fctry = null)
    {
        $this->_root = $root;
        $this->_Target_uri = AutoSOAP_XMLogic_XMLFactory :: searchAttrigute($this->_root, 'targetNamespace')->getName();
        $this->_schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();
        $this->_array_fctry = (is_null($array_fctry)) ? $this->_schema : $array_fctry ;

        /**
         * ̑̏
         */
        $this->_classMap = array();
        $this->_ArrayMap = array();
        $this->_restrictionCount = 0;
    } 

    /**
     * vpeB
     */
    public function visitProperty(AutoSOAP_ReflectionAccept $property)
    { 
        // ANZX䂪PublicŐÓIȂ̂łȂΏB
        if (!$property->isPublic() || $property->isStatic()) {
            return ;
        } 

        /**
         * Ame[V
         */
        $annotation = AutoSOAP_Anno :: parseReflector($property); 
        // vpeBÓI`FbN
        if ($annotation->execute(new AutoSOAP_Anno_StaticCmd())) {
            return ;
        } 
        // ANZX擾
        $anno_access = $annotation->execute(new AutoSOAP_Anno_AccessCmd());
        if ('public' !== $anno_access && !is_null($anno_access)) {
            return ;
        } 
        // ^擾
        $anno_var = $annotation->execute(new AutoSOAP_Anno_VarCmd());
        $datatype = (is_array($anno_var)) ? $anno_var[0] : null; 
        // 擾
        $restriction = $annotation->execute(new AutoSOAP_Anno_RestrictionCmd());
        // 擾
        $restriction_name = $annotation->execute(new AutoSOAP_Anno_RestrictionNameCmd()); 

        $options = array();

        return $this->getDataTypeElement($property->getName(), $datatype, $restriction[''], $restriction_name[''], $options);
    } 

    /**
     * NX
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class)
    {
        $elem_name = "Class-" . $class->getName(); 
        // ܂ANX}bvɒǉĂȂNXȂǉ
        if (!isset($this->_classMap[$elem_name])) {
            // NX}bvɒǉ
            $this->_classMap[$elem_name] = $class->getName();

            $property = $class->getProperties()->accept($this);
            $result = $this->_schema->createComplexType($elem_name); 
            // vpeBǉ
            if (!is_null($property)) {
                $result->add($property);
            } 

            $this->_root->add($result);
        } 

        return $elem_name;
    } 

    /**
     * q
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children)
    {
        $itr = $children->getIterator();
        if (!$itr->valid()) {
            return ;
        } 
        $seq = $this->_schema->createSequence();
        while ($itr->valid()) {
            $tmp = $itr->current()->accept($this);
            if (!is_null($tmp))
                $seq->add($tmp);
            $itr->next();
        } 
        return $seq;
    } 

    /**
     * ^ẅׂ̃GgԂB
     */
    public function getDataTypeElement($name, $datatype, $restriction, $restriction_name, $options = null)
    {
        $info = $this->getElementInfo($name, $datatype, $restriction, $restriction_name);
        return $this->_schema->createElement($info['name'], $info['datatype'], $info['namespace'], $options);
    } 

    /**
     * ^𐶐ׂ̏擾
     */
    public function getElementInfo($name, $datatype, $restriction, $restriction_name)
    {
        $namespace = $this->_Target_uri;
        $flg_array = false;
        $array_options = array('array_min'=>-1, 'array_max'=>-1);
        $ref_class = null;
        
        if(is_null($datatype)) {
            $datatype = 'anyType';
        }

        if (is_string($datatype)) {
            // zւ̑Ή
            $matches = array();
            if (preg_match("/([^\[\]]+)\[(?:(-*[0-9]+)(?:-([0-9]+))?)?\]/i", $datatype, $matches)) {
                $datatype = $matches[1];
                if (isset($matches[3])) {
                    $array_options['array_min'] = (int)$matches[2] ;
                    $array_options['array_max'] = (int)$matches[3] ;
                } else if (isset($matches[2])) {
                    $array_options['array_min'] = -1 ;
                    $array_options['array_max'] = (int)$matches[2] ;
                } 
                $flg_array = true;
            } 
            if (preg_match("/mixed/i", $datatype)) {
                $datatype = "anyType";
            } 
            // ̌^`FbNAȂ΁ANXƂĈB
            $flg_simple_type = false;
            foreach (self :: $_xsd_var_types as $tmp_type) {
            	if (0 == strcasecmp($datatype, $tmp_type)) {
            		$datatype = $tmp_type;
            		$flg_simple_type = true;
            		break;
            	}
            }
            if (false===$flg_simple_type) {
            	$ref_class = new AutoSOAP_ReflectionAcceptImpl(new ReflectionClass($datatype));
            }
        } else {
            $ref_class = $datatype;
        } 
        if (!is_null($ref_class)) {
            $datatype = $ref_class->accept($this);
        } else if (0 == count($restriction)) {
            $namespace = null;
        } 
        // anyType̓NXwł͂Ȃꍇ̂ݓK
        else if ('anyType' !== $datatype) {
            $datatype = $this->createRestrictionElement($datatype, $restriction, $restriction_name);
        } 
        // z
        if (true === $flg_array) {
            $datatype = $this->getArrayElementName($datatype, $namespace, $array_options);
            $namespace = $this->_Target_uri;
        } 

        return array('name' => $name, 'datatype' => $datatype, 'namespace' => $namespace);
    } 

    /**
     * z^𐶐ÃGgԂB
     */
    private function getArrayElementName($datatype, $namespace, $options)
    {
        $min_count = (0 < $options['array_min']) ? (int)$options['array_min'] : 0;
        $max_count = (0 < $options['array_max']) ? (int)$options['array_max'] : 0;

        $name = 'ArrayOf' . $datatype . '_' . $min_count . '-' . $max_count;

        if (!isset($this->_ArrayMap[$name])) {
            $this->_root->add($this->_array_fctry->createArray($name, $datatype, $namespace, $min_count, $max_count));
            $this->_ArrayMap[$name] = true;
        } 
        return $name;
    } 

    /**
     * ꂽ^𐶐ÃGgԂB
     */
    private function createRestrictionElement($datatype, $restriction, $restriction_name)
    {
        $restriction_name = (is_null($restriction_name))
                          ? 'Restriction-' . ($this->_restrictionCount++)
                          : 'R-' . $restriction_name ;
        if (isset($this->_RestrictionMap[$restriction_name])) {
        	trigger_error("Restriction Name '".$restriction_name."' is already registed", E_USER_ERROR);
        	return null;
        }
        $this->_RestrictionMap[$restriction_name] = true;
        
        $simple = $this->_schema->createSimpleType($restriction_name);
        $base = $this->_schema->createRestrictionBase($datatype);
        $simple->add($base);
        foreach($restriction as $num => $rest) {
            list($rest_type, $rest_val) = each($rest);
            $base->add($this->_schema->createRestriction($rest_type, $rest_val));
        } 

        $this->_root->add($simple);

        return $restriction_name;
    } 

    /**
     * ʂԂ
     */
    public function getResult()
    {
    } 
    /**
     * NX}bvԂ
     */
    public function getClassmap()
    {
        return $this->_classMap;
    } 
    /**
     * z}bvԂ
     */
    public function getArraymap()
    {
        return $this->_ArrayMap;
    } 
    /**
     * 
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param)
    {
    } 
    /**
     * \bh
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method)
    {
    } 
    /**
     * IuWFNg
     */
    public function visitObject(AutoSOAP_ReflectionAccept $object)
    {
    } 
    /**
     * GNXeV
     */
    public function visitExtension(AutoSOAP_ReflectionAccept $extension)
    {
    } 
    /**
     * ֐
     */
    public function visitFunction(AutoSOAP_ReflectionAccept $func)
    {
    } 
} 

?>