<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: DocCommand.class.php 97 2006-04-23 10:05:16Z sakamoto $
 */

/**
 * 著者名を返す
 * 返値のフォーマットは
 * array(
 *   0 =>array(著者名1,'メールアドレス1'),
 *   1 =>array(著者名2,'メールアドレス2'),
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode author
 * @format 著者名<メールアドレス>
 */
class AutoSOAP_Anno_AuthorCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'author';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/([^\<\>\r\n]+)\s*(?:<([^\<\>\r\n]+@[^\<\>\r\n]+)>)?/i", $value, $matchs)) {
            $this->result[] = array($matchs[1], $matchs[2]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * パッケージ名を返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode package
 * @format パッケージ名
 */
class AutoSOAP_Anno_PackageCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'package';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * サブパッケージ名を返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode subpackage
 * @format サブパッケージ名
 */
class AutoSOAP_Anno_SubpackageCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'subpackage';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * カテゴリーパスを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode category
 * @format カテゴリーパス
 */
class AutoSOAP_Anno_CategoryCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'category';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * コピーライトを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode copyright
 * @format コピーライト
 */
class AutoSOAP_Anno_CopyrightCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'copyright';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ライセンスを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode license
 * @format ライセンス
 */
class AutoSOAP_Anno_LicenseCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'license';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * Todoを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode todo
 * @format Todoコメント
 */
class AutoSOAP_Anno_TodoCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'todo';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * リンクを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode link
 * @format リンク
 */
class AutoSOAP_Anno_LinkCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'link';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * チュートリアルを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode tutorial
 * @format リンク
 */
class AutoSOAP_Anno_TutorialCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'tutorial';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * バージョンを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode version　
 * @format バージョン
 */
class AutoSOAP_Anno_VersionCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'version';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * どのバージョンから存在しているのかを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode since
 * @format バージョン
 */
class AutoSOAP_Anno_SinceCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'since';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 参照先を返す
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode see　
 * @format 関連関数
 */
class AutoSOAP_Anno_SeeCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'see';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result[] = $value;
    } 
} 

/**
 * 廃止が明記されている場合はtrueを返し、もしくは置き換わったAPIを返す。
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode deprecated　
 * @format コメント
 */
class AutoSOAP_Anno_DeprecatedCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'deprecated';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = ('' == $value) ? true : $value;
    } 
} 

/**
 * オーバライトが禁止の有無を返す
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode final　
 * @format 
 */
class AutoSOAP_Anno_FinalCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'final';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * 静的なものか返す
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode static　
 * @format 
 */
class AutoSOAP_Anno_StaticCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'static';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * 無視するか返す
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode ignore　
 * @format 
 */
class AutoSOAP_Anno_IgnoreCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'ignore';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * Abstractクラスか返す
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode abstract
 * @format 
 */
class AutoSOAP_Anno_AbstractCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'abstract';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * パラメータを連想配列で返す
 * 返値のフォーマットは
 * array(
 *   パラメータ名1=>array('型','コメント'),
 *   パラメータ名2=>array('型','コメント'),
 *   パラメータ名3=>array('型','コメント'),
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode param
 * @format 型 パラメータ名 コメント
 */
class AutoSOAP_Anno_ParamCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'param';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = array($matchs[1], $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * サンプルファイル場所を返す
 * array(
 *   0 => array('ファイルパス','コメント'),
 *   1 => array('ファイルパス','コメント'),
 *     .
 *     .
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode example
 * @format ファイルパス コメント
 */
class AutoSOAP_Anno_ExampleCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'example';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[] = array($matchs[1], $matchs[2]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * グローバル変数の情報を返す
 * array(
 *   '変数名' => array('型','コメント'),
 *   '変数名' => array('型','コメント'),
 *     .
 *     .
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode global
 * @format 型 変数名 コメント
 */
class AutoSOAP_Anno_GlobalCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'global';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = array($matchs[1], $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 静的変数の情報を返す
 * array(
 *   '変数名' => array('型','コメント'),
 *   '変数名' => array('型','コメント'),
 *     .
 *     .
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode staticvar
 * @format 型 変数名 コメント
 */
class AutoSOAP_Anno_StaticvarCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'staticvar';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = array($matchs[1], $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 利用する外部のクラスやクラスの変数を返す
 * array(
 *   'クラス名' => 'コメント',
 *   '変数名' => 'コメント',
 *     .
 *     .
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode uses
 * @format 変数名 コメント
 */
class AutoSOAP_Anno_UsesCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'uses';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[1]] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 変数の型を返す
 * array(
 *   0 => '型',
 *   1 => 'コメント',
 *   )
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode var
 * @format 型 コメント
 */
class AutoSOAP_Anno_VarCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'var';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[0] = $matchs[1];
            $this->result[1] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 制限名を返す
 * array(
 *    対象の変数(なければ'') => 制限名,
 *       ・
 *       ・
 *       ・
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode restriction_name
 * @format 制限名
 */
class AutoSOAP_Anno_RestrictionNameCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return array('rname','restriction_name');
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(?:(\S*)@)?(\S+)/i", $value, $matchs)) {
            $this->result[$matchs[1]] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 新しい型と派生元を返す
 * array(
 *    制限名 => 型,
 *       ・
 *       ・
 *       ・
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode restriction_type
 * @format 型 制限名
 */
class AutoSOAP_Anno_RestrictionTypeCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return array('rtype','restriction_type');
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = $matchs[1];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 制限を返す
 * array(
 *    対象の変数(なければ'') => array(
 *      0 => array(
 *        制限方法 => 制限値
 *      ),
 *      1 => array(
 *        制限方法 => 制限値
 *      ),
 *       ・
 *       ・
 *       ・
 *   )
 *   複数: 可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode restriction
 * @format [ターゲット@]制限方法 制限値
 */
class AutoSOAP_Anno_RestrictionCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return array('r','restriction');
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(?:(\S*)@)?(\S+)\s+(.+)/i", $value, $matchs)) {
            $this->result[$matchs[1]][] = array($matchs[2] => $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 返値を返す。
 * 返値のフォーマットは
 * array(
 *   0 => array('型','型','型',...),
 *   1 => 'コメント'
 *   )
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode return　
 * @format 返値の型(or 値)|返値の型(or 値)... コメント
 */
class AutoSOAP_Anno_ReturnCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'return';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[0] = explode('|', $matchs[1]);
            $this->result[1] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * アクセス修飾子を返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode access
 * @format アクセス修飾子(private|protected|public)
 */
class AutoSOAP_Anno_AccessCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'access';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(private|protected|public)/i", $value, $matchs)) {
            $this->result = strtolower($matchs[1]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * 検証時のエラーメッセージを返す
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode validate_error
 * @format エラーメッセージ
 */
class AutoSOAP_Anno_ValidateErrorCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'validate_error';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 


/**
 * エンコードの指定
 *   複数: 不可
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode encoding
 * @format エンコード名
 */
class AutoSOAP_Anno_EncodingCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'encoding';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 
?>