<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Define.class.php 96 2006-04-21 14:51:52Z sakamoto $
 */

/**
 * ネームスペース対応定数クラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class  AutoSOAP_Define {
    static private $instance;
    private $properties = array();

    private function __construct()
    {
    }
    
    public function _($namespace='')
    {
        $key = '.'.strtoupper($namespace);
        if (!isset(self::$instance[$key])) {
            $class = __CLASS__;
            self::$instance[$key] = new $class();
        }
        return self::$instance[$key];
    }
    
    public function __set($name,$value)
    {
        $name = strtoupper($name);
        if(isset($this->properties[$name])) {
            return;    
        }
        $class = __CLASS__;
        if($value instanceof $class)
            return ;
        $this->properties[$name] = serialize($value);
    }

    public function __get($name)
    {
        $key = strtoupper($name);
        if (!isset($this->properties[$key])) {
            return $name;
        }

        return unserialize($this->properties[$key]);
    }

    public function define($name, $value)
    {
        return $this->__set($name, $value);
    }
    
    public function constant($name)
    {
        return $this->__get($name);
    }
    
    public function defined($name)
    {
        $name = strtoupper($name);
        return isset($this->properties[$name]);
    }
    
    public function get_defined_constants()
    {
        $result = array();
        foreach ($this->properties as $key=>$val) {
            $result[$key] = unserialize($val);
        }
        return $result;
    }
}
?>
