<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Filter.class.php 93 2006-04-16 15:23:57Z sakamoto $
 */

/**
 * SoapServerフィルターインターフェース
 * 
 * @package jp.servlet.AutoSOAP.server.filter
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
interface AutoSOAP_Filter {
    /**
     * フィルターの実行
     * 
     * @access public 
     * @param AutoSOAP_Service $service 実行中のサービス
     * @param string $method_name 実行されるメソッド
     * @return void
     */
    public function execute(AutoSOAP_Service $service, $method_name);
} 
?>