<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Global.class.php 96 2006-04-21 14:51:52Z sakamoto $
 */

/**
 * グローバル変数を編み込みクラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Global {
    private function __construct() {}
    
    /**
     * クラスへグローバル変数を編み込む
     * 
     * @access public
     * @param string $class_name
     * @return void 
     */
    static public function knitForClass($class_name) {
        // スタティックプロパティ取得
        $ref = new ReflectionClass($class_name);
        $static_properties = $ref -> getStaticProperties();
        
        foreach ($static_properties as $key => $val) {
            $matches = array();
            // セッション変数を編み込む
            if (preg_match("/^(?:__global_sess|__sess(?:_(\S+))?)$/i", $key, $matches)) {
                switch ($matches[0]) {
                case '__global_sess' :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Session::getSession(null);');
                    break;
                case '__sess' :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Session::getSession("' . $class_name . '");');
                    break;
                default :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Session::getSession("' . $matches[1] . '");');
                    break;
                }
            // 定数を編み込む
            } else if (preg_match("/^__const(?:_(\S+))?$/i", $key, $matches)) {
                switch ($matches[0]) {
                case '__const' :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Define::_("' . $class_name . '");');
                    break;
                default :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Define::_("' . $matches[1] . '");');
                    break;
                } 
            }
        }
    }    
}
?>
