<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Logger.class.php 96 2006-04-21 14:51:52Z sakamoto $
 */

/**
 * SoapServerロギングインターフェース
 * 
 * @package jp.servlet.AutoSOAP.server.logger
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
interface AutoSOAP_Logger {
    /**
     * ログの出力
     * 
     * @access public 
     * @param AutoSOAP_Service $service 実行中のサービス
     * @param integer $errno エラー番号
     * @param string $errstr エラーメッセージ
     * @param string $errfile エラーを出したファイルパス
     * @param string $errline エラーを出した行数
     */
    public function output($service, $errno, $errstr, $errfile, $errline);
} 

?>