<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Session.class.php 96 2006-04-21 14:51:52Z sakamoto $
 */

/**
 * セッション管理クラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Session {
    /**
     * @var string
     */
    private $namespace;

    /**
     * インスタンスオブジェクト
     * 
     * @var AutoSOAP_Session
     */
    private static $instance = null;

    /**
     * コンストラクタ
     * 
     * @access private
     * @param string $namespace
     * @return void 
     */
    private function __construct($namespace=null)
    {
        $this->namespace = (is_null($namespace)) ? null : '__'.$namespace.'__' ;
    }

    /**
     * インスタンの取得
     * 
     * @static 
     * @access public 
     * @param mixed $namespace セッション上書き防止用のネームスペース
     * @return AutoSOAP_Session
     */
    static public function getSession($namespace)
    {
        $key = (is_object($namespace)) ? get_class($namespace) : $namespace ;
        
        if (is_null(self :: $instance)) {
            session_start();
            self :: $instance = array();
        }

        if (!isset(self :: $instance[$key])) {
            $class = __CLASS__;
            self :: $instance[$key] = new $class($key);
        } 
        return self :: $instance[$key];
    }
    
    /**
     * プロパティ設定
     *
     * @access public 
     * @param string $name プロパティ名
     * @param string $val 値
     * @return void
     */
    public function __set($name, $val) {
        if(is_null($this->namespace)) {
            $_SESSION[$name] = $val;
        } else {
            if(!isset($_SESSION[$this->namespace])) {
                $_SESSION[$this->namespace] = array();
            }
            $_SESSION[$this->namespace][$name] = $val;
        }
    }

    /**
     * プロパティ設定
     *
     * @access public 
     * @param string $name プロパティ名
     * @return mixed
     */
    public function __get($name) {
        if(is_null($this->namespace)) {
            return (isset($_SESSION[$name])) ? $_SESSION[$name] : null;
        } else {
            if(!isset($_SESSION[$this->namespace])) {
                $_SESSION[$this->namespace] = array();
            }
            return (isset($_SESSION[$this->namespace][$name])) ? $_SESSION[$this->namespace][$name] : null;
        }
    }

    /**
     * エクスポート
     *
     * @access public 
     * @return mixed
     */
    public function export()
    {
        if(is_null($this->namespace)) {
            return (isset($_SESSION)) ? $_SESSION : null;
        } else {
            return (isset($_SESSION[$this->namespace])) ? $_SESSION[$this->namespace] : null;
        }
    }

    /**
     * クリア
     *
     * @access public 
     * @return void
     */
    public function clear()
    {
        if(is_null($this->namespace)) {
             $_SESSION = null;
        } else {
            $_SESSION[$this->namespace] = null;
        }
    }
}
?>