<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2soap.php 97 2006-04-23 10:05:16Z sakamoto $
 */
include_once(dirname(dirname(__FILE__)) . "/XMLogic/Visitor.class.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/XMLogic.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/SchemaFactory.class.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/WsdlFactory.class.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/exportTextVisitor.class.php");

include_once(dirname(__FILE__) . "/ReflectionAccept.php");

include_once(dirname(dirname(__FILE__)) . "/Anno/Anno.php");
include_once(dirname(dirname(__FILE__)) . "/Anno/DocCommand.class.php");

include_once(dirname(__FILE__) . "/class2xsdVisitor.class.php");
include_once(dirname(__FILE__) . "/class2SoapXsdVisitor.class.php");
include_once(dirname(__FILE__) . "/class2wsdlVisitor.class.php");
include_once(dirname(__FILE__) . "/ElementType.class.php");

/**
 * クラス→WSDLデータへの変換用クラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2wsdl {
    private $visitor;

    function __construct($class_name, $target_uri, $location)
    {
        $this -> visitor = new AutoSOAP_class2wsdlVisitor();
        $this -> visitor -> init($target_uri, $class_name, $location);
        $target = new AutoSOAP_ReflectionAcceptImpl(new ReflectionClass($class_name));

        $target -> accept($this -> visitor);
    } 
    function getResult($to_encoding = null, $from_encoding = null)
    {
        return $this -> visitor -> getResult($to_encoding, $from_encoding);
    } 

    /**
     * クラスマップを返す
     */
    public function getClassmap()
    {
        return $this -> visitor -> getClass2soap() -> getClassmap();
    } 

    /**
     * 検証用エラーメッセージマップを返す
     */
    public function getValidateErrorMap()
    {
        return $this -> visitor -> getValidateErrorMap();
    } 

    /**
     * オプションデータをエクスポートする
     */
    public function exportOptions()
    {
        $content = "<?php\n";
        $content .= "\$_classmap="        . var_export($this -> getClassmap(), true)         . ";\n";
        $content .= "\$_validate_errors=" . var_export($this -> getValidateErrorMap(), true) . ";\n";
        $content .= "?>";

        $encoding = $this -> visitor -> getEncoding();

        if(is_null($encoding)) {
            return mb_convert_encoding($content, 'UTF-8');
        } else {
            return mb_convert_encoding($content, 'UTF-8', $encoding);
        }
    }
} 

/**
 * クラス→SOAPメッセージ検証用XSDデータへの変換クラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2SoapXsd {
    private $visitor;

    function __construct($class_name, $target_uri, $soapenv_uri = null, $soapenc_uri = null)
    {
        $this -> visitor = new AutoSOAP_class2SoapXsdVisitor();
        $this -> visitor -> init($target_uri, $soapenv_uri, $soapenc_uri);
        $target = new AutoSOAP_ReflectionAcceptImpl(new ReflectionClass($class_name));

        $target -> accept($this -> visitor);
    } 
    function getResult($to_encoding = null, $from_encoding = null)
    {
        return $this -> visitor -> getResult($to_encoding, $from_encoding);
    } 
} 

/**
 * SOAPデータ生成管理クラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2soap {
    // ターゲットネームスペース
    private $_Target_uri; 
    // Class→XSD化クラス
    private $_class2xsd; 
    // XMLルート
    private $_root; 
    // メソッドのアノテーション
    private $_method_annotation; 
    
    private $_elemTypes;

    public function __construct($target_uri, AutoSOAP_XMLogic_Obj $root, AutoSOAP_class2xsdVisitor $class2xsd)
    {
        $this -> _Target_uri = $target_uri;
        $this -> _root = $root;
        $this -> _class2xsd = $class2xsd;
    } 

    /**
     * XMLオブジェクトを追加する
     */
    public function appendXML(AutoSOAP_XMLogic_Obj $elem, $num = -1)
    {
        return $this -> _root -> add($elem, $num);
    } 

    /**
     * クラスマップを返す
     */
    public function getClassmap()
    {
        return $this -> _class2xsd -> getClassmap();
    } 

    /**
     * を返す
     */
    public function getTargetURI()
    {
        return $this -> _Target_uri;
    } 

    /**
     * メソッドに記述されてある型情報の取得
     */
    public function createMethodInfo(AutoSOAP_ReflectionAccept $method)
    {
        $this -> _method_annotation = null;
        $this -> _elemTypes = null;

        $method_name = $method -> getName(); 
        // アクセス権が public 出ない場合もしくは静的関数の場合は、追加しない
        if (!$method -> isPublic() || $method -> isStatic()) {
            return null;
        } 

        /**
         * メソッド名の頭に「__」があった場合は、追加しない
         */
        if (preg_match("/^__/i", $method_name)) {
            return null;
        } 

        /**
         * アノテーションの取得
         */
        $this -> _method_annotation = AutoSOAP_Anno :: parseReflector($method); 
        // アクセス制御を取得
        $anno_access = $this -> _method_annotation -> execute(new AutoSOAP_Anno_AccessCmd());
        if ('public' !== $anno_access && !is_null($anno_access)) {
            return null;
        } 
        // 静的かを取得
        $anno_static = $this -> _method_annotation -> execute(new AutoSOAP_Anno_StaticCmd());
        if (true === $anno_static) {
            return null;
        } 

        if (is_null($this -> _method_annotation)) {
            return false;
        } 

        $this -> _elemTypes = AutoSOAP_ElementType :: createByMethod($this -> _method_annotation);

        return true;
    } 

    /**
     * 検証時のエラーメッセージを返す
     */
    public function getValidateError()
    { 
        // 検証時のエラーメッセージを取得
        return $this -> _method_annotation -> execute(new AutoSOAP_Anno_ValidateErrorCmd());
    } 

    /**
     * 返値の情報を返す
     */
    public function getReturnInfo()
    {
        $elemType = (isset($this -> _elemTypes['#return']))
        ? $this -> _elemTypes['#return']
        : new AutoSOAP_ElementType();
        return $elemType;
    } 

    /**
     * 引数を処理する
     */
    public function getParameterInfo($param_name)
    {
        $elemType = (isset($this -> _elemTypes['$' . $param_name]))
        ? $this -> _elemTypes['$' . $param_name]
        : new AutoSOAP_ElementType();
        return $elemType;
    } 

    /**
     * 結果を返す
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        $text = new AutoSOAP_XMLogic_exportTextVisitor();
        if ($this -> _root -> accept($text)) {
            return $text -> getResult($to_encoding, $from_encoding);
        } 
        return null;
    } 

    /**
     * 新しい型の生成
     */
    public function createNewTypes(AutoSOAP_ReflectionAccept $class)
    {
        /**
         * インターフェースから新しい型をインクルードする
         */
        $interfaces = $class -> getInterfaces();
        $interfaces -> accept($this -> _class2xsd);
    } 

    /**
     * 型指定の為のエレメントを返す。
     */
    public function getDataTypeElement($name, AutoSOAP_ElementType $elemType, $options = null)
    {
        return $this -> _class2xsd -> getDataTypeElement($name, $elemType, $options);
    } 

    /**
     * 型を生成する為の情報を取得する
     */
    public function getElementInfo($name, AutoSOAP_ElementType $elemType, $options)
    {
        return $this -> _class2xsd -> getElementInfo($name, $elemType, $options);
    } 

    /**
     * 引数のオプションを返す
     */
    static public function getParamOptions(AutoSOAP_ReflectionAccept $param)
    {
        $options = array();
        $options['default'] = $param -> isDefaultValueAvailable();
        $ref_class = $param -> getClass();
        if (is_null($ref_class)) {
            $options['ref_class'] = $ref_class;
        } 

        return $options;
    } 

    /**
     * 子を処理する
     */
    static public function visitChildren(AutoSOAP_ReflectionVisitor $visitor, AutoSOAP_ReflectionChildren $children)
    {
        $itr = $children -> getIterator();
        if (!$itr -> valid()) {
            return ;
        } 
        $type = $itr -> current() -> getReflectionType();
        switch ($type) {
        case 'ReflectionMethod':
            while ($itr -> valid()) {
                $itr -> current() -> accept($visitor);
                $itr -> next();
            } 
            return ;

        case 'ReflectionParameter':
            $result = array();
            while ($itr -> valid()) {
                $tmp = $itr -> current() -> accept($visitor);
                if (!is_null($tmp))
                    $result[] = $tmp;
                $itr -> next();
            } 
            return $result;
        } 

        return null;
    } 
} 

?>