<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: FileLogger.class.php 99 2006-04-23 14:13:00Z sakamoto $
 */

/**
 * AutoSOAP_Server用簡易ロギング
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_FileLogger implements AutoSOAP_Logger {
    private $dir;

    /**
     * コンストラクタ
     * 
     * @access public 
     * @param string $dir ログの保存先
     */
    public function __construct($dir)
    {
        $this->dir = $dir . '/';
    } 

    /**
     * ログの出力
     * 
     * @access public 
     * @param AutoSOAP_Service $service 実行中のサービス
     * @param integer $errno エラー番号
     * @param string $errstr エラーメッセージ
     * @param string $errfile エラーを出したファイルパス
     * @param string $errline エラーを出した行数
     */
    public function output($service, $errno, $errstr, $errfile, $errline)
    {
        $errortype = array (
                E_ERROR           => "Error",
                E_WARNING         => "Warning",
                E_PARSE           => "Parsing Error",
                E_NOTICE          => "Notice",
                E_CORE_ERROR      => "Core Error",
                E_CORE_WARNING    => "Core Warning",
                E_COMPILE_ERROR   => "Compile Error",
                E_COMPILE_WARNING => "Compile Warning",
                E_USER_ERROR      => "User Error",
                E_USER_WARNING    => "User Warning",
                E_USER_NOTICE     => "User Notice",
                E_STRICT          => "Runtime Notice"
                );
				$err_mark = $errortype[$errno];
				
        date_default_timezone_set('GMT');
        $file_path = $this->dir . date("Ymd", time()) . '.txt';
        if (!$handle = fopen($file_path, 'a+')) {
            return false;
        } 
        $mssg = date("H:i:s", time()) . ' ' . $err_mark . ': ' . $errstr . "\r\n";
        if (false === fwrite($handle, $mssg)) {
            fclose($handle);
            return false;
        } 

        fclose($handle);
        
        return (boolean)((E_STRICT | E_NOTICE | E_USER_NOTICE) & $errno);
    } 
} 

?>