<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id$
 */

/**
 * フレームワークテストクライアント
 * 
 * @package jp.servlet.AutoSOAP.Framework
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Framework_TestClient {
	private $client;
	private $funcs;
	private $types;
      
	/**
	 * コンストラクタ
	 */
    public function __construct() {
    } 
      
    /**
     * 初期化
     */
    public function init($wsdl_uri, &$result) {
        try {
            $this->client = @new SoapClient($wsdl_uri, array('trace' => 1));
            if(isset($_SESSION['soap_session'])) {
                foreach($_SESSION['soap_session'] as $cookiekey => $cookieval) {
                    $this->client->__setCookie($cookiekey, $cookieval);
                }
            }
        
            $types = $this->parseTypes( $this->client->__getTypes() );
            $funcs_data = $this->client->__getFunctions();
            
            $this->funcs = array();
            foreach($funcs_data as $func_str) {
                $tmp = new AutoSOAP_Framework_TestFunction($func_str, $types);
                $this->funcs[$tmp->func] = $tmp;
            }
            
        } catch (Exception $e) {
        $result = "<font color=red>Error!!</font><br>".$e->faultstring;
            return false;
        }
        return true;
    }
    
	/**
	 * 実行
	 */
	public function execute($function, &$post, &$files, &$result) {
		if(!isset($this->funcs[$function])) {
			$result = "<font color=red>Error!!</font><br>"."Not found Function";
			return false;
		}
		try {
			$result = $this->funcs[$function]->execute($this->client, $post, $files);
		} catch (Exception $e) {
			$result = "<font color=red>Error!!</font><br>".$e->faultstring;
			return false;
		}
		return true;
	}
      
	/**
	 * テンプレート出力
	 */
	public function output() {
		if (!is_array($this->funcs)) {
			return ;
		}
		foreach($this->funcs as $func) {
			$func->output();
		}
	}
      
    /**
     * 型データへパースする
     */
	private function parseTypes($types_str) {
	    $types = array();
	    foreach($types_str as $num=>$str) {
		    $tmp_types2 = explode(' ',$str);
		    $types[$tmp_types2[1]] = $tmp_types2[0];
	    }
	    return $types;
    }
}
?>