<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id$
 */

/**
 * フレームワークテストコンテンツ
 * 
 * @package jp.servlet.AutoSOAP.Framework
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Framework_TestContents {
	/**
	 * ヘッダー
	 */
	static public function Header($title)
	{
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<style type="text/css">
body {background-color: #ffffff; color: #000000;}
body, td, th, h1, h2 {font-family: sans-serif;}
pre {margin: 0px; font-family: monospace;}
a:link {color: #000099; text-decoration: none; background-color: #ffffff;}
a:hover {text-decoration: underline;}
table {border-collapse: collapse;}
.center {text-align: center;}
.center table { margin-left: auto; margin-right: auto; text-align: left;}
.center th { text-align: center !important; }
td, th { border: 1px solid #000000; font-size: 14px; vertical-align: baseline;}
h1 {font-size: 150%;}
h2 {font-size: 125%;}
.p {text-align: left;}
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.h {background-color: #9999cc; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
.vr {background-color: #cccccc; text-align: right; color: #000000;}
.b td {border:0px; text-align: center;}
.l1 {border:1px; padding:0px;}
.l2 {border-width: 0px 0px 1px 0px;}
.l3 {border:0px;}

img {float: right; border: 0px;}
hr {width: 600px; background-color: #cccccc; border: 0px; height: 1px; color: #000000;}
</style>
<script type="text/javascript">
var panels = new Array();

function appendPanel(id, func) {
	panels[panels.length] = id;
  var tmp = document.getElementById('select_func');
  tmp.innerHTML = tmp.innerHTML + "<span><a href=\"\" onclick=\"return changePanel('"+id+"')\">"+func+'</a></span><br>';
}

function changePanel(id) {
	var len = panels.length;
	for(var i=0;i<len; i++ ) {
    var tmp = document.getElementById(panels[i]);
    tmp.style.display= (id==panels[i]) ? '' : 'none';
  }
  return false;
}
</script>

<title><?=$title?></title></head>
<body><div class="center">
<?
	}
	/**
	 * テスト用入力フォーム
	 */
	static public function testForm($testfunc, $_)
	{
?>
<script type="text/javascript">
appendPanel("soap_func_<?=$_['func']?>", "<?=$_['func']?>");
</script>
<div id="soap_func_<?=$_['func']?>" style="display:<?=($_['func']===$_POST['function'])?'':'none'?>;">
<form enctype="multipart/form-data" action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST">
<input type="hidden" name="test_wsdl_uri" value="<?=$_REQUEST['test_wsdl_uri']?>">
<input type="hidden" name="function" value="<?=$_['func']?>">
<table border="0" cellpadding="3" width="450">
<tr class="b"><td colspan=3 style="text-align:left;font-size:18px;">Function : <?=$_['func']?></td></tr>
<tr class="h"><th>Param</th><th>Input</th><th>Type</th></tr>
<?
foreach($_['param'] as $key=>$type) {
	$newtype = $testfunc->getBaseType($type);
	$loop = 1;
	$input_type = "text";
?>
<tr>
<td class="e"><?=$key?></td>
<td class="v">
<?
if( $testfunc->isArrayType($type) ) {
    $key .= '[]';
    $loop = 5;
}
if( preg_match("/Binary$/i", $newtype) ) {
	$input_type = "file";
}
for( $i=0 ; $i<$loop; $i++) {
    echo '<input type="'.$input_type.'" name="'.$key.'" value="" style="width:230px"><br>';
}
?>
</td>
<td class="e"><?=$type?></td>
</tr>
<? } ?>
<tr>
<td class="h" colspan=2>Return</td><td class="e"><?=$_['return']?></td>
</tr>
<tr class="b"><td colspan=3><input type="submit" value="Execute" style="width:150px"></td></tr>
</form>
</table>
</div>
<?			
	}

	/**
	 * SOAPサービステスト
	 */
	static public function testBody($_)
	{
?>
<form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST">
<table border="0" cellpadding="3" width="600">
<tr class="h"><td colspan="2">
<h1 class="p">SOAP Test</h1>
</td></tr>
<tr class="v">
<td colspan="2">WSLD_URI : <input type="text" name="test_wsdl_uri" value="<?=$_REQUEST['test_wsdl_uri']?>" size=78></td>
</tr>
</form>
<tr class="e">
<td class="l1">
<table border=0 cellpadding="3" style="width:130px;">
<tr class="h"><th class="l2">Function List</th></tr>
<tr class="e">
<td class="l3" id="select_func"></td>
</tr>
</table>
</td>
<td class="v" style="width:470px;vertical-align:top;">
<?
if (is_object($_['tester'])) {
    $_['tester']->output();
}
?>
</td>
</table><br />

<?if(!is_null($_['result_mssg'])) {?>
<table border="0" cellpadding="3" width="600">
<? if(0<strlen($_POST['function'])) { ?>
<tr class="h"><td class="p" style="font-size:18px">' <?=$_POST['function']?> ' Result :</td></tr>
<? } ?>
<tr class="v"><td>
<pre style="font-size:12px">
<?=$_['result_mssg']?>
</pre>
</td></tr>
</table><br />
<? } ?>
<?
	}

	/**
	 * インフォメーション
	 */
	static public function infoBody($_, $wsdl_uri, $result_mssg, $base_uri)
	{
?>
<form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST">
<table border="0" cellpadding="3" width="600">
<tr class="h"><td>
<h1 class="p"><a href="http://servlet.sakura.ne.jp/autosoapwiki/" target="_blank">AutoSOAP Version <?=$_['AutoSOAP_Version']?></a></h1>
</td></tr>
<tr class="v">
<td>WSLD_URI : <input type="text" name="info_wsdl_uri" value="<?=$wsdl_uri?>" size=78></td>
</tr>
</table><br />
</form>

<?if(!is_null($result_mssg)) {?>
<table border="0" cellpadding="3" width="600">
<tr class="v"><td>
<?=$result_mssg?>
</td></tr>
</table><br />
<? }
if (is_null($_)) {
    return ;
}
 ?>
<table border="0" cellpadding="3">
<tr class="b">
<td border="0"><form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST"><input type="hidden" name="mode" value="cleanAllWSDL"><input type="submit" value="WSDLファイルをクリア"></form></td>
<td border="0"><form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST"><input type="hidden" name="mode" value="cleanAllXSD"><input type="submit" value="バリテーションファイルをクリア"></form></td>
<td colspan=2 align=center valign=center><form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST"><input type="hidden" name="mode" value="cleanALL"><input type="submit" value="両方ともクリア"></form></td>
</tr>
</table>

<table border="0" cellpadding="3" width="600">
<tr><td class="e">タイムスタンプ</td><td class="v"><?=( (isset($_['timestamp']))?$_['timestamp']:"サービス毎に依存" )?></td></tr>
<tr><td class="e">ロギングシステム</td><td class="v"><?=( (isset($_['logger']))?$_['logger']:"無" )?></td></tr>
<tr><td class="e">メッセージのバリテーション</td><td class="v"><?=( ($_['suport_validate'])?"有":"無" )?></td></tr>
<tr><td class="e">ベースディレクトリー</td><td class="v"><?=$_['base_dir']?></td></tr>
<tr><td class="e">データ保存先ディレクトリー</td><td class="v"><?=$_['var_dir']?></td></tr>
<tr><td class="e">サービスディレクトリー</td><td class="v"><?=$_['services_dir']?></td></tr>
<tr><td class="e">WSDLディレクトリー</td><td class="v"><?=$_['wsdls_dir']?></td></tr>
<tr><td class="e">バリテーション用ディレクトリー</td><td class="v"><?=$_['xsds_dir']?></td></tr>
<tr><td class="e">オプションディレクトリー</td><td class="v"><?=$_['options_dir']?></td></tr>
</table><br />
<h2><a name="module_apache2handler">エイリアス</a></h2>
<table border="0" cellpadding="3" width="600">
<tr class="h"><th>優先度</th><th>エイリアス</th><th>変換パターン</th></tr>
<?$count=0?>
<?foreach($_['alias'] as $alias => $replace) {?>
<tr><td class="e"><?=++$count?></td><td class="e"><?=$alias?></td><td class="v"><?=$replace?></td></tr>
<? } ?>
</table>

<h2><a name="module_apache2handler">フィルター</a></h2>
<table border="0" cellpadding="3" width="600">
<tr class="h"><th>実行順</th><th>フィルター名</th></tr>
<?foreach($_['filters'] as $num => $filter) {?>
<tr><td class="e"><?=$num+1?></td><td class="v"><?=$filter?></td></tr>
<? } ?>
</table><br />

<h2><a name="module_apache2handler">オリジナルサービス</a></h2>
<table border="0" cellpadding="3" width="600">
<tr class="h"><th>サービスパス</th><th>更新日</th><th>WSDL</th></tr>
<?foreach($_['services']['original'] as $path => $date) {?>
<tr><td class="e"><a href="<?=$_SERVER["SCRIPT_NAME"]?>?test_wsdl_uri=<?=urlencode($base_uri.$path.'@wsdl')?>" target="_blank"><?=$path?></a></td><td class="v"><?=$date?></td><td class="v" align="center"><a href="<?=$base_uri.$path.'@wsdl'?>" target="_blank">WSDL</a></td></tr>
<? } ?>
</table><br />

<h2><a name="module_apache2handler">AutoSOAPサービス</a></h2>
<table border="0" cellpadding="3" width="600">
<tr class="h"><th>サービスパス</th><th>更新日</th><th>WSDL</th></tr>
<?foreach($_['services']['autosoap'] as $path => $date) {?>
<tr><td class="e"><a href="<?=$_SERVER["SCRIPT_NAME"]?>?test_wsdl_uri=<?=urlencode($base_uri.$path.'@wsdl')?>" target="_blank"><?=$path?></a></td><td class="v"><?=$date?></td><td class="v" align="center"><a href="<?=$base_uri.$path.'@wsdl'?>" target="_blank">WSDL</a></td></tr>
<? } ?>
</table><br />

<form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST">
<input type="hidden" name="mode" value="cleanWSDLFiles">
<h2><a name="module_apache2handler">WSDLキャッシュ</a></h2>
<table border="0" cellpadding="3" width="600">
<tr class="h"><th>ファイル名</th><th>更新日</th><th><input type="submit" value="クリア"></th></tr>
<?foreach($_['cash']['wsdls'] as $path => $date) {?>
<tr><td class="e"><?=$path?></td><td class="v"><?=$date?></td><td class="v" align="center"><input type="checkbox" name="files[]" value="<?=$path?>"></td></tr>
<? } ?>
</table><br />
</form>

<form action="<?=$_SERVER["SCRIPT_NAME"]?>" method="POST">
<input type="hidden" name="mode" value="cleanXSDFiles">
<h2><a name="module_apache2handler">バリテーションキャッシュ</a></h2>
<table border="0" cellpadding="3" width="600">
<tr class="h"><th>ファイル名</th><th>更新日</th><th><input type="submit" value="クリア"></th></tr>
<?foreach($_['cash']['xsds'] as $path => $date) {?>
<tr><td class="e"><?=$path?></td><td class="v"><?=$date?></td><td class="v" align="center"><input type="checkbox" name="files[]" value="<?=$path?>"></td></tr>
<? } ?>
</table><br />
</form>

<?
	}

}
?>
