<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id$
 */
include_once(dirname(__FILE__)."/TestContents.class.php");
include_once(dirname(__FILE__)."/TestClient.class.php");
include_once(dirname(__FILE__)."/TestFunction.class.php");

/**
 * フレームワークテストツール
 * 
 * @package jp.servlet.AutoSOAP.Framework
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Framework_TestTool {
    function __construct() {}
        
    /**
     * 
     */
    static public function outputHTML()
    {
        session_start();
        header("Content-type: text/html; charset=UTF-8");

        if( 0<strlen($_REQUEST['test_wsdl_uri'])) {
            self::outputHTML_Test();
        } else  {
            self::outputHTML_Info();
        }
        echo "</div></body></html>";
    }

    /**
     * 
     */
    static private function outputHTML_Test()
    {
	    $result_mssg = null;
	    if( 0<strlen($_REQUEST['test_wsdl_uri'])) {
	        $tester = new AutoSOAP_Framework_TestClient();
	        $tester->init($_REQUEST['test_wsdl_uri'], $result_mssg);
	     
	        if(0<strlen($_POST['function']) && is_null($result_mssg)) {
	        $tester->execute($_POST['function'], $_POST, $_FILES, $result_mssg);
	        }
	    }
	    $_ = array();
	    $_['tester'] = $tester;
	    $_['result_mssg'] = $result_mssg;
	    
	    //出力
	    AutoSOAP_Framework_TestContents::Header("SOAP Test [".$_REQUEST['test_wsdl_uri']."]");
	    AutoSOAP_Framework_TestContents::testBody($_);
    }
    
    /**
     * 
     */
    static private function outputHTML_Info()
    {
	    if( 0<strlen($_POST['info_wsdl_uri'])) {
	        $_SESSION['info_wsdl_uri'] = $_POST['info_wsdl_uri'];
	    }
	    $wsdl_uri = $_SESSION['info_wsdl_uri'];
	    $uri_info = parse_url($wsdl_uri);
	    $base_uri = $uri_info['scheme'].'://'.$uri_info['host'].$uri_info['path'].'?';
	    
	    $result_mssg = null;
	    $info = self::getFrameworkInfo($wsdl_uri,$result_mssg);
	    $_ = array();
	    $_['wsdl_uri'] = $wsdl_uri;
	    $_['result_mssg'] = $result_mssg;
	    
	    //出力
	    AutoSOAP_Framework_TestContents::Header("AutoSOAP Framework Info");
	    AutoSOAP_Framework_TestContents::infoBody($info, $wsdl_uri, $result_mssg, $base_uri);
    }

    /**
     * 
     */
    static private function template($tpl,$_) {
	    include($tpl);
    }
    
    /**
     * 
     */
    static private function getFrameworkInfo($wsdl_uri,&$result_mssg)
    {
	    if( 1>strlen($wsdl_uri)) {
	        return null;
	    }
	    try {
		    $client = @new SoapClient($wsdl_uri, array('trace' => 1));
		    switch ($_POST['mode']) {
		    case 'cleanALL' :
		        if ($client->cleanALL()) {
		        $result_mssg = "WSDLとバリテーションファイルをクリアしました。";
		        }
		        break;
	        case 'cleanAllWSDL' :
                if ($client->cleanAllWSDL()) {
                $result_mssg = "WSDLファイルをクリアしました。";
                }
                break;
            case 'cleanAllXSD' :
                if ($client->cleanAllXSD()) {
                $result_mssg = "バリテーションファイルをクリアしました。";
                }
                break;
            case 'cleanWSDLFiles' :
                if ($client->cleanWSDLs($_POST['files'])) {
                $result_mssg = "WSDLファイルをクリアしました。";
                }
                break;
            case 'cleanXSDFiles' :
                if ($client->cleanXSDs($_POST['files'])) {
                $result_mssg = "バリテーションファイルをクリアしました。";
                }
                break;
            }
        } catch (Exception $e) {
            $result_mssg = "<font color=red>Error!!</font><br>".$e->faultstring;
            return null;
        }
        try {
            return @$client->info();
        } catch (Exception $e) {
            $result_mssg = "<font color=red>Error!!</font><br>".$e->faultstring;
        }
        return null;
    }
}
?>