<?
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Framework.service.php 104 2006-04-25 15:06:20Z sakamoto $
 */

include_once("AutoSOAP/Types/Io.type.php");

/**
 * フレームワーク管理
 * 
 * @package jp.servlet.AutoSOAP.Services.Core
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @encoding UTF-8
 */
class AutoSOAP_Services_Core_Framework implements AutoSOAP_Types_Io {
    public function __construct()
    {
    }

    /**
     * フレームワークの情報を返す
     */
    public function info()
    {
        $result = array();

        $framework = AutoSOAP_Framework::getInstance(null);
        $info = $framework->getInfo();
    	
        $fcty_org = $info['_factories'][AutoSOAP_Framework::FACTORY_ORGINAL]->getInfo();
        $serverinfo  = $info['_server']->getInfo();

        $result['AutoSOAP_Version'] = AutoSOAP::VERSION;
        //エイリアス
        $result['alias'] = $info['_alias'];
        //フィルター
        $result['filters'] = array();
        foreach($serverinfo['filters'] as $filter) {
            $result['filters'][] = get_class($filter);
        }
        //バリテーション有無
        $result['suport_validate'] = $info['_validate_mode'];
        //タイムスタンプ
        $result['timestamp'] = $info['_timestamp'];
        //ロギング
        $result['logger'] = get_class($serverinfo['logger']);

        $result['base_dir'] = $info['_base_dir'];
        $result['var_dir'] = $framework->getVarDir();

        //サービス
        $result['services'] = array();
        $result['services'][AutoSOAP_Framework::FACTORY_AUTOSOAP] = $this->getServicePaths(dirname(dirname(__FILE__)).'/',"AutoSOAP.Services.");
        $result['services'][AutoSOAP_Framework::FACTORY_ORGINAL]  = $this->getServicePaths($fcty_org['services_dir'],"");

        //キャッシュ
        $result['cash'] = array();
        $result['cash']['wsdls'] = $this->getFiles($fcty_org['wsdls_dir'], "/\.wsdl$/i");
        $result['cash']['xsds']  = $this->getFiles($fcty_org['xsds_dir'], "/\.xsd$/i");

        return array_merge($result, $fcty_org);
    }

    /**
     * すべてファイル(WSDL,XSD)を削除する
     */
    public function cleanAll()
    {
    	$this->cleanAllWSDL();
    	$this->cleanAllXSD();
    	
    	return true;
    }
    
    /**
     * WSDLファイルをすべて削除する
     */
    public function cleanAllWSDL()
    {
    	$framework = AutoSOAP_Framework::getInstance(null);   	
    	$info = $framework->getInfo();
    	$fcty_org = $info['_factories'][AutoSOAP_Framework::FACTORY_ORGINAL]->getInfo();
    	
    	return $this->cleanFile($fcty_org['wsdls_dir'], "/\.wsdl$/i");
   }

    /**
     * XSDファイルをすべて削除する
     */
    public function cleanAllXSD()
    {
    	$framework = AutoSOAP_Framework::getInstance(null);   	
    	$info = $framework->getInfo();
    	$fcty_org = $info['_factories'][AutoSOAP_Framework::FACTORY_ORGINAL]->getInfo();
    	
    	return $this->cleanFile($fcty_org['xsds_dir'], "/\.xsd$/i");
    }

    /**
     * WSDLファイルを削除する
     * @param #FileName[] $files
     */
    public function cleanWSDLs($files)
    {
    	$framework = AutoSOAP_Framework::getInstance(null);   	
    	$info = $framework->getInfo();
    	$fcty_org = $info['_factories'][AutoSOAP_Framework::FACTORY_ORGINAL]->getInfo();
    	
    	foreach ($files as $num=>$file) {
    	    if (is_file($fcty_org['wsdls_dir'].$file)) {
    	        unlink($fcty_org['wsdls_dir'].$file);
    	    }
    	}
    	return true;
   }

    /**
     * XSDファイルを削除する
     * @param #FileName[] $files
     */
    public function cleanXSDs($files)
    {
    	$framework = AutoSOAP_Framework::getInstance(null);   	
    	$info = $framework->getInfo();
    	$fcty_org = $info['_factories'][AutoSOAP_Framework::FACTORY_ORGINAL]->getInfo();
    	
    	foreach ($files as $num=>$file) {
    	    if (is_file($fcty_org['xsds_dir'].$file)) {
    	        unlink($fcty_org['xsds_dir'].$file);
    	    }
    	}
    	return true;
   }

    /**
     * ファイルを削除する
     */
    private function cleanFile($dir, $file_pattern)
    {
        $d = dir($dir);
        while (false !== ($entry = $d->read())) {
            if (is_file($dir.$entry)) {
                if(preg_match($file_pattern, $entry)) {
                    unlink($dir.$entry);
                }
            }
        }
        $d->close();
        
        return true;
    }

    /**
     * ファイル一覧を取得
     */
    private function getFiles($dir, $file_pattern)
    {
        $result = array();
        $d = dir($dir);
        while (false !== ($entry = $d->read())) {
            if (is_file($dir.$entry)) {
                if(preg_match($file_pattern, $entry)) {
                    $result[$entry] = date("Y/m/d H:i:s", filemtime($dir.$entry));
                }
            }
        }
        $d->close();
        
        return $result;
    }

    /**
     * サービスの取得
     */
    private function getServicePaths($dir, $namespane='')
    {
        $result = array();
        $d = dir($dir);
        while (false !== ($entry = $d->read())) {
            if ('.'===$entry || '..'===$entry) {
                continue;
            } else if (is_file($dir.$entry)) {
                $matches = array();
                if (preg_match("/^(.*)\.service\.php$/", $entry,$matches)) {
                    $result[$namespane.$matches[1]] = date("Y/m/d H:i:s", filemtime($dir.$entry));
                }
            } else if (is_dir($dir.$entry)) {
                $tmp = $this->getServicePaths($dir.$entry.'/', $namespane.$entry.'.');
                $result = array_merge( $result, $tmp);
            }
        }
        $d->close();
        
        return $result;
    }
}
?>
