<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Visitor.class.php 96 2006-04-21 14:51:52Z sakamoto $
 */

/**
 * AutoSOAP_XMLogicオブジェクトに対して処理を行います。
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
abstract class AutoSOAP_XMLogic_Visitor {
    private $_result = null;
    /**
     * 結果を設定する
     */
    protected function setResult($result)
    {
        $this->_result = $result;
    } 
    /**
     * 結果を返す
     */
    public function getResult()
    {
        return $this->_result;
    } 
    // エレメントを処理する
    abstract public function visitElement(AutoSOAP_XMLogic_Element $elem); 
    // 名前を処理する
    abstract public function visitVariable(AutoSOAP_XMLogic_Variable $nobj); 
    // 内容を処理する
    abstract public function visitContent(AutoSOAP_XMLogic_Content $content); 
    // 子を処理する
    abstract public function visitChildren(AutoSOAP_XMLogic_Children $children); 
    // 属性を処理する
    abstract public function visitAttribute(AutoSOAP_XMLogic_Attribute $attr); 
    // ネームスペースを処理する
    abstract public function visitXmlns(AutoSOAP_XMLogic_NS $nsobj);
} 

?>