<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: WsdlFactory.class.php 93 2006-04-16 15:23:57Z sakamoto $
 */

/**
 * WSDLの生成に必要なパーツを生成する為のFactoryクラスです
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_WsdlFactory {
    const XMLNS_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    const XMLNS_SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    const XMLNS_SOAP_ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    const XMLNS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    const XMLNS_HTTP = "http://schemas.xmlsoap.org/soap/http";
    const XMLNS_MIME = "http://schemas.xmlsoap.org/wsdl/mime/";

    private static $instance;
    private $_fctry;

    private function __construct()
    {
        $this -> _fctry = AutoSOAP_XMLogic_XMLFactory :: getInstance();
        $this -> _schemafctry = AutoSOAP_XMLogic_SchemaFactory :: getInstance();
    } 

    public static function getInstance()
    {
        if (self :: $instance == null) {
            self :: $instance = new AutoSOAP_XMLogic_WsdlFactory();
        } 
        return self :: $instance;
    } 

    /**
     * ルートを生成する
     */
    public function createRoot($targetnamespace)
    {
        $tmp = $this -> _fctry -> node("definitions", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> xmlns('wsdl', self :: XMLNS_WSDL));
        $tmp -> add($this -> _fctry -> xmlns('soap', self :: XMLNS_SOAP));
        $tmp -> add($this -> _fctry -> xmlns('soapenc', self :: XMLNS_SOAP_ENC));
        $tmp -> add($this -> _fctry -> xmlns('xsd', AutoSOAP_XMLogic_SchemaFactory :: XMLNS_XSD));
        $tmp -> add($this -> _fctry -> xmlns('tns', $targetnamespace));
        $tmp -> add($this -> _fctry -> attr("targetNamespace", $targetnamespace));

        return $tmp;
    } 

    /**
     * Typesを生成する
     */
    public function createTypes()
    {
        return $this -> _fctry -> node("types", self :: XMLNS_WSDL);
    } 

    /**
     * Messageを生成する
     */
    public function createMessage($name)
    {
        $tmp = $this -> _fctry -> node("message", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr("name", $name));

        return $tmp;
    } 

    /**
     * Partを生成する
     */
    public function createPart($name, $type = null, $namespace = null, $options = null)
    {
        if (is_null($namespace))
            $namespace = AutoSOAP_XMLogic_SchemaFactory :: XMLNS_XSD;
        $tmp = $this -> _fctry -> node("part", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr('name', $name));
        if (0 < strlen($type))
            $tmp -> add($this -> _fctry -> attr("type", array($type, $namespace))); 
        // if(isset($options['default'])) {
        // $tmp->add($this->_fctry->attr('minOccurs','0'));
        // }
        return $tmp;
    } 

    /**
     * PortTypeを生成する
     */
    public function createPortType($name)
    {
        $tmp = $this -> _fctry -> node("portType", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr("name", $name));

        return $tmp;
    } 

    /**
     * PortType用Operationを生成する
     */
    public function createOperationOfPortType($name, $input_name, $output_name, $namespace)
    {
        $tmp = $this -> _fctry -> node("operation", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr("name", $name));

        if (!is_null($input_name)) {
            $input = $this -> _fctry -> node("input", self :: XMLNS_WSDL);
            $input -> add($this -> _fctry -> attr("message", array($input_name, $namespace)));
            $tmp -> add($input);
        } 
        if (!is_null($output_name)) {
            $output = $this -> _fctry -> node("output", self :: XMLNS_WSDL);
            $output -> add($this -> _fctry -> attr("message", array($output_name, $namespace)));
            $tmp -> add($output);
        } 
        return $tmp;
    } 

    /**
     * Bindingを生成する
     */
    public function createBinding($name, $type, $namespace, $transport)
    {
        $tmp = $this -> _fctry -> node("binding", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr("name", $name));
        $tmp -> add($this -> _fctry -> attr("type", array($type, $namespace))); 
        // トランスポート
        $tmp_port = $this -> _fctry -> node("binding", self :: XMLNS_SOAP);
        $tmp_port -> add($this -> _fctry -> attr("style", 'rpc'));
        $tmp_port -> add($this -> _fctry -> attr("transport", $transport));
        $tmp -> add($tmp_port);

        return $tmp;
    } 

    /**
     * Binding用Operationを生成する
     */
    public function createOperationOfBinding($name, $flg_input, $flg_output, $namespace)
    {
        $tmp = $this -> _fctry -> node("operation", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr("name", $name)); 
        // action追加
        $action = $this -> _fctry -> node("operation", self :: XMLNS_SOAP);
        $action -> add($this -> _fctry -> attr("soapAction", $name));
        $tmp -> add($action);

        if (true === $flg_input) {
            $input = $this -> _fctry -> node("input", self :: XMLNS_WSDL); 
            // body
            $input_body = $this -> _fctry -> node("body", self :: XMLNS_SOAP);
            $input_body -> add($this -> _fctry -> attr("use", 'encoded'));
            $input_body -> add($this -> _fctry -> attr("namespace", $namespace));
            $input_body -> add($this -> _fctry -> attr("encodingStyle", self :: XMLNS_SOAP_ENC));

            $input -> add($input_body);
            $tmp -> add($input);
        } 
        if (true === $flg_output) {
            $output = $this -> _fctry -> node("output", self :: XMLNS_WSDL); 
            // body
            $output_body = $this -> _fctry -> node("body", self :: XMLNS_SOAP);
            $output_body -> add($this -> _fctry -> attr("use", 'encoded'));
            $output_body -> add($this -> _fctry -> attr("namespace", $namespace));
            $output_body -> add($this -> _fctry -> attr("encodingStyle", self :: XMLNS_SOAP_ENC));

            $output -> add($output_body);
            $tmp -> add($output);
        } 
        return $tmp;
    } 

    /**
     * Serviceを生成する
     */
    public function createService($name, $binding_name, $namespace, $location)
    {
        $tmp = $this -> _fctry -> node("service", self :: XMLNS_WSDL);
        $tmp -> add($this -> _fctry -> attr("name", $name)); 
        // port
        $port = $this -> _fctry -> node("port", self :: XMLNS_WSDL);
        $port -> add($this -> _fctry -> attr("name", $binding_name));
        $port -> add($this -> _fctry -> attr("binding", array($binding_name, $namespace))); 
        // address
        $address = $this -> _fctry -> node("address", self :: XMLNS_SOAP);
        $address -> add($this -> _fctry -> attr("location", $location));

        $port -> add($address);
        $tmp -> add($port);
        return $tmp;
    } 

    /**
     * 配列型のエレメントを生成する
     */
    function createArray($name, $type, $namespace)
    {
        if (is_null($namespace))
            $namespace = AutoSOAP_XMLogic_SchemaFactory :: XMLNS_XSD;

        $tmp = $this -> _schemafctry -> createComplexType($name);
        $content = $this -> _schemafctry -> createComplexContent();

        $rest = $this -> _schemafctry -> createRestrictionBase('Array', self :: XMLNS_SOAP_ENC);

        $attr = $this -> _schemafctry -> createAttributeRef('arrayType', self :: XMLNS_SOAP_ENC);
        $attr -> add($this -> _fctry -> attr(array('arrayType', self :: XMLNS_WSDL), array($type . '[]', $namespace)));

        $rest -> add($attr);
        $content -> add($rest);
        $tmp -> add($content);

        return $tmp;
    } 

    /**
     * 説明文を生成する
     */
    function createDoc($doc)
    {
        return $this -> _fctry -> content("documentation", $doc, self :: XMLNS_WSDL);
    } 
} 

?>