<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: exportTextVisitor.class.php 93 2006-04-16 15:23:57Z sakamoto $
 */

/**
 * XMLの文字列にエクスポートします。
 * 結果には成功した場合にはTRUE、失敗した場合はFALSEを返します。
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_exportTextVisitor extends AutoSOAP_XMLogic_Visitor {
    private $_flg_start = false;
    private $_flg_error = false;

    /**
     * エクスポート処理をする
     */
    private function export(AutoSOAP_XMLogic_Obj $target, $func)
    { 
        // エラーチェック
        if (true == $this -> _flg_error) {
            return false;
        } 

        $is_root = false;
        if (false === $this -> _flg_start) {
            $this -> setResult("");
            $this -> _flg_start = true;
            $this -> _flg_error = false;
            $is_root = true;
        } 
        // パーツがエクスポートした結果を取得
        $result = $this -> $func($target); 
        // --------------------------------
        // エラーチェック
        if (true == $this -> _flg_error) {
            return false;
        } 
        // このパーツがルートなら結果を格納して終わる
        if ($is_root) {
            $this -> setResult($result);
            $this -> _flg_error = false;
            $this -> _flg_start = false;
            return true;
        } 
        // エクスポートした結果を親へ返す
        return $result;
    } 

    /**
     * 結果を返す
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        if (is_null($to_encoding)) {
            $result = "<?xml version=\"1.0\" encoding=\"" . mb_internal_encoding() . "\"?>\n" . parent :: getResult();
            return $result;
        } else if (is_null($from_encoding)) {
            $result = "<?xml version=\"1.0\" encoding=\"" . $to_encoding . "\"?>\n" . parent :: getResult();
            return mb_convert_encoding($result, $to_encoding);
        } else {
            $result = "<?xml version=\"1.0\" encoding=\"" . $to_encoding . "\"?>\n" . parent :: getResult();
            return mb_convert_encoding($result, $to_encoding, $from_encoding);
        } 
    } 
    // エレメントを処理する
    public function visitElement(AutoSOAP_XMLogic_Element $elem)
    {
        return $this -> export($elem, "exportElement");
    } 
    // 名前を処理する
    public function visitVariable(AutoSOAP_XMLogic_Variable $nobj)
    {
        return $this -> export($nobj, "exportVariable");
    } 
    // 内容を処理する
    public function visitContent(AutoSOAP_XMLogic_Content $content)
    {
        return $this -> export($content, "exportContent");
    } 
    // 子を処理する
    public function visitChildren(AutoSOAP_XMLogic_Children $children)
    {
        return $this -> export($children, "exportChildren");
    } 
    // 属性を処理する
    public function visitAttribute(AutoSOAP_XMLogic_Attribute $attr)
    {
        return $this -> export($attr, "exportAttribute");
    } 
    // ネームスペースを処理する
    public function visitXmlns(AutoSOAP_XMLogic_NS $nsobj)
    {
        return $this -> export($nsobj, "exportXmlns");
    } 
    // エレメントをエクスポート
    private function exportElement(AutoSOAP_XMLogic_Element $elem)
    {
        $name = $elem -> getTagName() -> accept($this);
        $node = $elem -> getNode() -> accept($this);
        $attr = $elem -> getAttribute() -> accept($this);
        $xmlns = $elem -> getXmlns() -> accept($this);
        $result = "";

        $result = "<" . $name;
        if ('' != $attr)
            $result .= $attr;
        if ('' != $xmlns)
            $result .= $xmlns;

        if ('' == $node) {
            return $result . "/>\n";
        } 

        $result .= ">";
        $result .= ((preg_match("/[\n]/", $node))?"\n":"") . $node;
        $result .= "</" . $name . ">\n";

        return $result;
    } 
    // 名前をエクスポート
    private function exportVariable(AutoSOAP_XMLogic_Variable $nobj)
    {
        $name = htmlspecialchars($nobj -> getName());
        if (0 == strlen($nobj -> getNamespace())) {
            return $name;
        } 
        $ns = $this -> searchXmlns($nobj, $nobj -> getNamespace());
        return ('' == $ns)
        ? $name
        : $ns . ':' . $name;
    } 
    // 内容をエクスポート
    private function exportContent(AutoSOAP_XMLogic_Content $content)
    {
        return htmlspecialchars($content -> getContent());
    } 
    // 子をエクスポート
    private function exportChildren(AutoSOAP_XMLogic_Children $children)
    {
        $result = "";
        $itr = $children -> getIterator();
        while ($itr -> valid()) {
            $result .= $itr -> current() -> accept($this);
            $itr -> next();
        } 
        return $result;
    } 
    // 属性をエクスポート
    private function exportAttribute(AutoSOAP_XMLogic_Attribute $attr)
    {
        return " " . $attr -> getKey() -> accept($this) . '="' . $attr -> getValue() -> accept($this) . '"';
    } 
    // ネームスペースをエクスポート
    private function exportXmlns(AutoSOAP_XMLogic_NS $nsobj)
    {
        return ('' == $nsobj -> getNS())
        ? ' xmlns="' . $nsobj -> getURI() . '"'
        : ' xmlns:' . $nsobj -> getNS() . '="' . $nsobj -> getURI() . '"' ;
    } 

    /**
     * ネームスペースに対応するキーを返す
     */
    private function searchXmlns($target, $uri)
    {
        $search = new AutoSOAP_XMLogic_searchXmlnsVisitor($uri);
        if ($target -> accept($search))
            return $search -> getResult(); 
        // キーを見つけられず
        trigger_error("Namespace '" . $uri . "' was not found." , E_USER_WARNING);
        $this -> _flg_error = true;

        return null;
    } 
} 

?>