<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id$
 */
include_once("AutoSOAP/AutoSOAP.php");

/**
 * メインコマンドコマンド
 */
class AutoSOAP_Main_CMD {
    static private $commands = array(
        'php2wsdl'=>array('AutoSOAP_php2wsdl_CMD', "       generate WSDL files"),
        'installfw'=> array('AutoSOAP_installfw_CMD', "      install AutoSOAP Framework"),
    );
    static public function execute($argv) {
        if (isset(self::$commands[$argv[1]])) {
            $class = self::$commands[$argv[1]][0];
            unset($argv[0]);
            $cmd = new $class($argv);
            $cmd->execute();
        } else {
            echo "autosoap Command [options]\r\n";
            foreach (self::$commands as $command => $info) {
                echo $command . $info[1] . "\r\n";
            }
        }
    }
}

/**
 * フレームワークセットアップコマンド
 */
class AutoSOAP_installfw_CMD {
    private $modes = array(
        '--without-info'=>  array('set_without_info',0,"        Not install info.php."),
        '--without-server'=>array('set_without_server',0,"      Not install soap.php."),
        '--without-setup'=> array('without_setup',0,"       Not install setup.php."),
    );
    private $install_dir = null;
    private $ignores = array();
    private $exec_setup = true;

    public function __construct($argv) {
        date_default_timezone_set('GMT');
        $this->install_dir = $argv[2];

        $len = count($argv);
        if(1==$len) {
            echo "installfw InstallDrectory [options]\r\n";
            foreach ($this->modes as $command => $info) {
                echo $command . $info[2] . "\r\n";
            }
            $this->install_dir = null;
            return ;
        }
        $i = 3;
        while ($i<$len) {
            if (array_key_exists($argv[$i], $this->modes)) {
                $func = $this->modes[$argv[$i]][0];
                if (0==$this->modes[$argv[$i]][1]) {
                    $this->$func();
                }
                else {
                    $this->$func($argv[$i+1]);
                    $i += $this->modes[$argv[$i]][1];
                }
            }
            else {
                trigger_error("Command '{$argv[$i]}' is not valid.",E_USER_ERROR);
            }
            $i++;
        }
    }

    public function execute() {
        if (is_null($this->install_dir)) {
            return ;
        }
        if ( $this->install($this->install_dir, dirname(__FILE__).'/autosoapfw.tgz', $this->ignores) ) {
            if ($this->exec_setup) {
                ob_start(array($this,'ob_buff'));
                include($this->install_dir."/autosoapfw/setup.php");
                chmod($this->install_dir."/autosoapfw/data/options",0777);
                chmod($this->install_dir."/autosoapfw/data/validate",0777);
                chmod($this->install_dir."/autosoapfw/data/wsdls",0777);
                chmod($this->install_dir."/autosoapfw/data/vars",0777);
            }
        } else {
            echo "Can not install for not found Directory.\r\n";
        }
    }

    function install($installdir, $tar_file, $gnores) {
        $installdir = realpath($installdir);
        if(false===$installdir) {
            return false;
        }
        require_once 'Archive/Tar.php';
        $tar = new Archive_Tar($tar_file);
        $result = $tar->listContent();

        foreach($result as $num=>$fileinfo) {
            if(in_array($fileinfo['filename'], $gnores)) {
                continue;
            }
            $this->mkdir($installdir .'/'. $fileinfo['filename']);        
            $file = $installdir .'/'. $fileinfo['filename'];
            file_put_contents($file , $tar->extractInString($fileinfo['filename']));
        }
        return true;
    }

    private function mkdir($path)
    {
        $dir = dirname($path);
        $tmp = realpath($dir);
        if(!file_exists($tmp)) {
            if (false===@mkdir($dir)) {
                $this->mkdir($dir);
                @mkdir($dir);
            }
            echo "mkdir: ".$dir."\r\n";
        }
    }

    public function ob_buff($buff) {
        return "install OK\r\n";
    }

    public function set_without_info() {
        $this->ignores[] = '/autosoapfw/info.php';
    }

    public function set_without_server() {
        $this->ignores[] = '/autosoapfw/soap.php';
    }

    public function without_setup() {
        $this->exec_setup = false;
        $this->ignores[] = '/autosoapfw/setup.php';
        $this->ignores[] = '/autosoapfw/data/index.html';
    }
}
/**
 * WSDL生成コマンド
 */
class AutoSOAP_php2wsdl_CMD {
    private $modes = array(
        '-c'=>           array('set_class',1," ClassName       Only this class is exported."),
        '-l'=>           array('set_location',1," URI             The location is specified."),
        '-o'=>           array('set_output',1," Directory       Directory of output destination"),
        '--with-xsd'=>   array('set_output_xsd',0,"         The XSD file is generated."),
        '--with-option'=>array('set_output_option',0,"      The option file is generated."),
        '--show-wsdl'=>  array('set_show_wsdl',0,"        After it generates it, the state of WSDL is seen."),
    );
    private $target_file_path = null;
    private $classes = null;
    private $output = null;
    private $flg_output_xsd = false;
    private $flg_output_option = false;
    private $flg_show_wsdl = false;
    private $location = 'http://localhost/';

    private $server = null;

    public function __construct($argv) {
        date_default_timezone_set('GMT');
        $this->target_file_path = $argv[2];

        $len = count($argv);
        if(1==$len) {
            echo "php2wsdl ClassFile [options]\r\n";
            foreach ($this->modes as $command => $info) {
                echo $command . $info[2] . "\r\n";
            }
            return ;
        }
        $i = 3;
        while ($i<$len) {
            if (array_key_exists($argv[$i], $this->modes)) {
                $func = $this->modes[$argv[$i]][0];
                if (0==$this->modes[$argv[$i]][1]) {
                    $this->$func();
                }
                else {
                    $this->$func($argv[$i+1]);
                    $i += $this->modes[$argv[$i]][1];
                }
            }
            else {
                trigger_error("Command '{$argv[$i]}' is not valid.",E_USER_ERROR);
            }
            $i++;
        }

        /*
        * SOAP server generation
        */
        $this->server = AutoSOAP_Server::getInstance();
        $this->server->setEncoding("UTF-8", "Shift_JIS");
        restore_error_handler();
    }
  
    public function execute() {
        if (is_null($this->server))
            return ;
        //get Output Directory
        if(is_null($this->output)) {
            $this->output = dirname($this->target_file_path);
        }
        $this->output .= '/';

        //get export Classes
        if(is_null($this->classes)) {
            $contents = file_get_contents($this->target_file_path);
            $matches = array();
            $this->classes = array();
            if (preg_match_all("/\s*class\s+(\S+)/",$contents,$matches)) {
                $this->classes = $matches[1];
            }
        }
        foreach ($this->classes as $class_name) {
            $this->create_files($class_name);
        }
    }
  
    public function create_files($class_name) {
        /*
         * Setting
         */
        $wsdl_path     = $this->output .$class_name.".wsdl";
        $xsd_path      = (true===$this->flg_output_xsd) ? $this->output .$class_name.".xsd" : null;
        $option_path  = (true===$this->flg_output_option) ? $this->output .$class_name.".option.php" : null;
        $location      = $this->location.$class_name;
        $namespace     = "urn:".$class_name;

        $timestamp     = date("Y/m/d H:i:s");

        /*
         * create Service
         */
        $service = new AutoSOAP_Service(
                        $class_name,
                        $this->target_file_path,
                        $wsdl_path,
                        $xsd_path,
                        $option_path,
                        $location,
                        $namespace,
                        $timestamp
                    );

        /*
         *縲The SOAP service is set to the server.
         */
        $this->server->setService($service);
        
        echo "FIle: ".$wsdl_path." was generated.\n";
        
        //The result of WSDL is seen.
        if ($this->flg_show_wsdl) {
              $client = new SoapClient($wsdl_path, array('soap_version' => SOAP_1_1));
              echo "Methods:\n";
              print_r($client->__getFunctions());
              echo "Types:\n";
             print_r($client->__getTypes());
        }
    }

    public function set_output($param) {
        $this->output = $param;
    }
    public function set_location($param) {
        $this->location = $param;
    }

    public function set_class($param) {
        $this->classes = array($param);
    }
    public function set_output_xsd() {
        $this->flg_output_xsd = true;
    }
    public function set_show_wsdl() {
        $this->flg_show_wsdl = true;
    }
    public function set_output_option() {
        $this->flg_output_option = true;
    }
}
?>
