/*
 * Decompiled with CFR 0.152.
 */
package avis.motion;

import avis.motion.Drivant;
import avis.motion.Group;
import avis.motion.MMachine;
import avis.motion.MMachineBuilder;
import avis.motion.MotionController;
import avis.motion.Parameters;
import avis.sprite.ASprite;

public abstract class MMachineSpec {
    protected MMachineBuilder builder;
    protected MotionController controller;

    protected MMachineSpec() {
    }

    public void builder(MMachineBuilder builder) {
        this.builder = builder;
    }

    public void controller(MotionController controller) {
        this.controller = controller;
    }

    public MMachine createMMachine(int priority, double x, double y, int direction, double velocity, Group group, Object additionalParameter) {
        MMachine ret = this.produce(priority, x, y, direction, velocity, group, additionalParameter);
        return ret;
    }

    protected MMachine produce(int priority, double x, double y, int direction, double velocity, Group groupId, Object additionalParameter) {
        Drivant drivant = this.createDrivant();
        drivant.label(this.label());
        Parameters parameters = drivant.createInitialParameters();
        parameters.x = x;
        parameters.y = y;
        parameters.direction = direction;
        parameters.velocity = velocity;
        parameters.alive = true;
        parameters.height = 20.0;
        parameters.width = 20.0;
        parameters.groupId = groupId;
        this.setupParameters(parameters, additionalParameter);
        MMachine ret = this.builder.buildMMachine(drivant, parameters, this.spriteSpecName(), this.spritePriority());
        this.controller.add(ret);
        ret.sprite().addObserver(this.builder.plane());
        ret.sprite().priority(priority);
        return ret;
    }

    protected abstract void setupParameters(Parameters var1, Object var2);

    protected abstract String spriteSpecName();

    protected abstract Drivant createDrivant();

    protected int spritePriority() {
        return ASprite.defaultPriority;
    }

    public void dispose() {
    }

    public abstract String label();
}

