/*
 * Decompiled with CFR 0.152.
 */
package avis.motion;

import avis.base.Avis;
import avis.motion.Drivant;
import avis.motion.Group;
import avis.motion.InteractionHandler;
import avis.motion.MMachine;
import avis.motion.MMachineStateException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.TreeMap;

public final class MotionController {
    private InteractionHandler interactionHandler = null;
    private List<MMachine> mmachines;
    private List<MMachine> tmpMMachines;
    private SortedMap<Group, List<MMachine>> groups;

    public void init() {
        this.tmpMMachines = new LinkedList<MMachine>();
        this.mmachines = new LinkedList<MMachine>();
        this.groups = new TreeMap<Group, List<MMachine>>();
    }

    public void action() {
        this.prepareMMachines();
        this.performMMachines();
        this.interactMMachines();
        this.commitMMachines();
    }

    public void update() {
        this.registerNewMMachines();
    }

    public void prepareMMachines() {
        for (MMachine cur : this.mmachines) {
            cur.drivant().prepare();
        }
    }

    public void performMMachines() {
        for (MMachine mmachine : this.mmachines) {
            mmachine.drivant.perform();
        }
    }

    public void interactMMachines() {
        for (MMachine mmachine : this.mmachines) {
            mmachine.drivant.beforeInteraction();
        }
        for (Group iGroup : this.groups.keySet()) {
            for (Group jGroup : this.groups.tailMap(iGroup).keySet()) {
                this.interaction(iGroup, jGroup);
            }
        }
        for (MMachine mmachine : this.mmachines) {
            mmachine.drivant.afterInteraction();
        }
    }

    protected void collision(Drivant d1, Drivant d2, double distance) {
        if (d1.isCollisionDetectEnabled() && d2.isCollisionDetectEnabled() && this.interactionHandler.collides(d1, d2, distance)) {
            this.interactionHandler.handleCollision(d1, d2, distance);
        }
    }

    protected void interaction(Group iGroup, Group jGroup) {
        if (this.interactionHandler == null) {
            return;
        }
        List group1 = (List)this.groups.get(iGroup);
        List group2 = (List)this.groups.get(jGroup);
        boolean collides = iGroup.collides(jGroup);
        boolean interacts = iGroup.interacts(jGroup);
        if (collides || interacts) {
            ListIterator iGroup1 = group1.listIterator();
            while (iGroup1.hasNext()) {
                MMachine mmachine1 = (MMachine)iGroup1.next();
                ListIterator iGroup2 = iGroup.equals(jGroup) ? group2.listIterator(iGroup1.nextIndex()) : group2.listIterator();
                while (iGroup2.hasNext()) {
                    MMachine mmachine2 = (MMachine)iGroup2.next();
                    Drivant d1 = mmachine1.drivant();
                    Drivant d2 = mmachine2.drivant();
                    double distance = this.distance(d1, d2);
                    if (collides) {
                        this.collision(d1, d2, distance);
                    }
                    if (!interacts) continue;
                    this.interact(d1, d2, distance);
                }
            }
        }
    }

    public void commitMMachines() {
        for (MMachine cur : this.mmachines) {
            try {
                cur.drivant().commit();
            }
            catch (MMachineStateException e) {
                e.printStackTrace();
            }
        }
    }

    protected void registerNewMMachines() {
        if (this.tmpMMachines.size() > 0) {
            for (MMachine mmachine : this.tmpMMachines) {
                Drivant drivant = mmachine.drivant();
                Group groupId = drivant.groupId();
                if (groupId != null) {
                    LinkedList<MMachine> mmachinesInGroup = (LinkedList<MMachine>)this.groups.get(groupId);
                    if (mmachinesInGroup == null) {
                        mmachinesInGroup = new LinkedList<MMachine>();
                        this.groups.put(groupId, mmachinesInGroup);
                    }
                    mmachinesInGroup.add(mmachine);
                }
                this.mmachines.add(0, mmachine);
            }
            this.tmpMMachines.clear();
        }
    }

    public void scavengeMMachines() {
        Iterator<MMachine> j = this.mmachines.iterator();
        while (j.hasNext()) {
            MMachine mmachine = j.next();
            Drivant drivant = mmachine.drivant();
            if (drivant.isValid()) continue;
            this.unregisterMMachine(mmachine);
            j.remove();
        }
    }

    protected void unregisterMMachine(MMachine mmachine) {
        Drivant drivant = mmachine.drivant();
        mmachine.sprite().dispose();
        Group groupId = drivant.groupId();
        if (groupId != null) {
            List group = (List)this.groups.get(groupId);
            group.remove(mmachine);
        }
    }

    public List<MMachine> mmachines() {
        return this.mmachines;
    }

    public void add(MMachine mmachine) {
        this.tmpMMachines.add(mmachine);
    }

    protected void interact(Drivant d1, Drivant d2, double distance) {
        this.interactionHandler.handleInteraction(d1, d2, distance);
    }

    protected double distance(Drivant aDrivant, Drivant bDrivant) {
        return aDrivant.distance(bDrivant);
    }

    public void dump() {
        Avis.logger().debug("MotionController=<" + this + ">");
        Iterator<MMachine> iMMachines = this.mmachines.iterator();
        while (iMMachines.hasNext()) {
            Avis.logger().debug("cur=<" + iMMachines.next() + ">");
        }
    }

    public void interactionHandler(InteractionHandler handler) {
        this.interactionHandler = handler;
    }
}

