/*
 * Decompiled with CFR 0.152.
 */
package avis.session;

import avis.base.AException;
import avis.base.AResourceLoader;
import avis.base.AResourceObserver;
import avis.base.Avis;
import avis.base.Configuration;
import avis.input.AInputDevice;
import avis.motion.Drivant;
import avis.motion.MMachine;
import avis.motion.MMachineBuilder;
import avis.motion.MMachineBuilderImpl;
import avis.motion.MMachineSpec;
import avis.motion.MotionController;
import avis.session.AScenario;
import avis.session.AScenarioEvent;
import avis.sound.ABGMManager;
import avis.sound.ADefaultBGMManager;
import avis.sound.ADefaultSoundManager;
import avis.sound.AMultiThreadedSoundManager;
import avis.sound.ASoundManager;
import avis.spec.ASpriteSpecManager;
import avis.sprite.ASprite;
import avis.video.AScreen;
import avis.video.AVideoEngine;
import com.centralnexus.input.Joystick;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;

public abstract class ASession
implements AResourceObserver {
    public static final int EXIT_ABNORMAL = -1;
    public static final int EXIT_NORMAL = 0;
    public static final int EXIT_NEXT = 1;
    public static final int EXIT_CONTINUE = 2;
    public static final int EXIT_RESTART = 3;
    public static final int EXIT_QUIT = 4;
    private static final int MAX_VOICES = 2;
    private static final long serialVersionUID = 1L;
    private ABGMManager bgmManager;
    protected MMachineBuilder builder = null;
    protected MotionController controller;
    private boolean exit;
    private int exitCode;
    protected int interval;
    protected AScenario scenario = null;
    protected AScreen screen;
    private ASoundManager soundManager;
    protected ASpriteSpecManager spriteSpecManager;
    private boolean renderingEnabled;
    private boolean statisticsEnabled;
    private Image logoImage;

    protected static Configuration.DebugMode chooseDebugMode(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-debug=GRID".equals(args[i])) {
                    return Configuration.DebugMode.GRID;
                }
                if ("-debug=SCENARIOSKIP".equals(args[i])) {
                    return Configuration.DebugMode.SCENARIOSKIP;
                }
                if ("-debug=NORMAL".equals(args[i])) {
                    return Configuration.DebugMode.NORMAL;
                }
                ++i;
            }
        }
        return Configuration.DebugMode.NORMAL;
    }

    protected static int chooseLogLevel(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-log=DEBUG".equals(args[i])) {
                    return 100;
                }
                if ("-log=INFO".equals(args[i])) {
                    return 1000;
                }
                if ("-log=STATISTICS".equals(args[i])) {
                    return 10000;
                }
                if ("-log=ERROR".equals(args[i])) {
                    return 100000;
                }
                ++i;
            }
        }
        return 10000;
    }

    protected static ASession chooseSession(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                String className;
                Class<?> clazz;
                Object ret;
                String key = "-session=";
                if (args[i].startsWith("-session=") && (ret = (clazz = Class.forName(className = args[i].substring(key.length()))).newInstance()) instanceof ASession) {
                    return (ASession)ret;
                }
                ++i;
            }
        }
        throw new Exception("No session specified.");
    }

    protected static Font chooseFont(String[] args) throws Exception {
        Font ret = new Font("Serif", 0, 12);
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-font=")) {
                    String fontName = args[i].substring(6).replace("\"", "");
                    ret = new Font(fontName, 0, 12);
                    return ret;
                }
                ++i;
            }
        }
        return ret;
    }

    protected static Configuration.SoundMode chooseSoundMode(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-sound=SILENT".equals(args[i])) {
                    return Configuration.SoundMode.SILENT;
                }
                if ("-sound=BGMONLY".equals(args[i])) {
                    return Configuration.SoundMode.BGMONLY;
                }
                if ("-sound=MULTITHREADED".equals(args[i])) {
                    return Configuration.SoundMode.MULTITHREADED;
                }
                ++i;
            }
        }
        return Configuration.SoundMode.NORMAL;
    }

    protected static Configuration.RenderingMode chooseRenderingMode(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-rendering=VOLATILE".equals(args[i])) {
                    return Configuration.RenderingMode.VOLATILE;
                }
                if ("-rendering=BUFFERED".equals(args[i])) {
                    return Configuration.RenderingMode.BUFFERED;
                }
                ++i;
            }
        }
        return Configuration.RenderingMode.BUFFERED;
    }

    protected static Configuration.VideoMode chooseVideoMode(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-video=FULL".equals(args[i])) {
                    return Configuration.VideoMode.FULL;
                }
                ++i;
            }
        }
        return Configuration.VideoMode.NORMAL;
    }

    protected static Configuration.FrameMode chooseFrameMode(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-frame=DROP".equals(args[i])) {
                    return Configuration.FrameMode.DROP;
                }
                if ("-frame=NONDROP".equals(args[i])) {
                    return Configuration.FrameMode.NONDROP;
                }
                ++i;
            }
        }
        return Configuration.FrameMode.NONDROP;
    }

    protected static Configuration.BgQualityMode chooseBgQualityMode(String[] args) throws Exception {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-bgquality=LOW".equals(args[i])) {
                    return Configuration.BgQualityMode.LOW;
                }
                if ("-bgquality=HIGH".equals(args[i])) {
                    return Configuration.BgQualityMode.HIGH;
                }
                ++i;
            }
        }
        return Configuration.BgQualityMode.HIGH;
    }

    protected static Configuration.JoystickMode chooseJoystickMode(String[] args) {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-joystick=DISABLED".equals(args[i])) {
                    return Configuration.JoystickMode.DISABLED;
                }
                if ("-joystick=PS3".equals(args[i])) {
                    return Configuration.JoystickMode.PS3;
                }
                if ("-joystick=JOYPAD".equals(args[i])) {
                    return Configuration.JoystickMode.JOYPAD;
                }
                ++i;
            }
        }
        return Configuration.JoystickMode.DISABLED;
    }

    protected static Configuration.RotationMode chooseRotationMode(String[] args) {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if ("-rotation=DISABLED".equals(args[i])) {
                    return Configuration.RotationMode.DISABLED;
                }
                ++i;
            }
        }
        return Configuration.RotationMode.ENABLED;
    }

    protected static ASession createSession(String[] args) throws Exception {
        if (args.length < 1) {
            throw new Exception("A class name should be given as a parameter.");
        }
        Class<?> clazz = Class.forName(args[0]);
        ASession session = (ASession)clazz.newInstance();
        return session;
    }

    public static void main(String[] args) throws Exception {
        Avis.logger().level(ASession.chooseLogLevel(args));
        System.setErr(System.out);
        Configuration.session = ASession.chooseSession(args);
        Configuration.debugMode = ASession.chooseDebugMode(args);
        Configuration.soundMode = ASession.chooseSoundMode(args);
        Configuration.videoMode = ASession.chooseVideoMode(args);
        Configuration.frameMode = ASession.chooseFrameMode(args);
        Configuration.defaultFont = ASession.chooseFont(args);
        Configuration.renderingMode = ASession.chooseRenderingMode(args);
        Configuration.bgQualityMode = ASession.chooseBgQualityMode(args);
        Configuration.joystickMode = ASession.chooseJoystickMode(args);
        Configuration.rotationMode = ASession.chooseRotationMode(args);
        Avis.logger().statistics(Configuration.dump());
        Avis.logger().statistics(System.getProperties().toString());
        int ret = -1;
        try {
            try {
                Configuration.session.perform();
                ret = 0;
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
                System.exit(ret);
            }
        }
        finally {
            System.exit(ret);
        }
    }

    protected void afterInit(AScenario scenario) {
    }

    protected void afterRun(AScenario scenario) {
    }

    protected void afterTerminate(AScenario scenario) {
    }

    protected void aftetrLayout() {
    }

    protected abstract String backgroundImageResourceName();

    protected void beforeInit(AScenario scenario) {
    }

    protected void beforeLayout() {
    }

    protected void beforeRun(AScenario scenario) {
    }

    protected void beforeTerminate(AScenario scenario) {
    }

    protected abstract String[] bgmResources();

    protected AScenario createDefaultScenario() throws AException {
        return new AScenario(){

            @Override
            public AScenarioEvent action() {
                return AScenarioEvent.NULL_EVENT;
            }

            @Override
            public String backgroundImageResource() {
                return null;
            }

            @Override
            public void init(ASession session) throws AException {
            }

            @Override
            public void registered(Drivant drivant) {
            }

            @Override
            public void emit(Drivant source, MMachineSpec emittable) {
            }

            @Override
            public void reset() {
            }

            @Override
            public void handleCollision(Drivant d1, Drivant d2, double distance) {
            }

            @Override
            public boolean collides(Drivant d1, Drivant d2, double distance) {
                return false;
            }

            @Override
            public void handleInteraction(Drivant d1, Drivant d2, double distance) {
            }
        };
    }

    public int exec(AScenario scenario) throws Exception {
        int ret = -1;
        ASession session = this;
        session.beforeInit(scenario);
        try {
            session.init(scenario);
        }
        finally {
            session.afterInit(scenario);
        }
        try {
            session.beforeRun(scenario);
            try {
                ret = session.run(scenario);
            }
            finally {
                session.afterRun(scenario);
            }
        }
        finally {
            session.beforeTerminate(scenario);
            try {
                session.terminate(scenario);
            }
            finally {
                session.afterTerminate(scenario);
            }
        }
        return ret;
    }

    public void exit(int exitCode) {
        this.exitCode(exitCode);
        this.exit = true;
    }

    public ABGMManager getBgmManager() {
        return this.bgmManager;
    }

    public ASoundManager getSoundManager() {
        return this.soundManager;
    }

    protected MotionController createMotionController() {
        MotionController ret = new MotionController();
        ret.init();
        return ret;
    }

    private void initBgm() throws AException {
        this.bgmManager = new ADefaultBGMManager();
        if (Configuration.soundMode == Configuration.SoundMode.SILENT) {
            this.bgmManager = ABGMManager.NULL_BGM_MANAGER;
            return;
        }
        String[] bgms = this.bgmResources();
        int i = 0;
        while (i < bgms.length) {
            this.getBgmManager().load(bgms[i]);
            ++i;
        }
    }

    private void initSound() throws AException {
        block11: {
            String[] soundEffects = this.soundEffectResources();
            this.soundManager = null;
            if (Configuration.soundMode == Configuration.SoundMode.SILENT || Configuration.soundMode == Configuration.SoundMode.BGMONLY) {
                this.soundManager = ASoundManager.NULL_SOUND_MANAGER;
                return;
            }
            ADefaultSoundManager tmpSoundManager = null;
            try {
                try {
                    tmpSoundManager = new ADefaultSoundManager();
                    int i = 0;
                    while (i < soundEffects.length) {
                        ((ASoundManager)tmpSoundManager).load(soundEffects[i]);
                        ++i;
                    }
                    ((ASoundManager)tmpSoundManager).prepare(2);
                }
                catch (AException e) {
                    e.printStackTrace();
                    if (tmpSoundManager == null) {
                        System.err.println("FAILED TO INITIALIZE SoundManager, using dummy SoundManager instead.");
                        this.soundManager = ASoundManager.NULL_SOUND_MANAGER;
                        break block11;
                    }
                    if (Configuration.soundMode == Configuration.SoundMode.MULTITHREADED) {
                        this.soundManager = new AMultiThreadedSoundManager(tmpSoundManager);
                        break block11;
                    }
                    this.soundManager = tmpSoundManager;
                }
            }
            finally {
                if (tmpSoundManager == null) {
                    System.err.println("FAILED TO INITIALIZE SoundManager, using dummy SoundManager instead.");
                    this.soundManager = ASoundManager.NULL_SOUND_MANAGER;
                } else {
                    this.soundManager = Configuration.soundMode == Configuration.SoundMode.MULTITHREADED ? new AMultiThreadedSoundManager(tmpSoundManager) : tmpSoundManager;
                }
            }
        }
    }

    public int interval() {
        return this.interval / 1000000;
    }

    protected void layout() {
        for (MMachine mmachine : this.controller.mmachines()) {
            Drivant drivant = mmachine.drivant();
            ASprite sprite = mmachine.sprite();
            this.layout(sprite, drivant);
        }
    }

    public abstract void layout(ASprite var1, Drivant var2);

    public int run(AScenario scenario) throws LineUnavailableException, IOException, AException {
        this.exit = false;
        this.enableRendering();
        this.controller.dump();
        Statistics overall = new Statistics();
        Statistics normal = new Statistics();
        Statistics framedrops = new Statistics();
        Statistics current = new Statistics();
        long frameDebt = 0L;
        this.enableStatistics();
        while (!this.exit) {
            this.stick().poll();
            if (this.screen.isClosed() || this.stick().trigger(AInputDevice.Trigger.SELECT)) {
                this.exitCode(4);
                break;
            }
            if (Configuration.debugMode == Configuration.DebugMode.SCENARIOSKIP && this.stick().trigger(AInputDevice.Trigger.HELP)) {
                this.exitCode(1);
                break;
            }
            long before = System.nanoTime();
            this.beforeAction(scenario);
            this.action(scenario);
            this.afterAction(scenario);
            long p0 = System.nanoTime();
            current.actionRunningTime = p0 - before;
            if (this.renderingEnabled && frameDebt <= 0L) {
                this.beforeLayout();
                this.layout();
                this.aftetrLayout();
                long p1 = System.nanoTime();
                current.layoutRunningTime = p1 - p0;
                this.screen.render();
                long p2 = System.nanoTime();
                current.videoRenderingRunningTime = p2 - p1;
                this.soundManager.render();
                current.soundRenderingRunningTime = System.nanoTime() - p2;
            }
            this.controller.scavengeMMachines();
            long after = System.nanoTime();
            long timeSpent = after - before + frameDebt;
            try {
                long durationToWait = (long)this.interval - timeSpent;
                if (this.renderingEnabled && this.isStatisticsEnabled()) {
                    current.numberOfTimesActionPerformed = 1;
                    current.amountTimeSpent = timeSpent;
                    overall.add(current);
                    if (durationToWait < 0L) {
                        framedrops.add(current);
                    } else {
                        normal.add(current);
                    }
                }
                if (frameDebt <= 0L) {
                    Thread.sleep(Math.max(durationToWait / 1000000L, 0L));
                }
                frameDebt = Configuration.frameMode == Configuration.FrameMode.NONDROP ? 0L : Math.max(0L, -durationToWait);
            }
            catch (InterruptedException e) {
                assert (false) : "\u5272\u308a\u8fbc\u307f\u4f8b\u5916\u767a\u751f";
            }
        }
        this.disableStatistics();
        Avis.logger().statistics("Overall");
        overall.dump();
        Avis.logger().statistics("Normal");
        normal.dump();
        Avis.logger().statistics("Framedrops");
        framedrops.dump();
        return this.exitCode();
    }

    public void enableStatistics() {
        this.statisticsEnabled = true;
    }

    public void disableStatistics() {
        this.statisticsEnabled = false;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    protected void afterAction(AScenario scenario) throws AException {
        scenario.afterAction();
    }

    protected void action(AScenario scenario) throws AException {
        scenario.action();
    }

    protected void beforeAction(AScenario scenario) throws AException {
        scenario.beforeAction();
    }

    public AScenario scenario() {
        return this.scenario;
    }

    public AScreen screen() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void soundEffect(String resourceName) {
        ASoundManager aSoundManager = this.soundManager;
        synchronized (aSoundManager) {
            try {
                this.soundManager.play(resourceName);
            }
            catch (AException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract String[] soundEffectResources();

    public AInputDevice stick() {
        return this.screen.stick();
    }

    public void terminate(AScenario scenario) {
        this.screen.clear();
        this.soundManager.terminate();
    }

    public void exitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public AVideoEngine videoEngine() {
        return AVideoEngine.instance();
    }

    public void perform() throws Exception {
        AVideoEngine videoEngine = AVideoEngine.instance();
        videoEngine.resourceObserver(this);
        try {
            AScenario first;
            long timeInitializationStarted = System.currentTimeMillis();
            videoEngine.size(1024, 768);
            this.screen = videoEngine.getScreen();
            this.splash(this.screen);
            this.spriteSpecManager = videoEngine.getSpriteSpecManager();
            this.controller = this.createMotionController();
            this.builder = MMachineBuilderImpl.getInstance(this.spriteSpecManager, this.screen.backgroundPlane());
            AResourceLoader loader = this.createResourceLoader();
            loader.loadResources();
            AScenario cur = first = this.createScenario();
            boolean restart = false;
            Avis.logger().statistics("Time spent for initialization=<" + Avis.format(System.currentTimeMillis() - timeInitializationStarted) + "[msec]>");
            do {
                int scenarioCode;
                if (restart) {
                    cur = first;
                    restart = false;
                }
                while ((scenarioCode = this.performScenario(cur)) == 2) {
                    cur.reset();
                }
                if (scenarioCode == 3) {
                    restart = true;
                    cur = first;
                    cur.reset();
                    continue;
                }
                if (scenarioCode != 4) {
                    if (scenarioCode != -1) continue;
                }
                break;
            } while ((cur = cur.next()) != null);
        }
        finally {
            videoEngine.terminate();
        }
    }

    public abstract AResourceLoader createResourceLoader();

    @Override
    public void startLoading(String resourceName) {
        this.splash(this.screen);
        Graphics2D gg = (Graphics2D)this.screen.getGraphics();
        gg.setColor(Color.white);
        this.drawCenteredString(gg, this.screen, "Loading:<" + resourceName + ">", (int)(1.6 * (double)this.screen.getHeight() / 3.0), 16.0f);
    }

    @Override
    public void endLoading(String resourceName) {
    }

    private void drawCenteredString(Graphics2D gg, AScreen screen, String message, int y, float size) {
        int width = screen.getWidth();
        Font f = Configuration.defaultFont.deriveFont(size);
        GlyphVector gv = f.createGlyphVector(gg.getFontRenderContext(), message);
        double gvWidth = gv.getGlyphPosition(gv.getNumGlyphs()).getX() - gv.getGlyphPosition(0).getX();
        gg.setFont(f);
        gg.drawString(message, (int)(((double)width - gvWidth) / 2.0), y);
    }

    private Image createLogo(AScreen screen) {
        int width = screen.getWidth() / 2;
        int height = screen.getHeight() / 4;
        Image ret = screen.createImage(width, height);
        Graphics2D gg = (Graphics2D)ret.getGraphics();
        gg.setColor(Color.black);
        gg.fillRect(0, 0, width, height);
        gg.setColor(Color.white);
        FontRenderContext context = gg.getFontRenderContext();
        Font f = Configuration.defaultFont.deriveFont(100.0f).deriveFont(1);
        char[] name = "Avis".toCharArray();
        GlyphVector gv = f.createGlyphVector(context, name);
        int gvW = -1;
        int gvH = -1;
        int i = 0;
        while (i < name.length) {
            int hh = gv.getGlyphOutline((int)i).getBounds().height;
            if (hh > gvH) {
                gvH = hh;
            }
            ++i;
        }
        gvW = (int)(gv.getGlyphPosition(gv.getNumGlyphs()).getX() - gv.getGlyphPosition(0).getX());
        gg.drawGlyphVector(gv, (int)((double)(width / 2) - (double)(gvW / 2) * 1.4), (float)((double)height - (double)gvH / 1.2 + 10.0));
        char[] pp = "++".toCharArray();
        f = Configuration.defaultFont.deriveFont(60.0f).deriveFont(1);
        FontRenderContext context2 = gg.getFontRenderContext();
        gv = f.createGlyphVector(context2, pp);
        int gvH2 = gv.getGlyphOutline((int)0).getBounds().height;
        gg.drawGlyphVector(gv, (float)((double)(width / 2) + (double)width / 6.2), gvH2 * 2 + 10);
        gg.dispose();
        return ret;
    }

    public void splash(AScreen screen) {
        int y;
        int x;
        Image backImage = screen.createImage(screen.getWidth(), screen.getHeight());
        Graphics2D gg = (Graphics2D)backImage.getGraphics();
        gg.setColor(Color.blue);
        gg.fillRect(0, 0, screen.getWidth(), screen.getHeight());
        if (this.logoImage == null) {
            this.logoImage = this.createLogo(screen);
            x = screen.getWidth() / 4;
            y = (int)((double)(screen.getHeight() / 2) - (double)this.logoImage.getHeight(null) * 1.2);
            int i = 0;
            while (i < 60) {
                gg.fillRect(0, 0, screen.getWidth(), screen.getHeight());
                double r = (double)(60 - i) / 60.0;
                gg.drawImage(this.logoImage, x, (int)((double)y + r * (double)this.logoImage.getHeight(null)), x + this.logoImage.getWidth(null), y + this.logoImage.getHeight(null), 0, 0, this.logoImage.getWidth(null), (int)((double)this.logoImage.getHeight(null) * (1.0 - r)), null);
                Graphics g = screen.getGraphics();
                int scrW = screen.getWidth();
                int scrH = screen.getHeight();
                g.drawImage(backImage, 0, 0, scrW, scrH, 0, 0, scrW, scrH, null);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        x = screen.getWidth() / 4;
        y = (int)((double)(screen.getHeight() / 2) - (double)this.logoImage.getHeight(null) * 1.2);
        gg.drawImage(this.logoImage, x, y, x + this.logoImage.getWidth(null), y + this.logoImage.getHeight(null), 0, 0, this.logoImage.getWidth(null), this.logoImage.getHeight(null), null);
        gg.setColor(Color.white);
        this.drawCenteredString(gg, screen, "Available Processors:<" + Runtime.getRuntime().availableProcessors() + "[unit]>", (int)(6.4 * (double)screen.getHeight() / 10.0), 16.0f);
        this.drawCenteredString(gg, screen, "Free memory:<" + Avis.format(Runtime.getRuntime().freeMemory() / 0x100000L) + "[MB]>", (int)(6.8 * (double)screen.getHeight() / 10.0), 16.0f);
        this.drawCenteredString(gg, screen, "Total memory:<" + Avis.format(Runtime.getRuntime().totalMemory() / 0x100000L) + "[MB]>", (int)(7.0 * (double)screen.getHeight() / 10.0), 16.0f);
        this.drawCenteredString(gg, screen, "Max memory:<" + Avis.format(Runtime.getRuntime().maxMemory() / 0x100000L) + "[MB]>", (int)(7.2 * (double)screen.getHeight() / 10.0), 16.0f);
        if (Configuration.joystickMode != Configuration.JoystickMode.DISABLED) {
            String detected = "";
            int num = Joystick.getNumDevices();
            boolean firstTime = true;
            int i = 0;
            while (i < num) {
                if (Joystick.isPluggedIn((int)i)) {
                    if (!firstTime) {
                        detected = String.valueOf(detected) + ",";
                        firstTime = false;
                    }
                    detected = String.valueOf(detected) + "#" + i;
                }
                ++i;
            }
            if ("".equals(detected)) {
                detected = "NONE";
            }
            this.drawCenteredString(gg, screen, "Joystick support ENABLED(" + (Object)((Object)Configuration.joystickMode) + "):detected devices=<" + detected + ">", (int)(7.6 * (double)screen.getHeight() / 10.0), 16.0f);
        } else {
            this.drawCenteredString(gg, screen, "Joystick support DISABLED", (int)(7.6 * (double)screen.getHeight() / 10.0), 16.0f);
        }
        this.drawCenteredString(gg, screen, "Avis++ Framework:SYSTEM " + Configuration.version, (int)(8.5 * (double)screen.getHeight() / 10.0), 24.0f);
        this.drawCenteredString(gg, screen, "Copyright (C) 2009 INUWI Software Lab.", 9 * screen.getHeight() / 10, 20.0f);
        gg.dispose();
        Graphics g = screen.getGraphics();
        int scrW = screen.getWidth();
        int scrH = screen.getHeight();
        g.drawImage(backImage, 0, 0, scrW, scrH, 0, 0, scrW, scrH, null);
        backImage.flush();
        backImage = null;
    }

    protected abstract AScenario createScenario();

    public int performScenario(AScenario scenario) throws Exception {
        int ret = -1;
        this.beforeExec(scenario);
        try {
            ret = this.exec(scenario);
        }
        finally {
            this.afterExec(scenario);
        }
        return ret;
    }

    protected void init(AScenario scenario) throws AException {
        Avis.logger().info("Session#init");
        this.interval = 25000000;
        this.initBgm();
        this.initSound();
        this.controller.init();
        this.scenario = scenario;
        this.controller.interactionHandler(this.scenario);
        this.scenario.init(this);
        Avis.logger().statistics("Scenario:" + this.scenario());
    }

    public void afterExec(AScenario scenario) {
    }

    public void beforeExec(AScenario scenario) {
    }

    protected void enableRendering() {
        this.renderingEnabled = true;
    }

    protected void disableRendering() {
        this.renderingEnabled = false;
    }

    public MotionController controller() {
        return this.controller;
    }

    public static class Statistics {
        public int numberOfTimesActionPerformed;
        public long actionRunningTime;
        public long layoutRunningTime;
        public long videoRenderingRunningTime;
        public long videoBgRenderingRunningTime;
        public long soundRenderingRunningTime;
        public long amountTimeSpent;

        public void add(Statistics another) {
            this.numberOfTimesActionPerformed += another.numberOfTimesActionPerformed;
            this.actionRunningTime += another.actionRunningTime;
            this.videoRenderingRunningTime += another.videoRenderingRunningTime;
            this.soundRenderingRunningTime += another.soundRenderingRunningTime;
            this.amountTimeSpent += another.amountTimeSpent;
        }

        public void dump() {
            Avis.logger().statistics("number of frames performed=<" + this.numberOfTimesActionPerformed + ">");
            Avis.logger().statistics("mean time spent per frame=<" + (double)this.amountTimeSpent / (double)this.numberOfTimesActionPerformed / 1000000.0 + "[msec]>");
            Avis.logger().statistics("mean time spent for action=<" + (double)this.actionRunningTime / (double)this.numberOfTimesActionPerformed / 1000000.0 + "[msec]>");
            Avis.logger().statistics("mean time spent for layout=<" + (double)this.layoutRunningTime / (double)this.numberOfTimesActionPerformed / 1000000.0 + "[msec]>");
            Avis.logger().statistics("mean time spent for video rendering=<" + (double)this.videoRenderingRunningTime / (double)this.numberOfTimesActionPerformed / 1000000.0 + "[msec]>");
            Avis.logger().statistics("mean time spent for sound rendering=<" + (double)this.soundRenderingRunningTime / (double)this.numberOfTimesActionPerformed / 1000000.0 + "[msec]>");
        }
    }
}

