/*
 * Decompiled with CFR 0.152.
 */
package avis.sound;

import avis.base.AException;
import avis.base.AExceptionThrower;
import avis.base.Avis;
import avis.sound.ASoundManager;
import avis.sound.DataClip;
import avis.sound.SAudioException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ADefaultSoundManager
extends ASoundManager {
    protected Map<String, DataClip> clips = new HashMap<String, DataClip>();
    protected List<SourceDataLine> availableLines = new LinkedList<SourceDataLine>();
    protected List<PlayingClip> playingClips = new LinkedList<PlayingClip>();
    protected long last = -1L;

    @Override
    public void prepare(int maxVoices) throws SAudioException {
        AudioFormat format = null;
        try {
            int i = 0;
            while (i < maxVoices) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 1, 1, 44100.0f, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format, -1);
                SourceDataLine newLine = (SourceDataLine)AudioSystem.getLine(info);
                Avis.logger().info("Sound: <" + i + ">=<" + newLine + ">");
                newLine.open(format);
                this.availableLines.add(newLine);
                ++i;
            }
        }
        catch (LineUnavailableException e) {
            AExceptionThrower.throwAudioLineWasUnavailable(format, e);
        }
    }

    @Override
    public String load(String resourceName) throws AException {
        AudioInputStream ais = null;
        DataClip ret = null;
        try {
            ais = AudioSystem.getAudioInputStream(Avis.openUrl(resourceName));
            Avis.logger().info("Sound: format=<" + ais.getFormat() + ">");
            ret = new DataClip(ais);
            this.clips.put(resourceName, ret);
            ais.close();
        }
        catch (UnsupportedAudioFileException e) {
            AExceptionThrower.throwAudioStreamWasNotAvailableException(resourceName, e);
        }
        catch (IOException e) {
            AExceptionThrower.throwAudioStreamWasNotAvailableException(resourceName, e);
        }
        return resourceName;
    }

    protected PlayingClip alloc(String key) {
        DataClip data;
        SourceDataLine line = null;
        PlayingClip ret = null;
        if (this.availableLines.size() > 0 && (line = this.availableLines.remove(0)) != null && (data = this.clips.get(key)) != null) {
            ret = new PlayingClip(key, data, line);
        }
        Avis.logger().info("Sound: line=<" + line + ">");
        return ret;
    }

    protected void free(PlayingClip clip) {
        if (clip != null) {
            this.availableLines.add(clip.line);
            this.playingClips.remove(clip);
        }
    }

    @Override
    public void play(String resourceName) throws AException {
        PlayingClip clip;
        if (!this.clips.containsKey(resourceName)) {
            return;
        }
        if (this.last == -1L) {
            this.last = System.currentTimeMillis();
        }
        if ((clip = this.alloc(resourceName)) != null) {
            clip.start();
            this.playingClips.add(clip);
        }
    }

    @Override
    public void render() {
        long current = System.currentTimeMillis();
        int duration = (int)(current - this.last);
        for (PlayingClip currentClip : this.playingClips) {
            currentClip.feed(duration);
        }
        this.cleanUp();
        this.last = current;
    }

    @Override
    protected Set<String> resources() {
        return this.clips.keySet();
    }

    @Override
    public void stop(String resourceName) {
        if (resourceName != null) {
            for (PlayingClip i : this.playingClips) {
                if (!resourceName.equals(i.name)) continue;
                i.stop();
                this.cleanUp();
                break;
            }
        }
    }

    protected void cleanUp() {
        LinkedList<PlayingClip> toBeRemoved = new LinkedList<PlayingClip>();
        for (PlayingClip currentClip : this.playingClips) {
            if (!currentClip.isFinished()) continue;
            toBeRemoved.add(currentClip);
        }
        for (PlayingClip currentClip : toBeRemoved) {
            this.free(currentClip);
        }
        toBeRemoved = null;
    }

    @Override
    public void terminate() {
        this.stopAll();
        this.clips.clear();
    }

    protected static class PlayingClip {
        String name;
        DataClip data;
        SourceDataLine line;

        protected PlayingClip(String name, DataClip data, SourceDataLine line) {
            this.name = name;
            this.data = data;
            this.line = line;
        }

        public void feed(int duration) {
            this.data.calculateSampleRate(duration);
            int bytes = Math.min(this.data.sampleRate, this.data.data.length - this.data.index);
            if (bytes > 0) {
                this.line.write(this.data.data, this.data.index, bytes);
                this.data.index += bytes;
            }
            if (this.data.index >= this.data.data.length) {
                this.stop();
            }
        }

        public boolean isFinished() {
            return !this.data.running;
        }

        public void start() {
            this.data.index = 0;
            this.data.running = true;
            this.line.flush();
            this.line.start();
        }

        public void stop() {
            this.data.running = false;
            this.line.stop();
        }
    }
}

