/*
 * Decompiled with CFR 0.152.
 */
package avis.sound;

import avis.base.AException;
import avis.base.Avis;
import avis.sound.ASoundManager;
import avis.sound.SAudioException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AMultiThreadedSoundManager
extends ASoundManager {
    private List<Command> queue = new LinkedList<Command>();
    private ASoundManager target;
    private boolean finished = false;
    private Thread thread;

    public AMultiThreadedSoundManager(final ASoundManager target) throws SAudioException {
        this.target = target;
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Avis.logger().info("Sound: Sound Manager Thread is started.");
                while (!AMultiThreadedSoundManager.this.finished) {
                    Command cmd = null;
                    List list = AMultiThreadedSoundManager.this.queue;
                    synchronized (list) {
                        if (AMultiThreadedSoundManager.this.queue.size() > 0) {
                            cmd = (Command)AMultiThreadedSoundManager.this.queue.remove(0);
                        }
                    }
                    if (cmd != null) {
                        cmd.run(target);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.out);
                    }
                }
                Avis.logger().info("Sound: Sound Manager Thread is finished.");
            }
        }){};
        this.thread.start();
    }

    @Override
    public String load(String resourceName) throws AException {
        return this.target.load(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(String resourceName) throws AException {
        List<Command> list = this.queue;
        synchronized (list) {
            this.queue.add(new Command(Command.Name.Play, resourceName));
        }
    }

    @Override
    public void prepare(int maxVoices) throws SAudioException {
        this.target.prepare(maxVoices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        List<Command> list = this.queue;
        synchronized (list) {
            this.queue.add(new Command(Command.Name.Render, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        List<Command> list = this.queue;
        synchronized (list) {
            this.finished = true;
            this.target.terminate();
            this.queue.clear();
        }
    }

    @Override
    protected Set<String> resources() {
        return this.target.resources();
    }

    @Override
    public void stop(String resourceName) {
        this.target.stop(resourceName);
    }

    private static class Command {
        Name name;
        String resource;

        Command(Name name, String resource) {
            this.name = name;
            this.resource = resource;
        }

        public void run(ASoundManager target) {
            if (this.name == Name.Play) {
                try {
                    target.play(this.resource);
                }
                catch (AException e) {
                    e.printStackTrace(System.out);
                }
            } else if (this.name == Name.Render) {
                target.render();
            }
        }

        private static enum Name {
            Play,
            Render;

        }
    }
}

