/*
 * Decompiled with CFR 0.152.
 */
package avis.spec;

import avis.base.ABaseResourceLoader;
import avis.base.AException;
import avis.base.AExceptionThrower;
import avis.base.AResourceObserver;
import avis.base.Avis;
import avis.spec.ASpriteSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ASpriteSpecManager
extends ABaseResourceLoader {
    protected Map<String, ASpriteSpec> specMap = new HashMap<String, ASpriteSpec>();

    public ASpriteSpecManager(AResourceObserver observer) {
        super(observer);
    }

    public ASpriteSpec getSpriteSpec(String name) {
        return this.specMap.get(name);
    }

    public Iterator<ASpriteSpec> spriteSpecs() {
        return this.specMap.values().iterator();
    }

    public void unload(String name) {
        ASpriteSpec spec = this.specMap.get(name);
        spec.dispose();
        this.specMap.remove(name);
    }

    public ASpriteSpec loadSpriteSpec(String name, Class<? extends ASpriteSpec> clazz, Object resource) throws AException {
        ASpriteSpec spec = null;
        this.observer.startLoading(name);
        long before = System.currentTimeMillis();
        try {
            spec = clazz.newInstance();
            spec.init(resource);
            spec.name(name);
            if (this.specMap.containsKey(spec.name())) {
                this.unload(spec.name());
            }
            this.specMap.put(spec.name(), spec);
        }
        catch (InstantiationException e) {
            AExceptionThrower.throwSpriteSpecInstanciationException(clazz, resource, e);
        }
        catch (IllegalAccessException e) {
            AExceptionThrower.throwSpriteSpecInstanciationException(clazz, resource, e);
        }
        this.observer.endLoading(name);
        Avis.logger().info("Loaded SpriteSpec:name:<" + spec.name() + ">, time=<" + (System.currentTimeMillis() - before) + ">");
        return spec;
    }

    @Override
    public void loadResources() throws AException {
    }
}

