/*
 * Decompiled with CFR 0.152.
 */
package avis.sprite;

import avis.spec.ASpriteSpec;
import avis.sprite.IASpriteObserver;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ASprite
implements Comparable<ASprite> {
    protected static final EventDispatcher dispatcher = new EventDispatcher();
    protected int x;
    protected int y;
    protected int index;
    protected boolean visible = false;
    protected int pattern = 0;
    protected ASpriteSpec spec = null;
    private boolean disposed = false;
    private IASpriteObserver observer = IASpriteObserver.NULL_OBSERVER;
    private int priority;
    public static int defaultPriority = 100;

    public void priority(int priority) {
        this.priority = priority;
        dispatcher.priorityChanged(this);
    }

    public int priority() {
        return this.priority;
    }

    public void addObserver(IASpriteObserver observer) {
        if (observer == IASpriteObserver.NULL_OBSERVER || observer == dispatcher) {
            return;
        }
        if (this.observer == IASpriteObserver.NULL_OBSERVER) {
            this.observer = dispatcher;
        }
        dispatcher.add(observer, this);
    }

    public void removeObserver(IASpriteObserver observer) {
        if (observer != dispatcher) {
            return;
        }
        dispatcher.remove(observer);
    }

    public Set<IASpriteObserver> observers() {
        return dispatcher.oberversFor(this);
    }

    public int width() {
        return 0;
    }

    public int height() {
        return 0;
    }

    public void put(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void put(int x, int y, int i) {
        this.put(x, y);
        this.index = i;
    }

    public void visible(boolean v) {
        this.visible = v;
        this.observer.setVisible(this, v);
    }

    public boolean visible() {
        return this.visible;
    }

    public void pattern(int i) {
        this.pattern = i;
    }

    public int pattern() {
        return this.pattern;
    }

    public void paint(Graphics graphics, ImageObserver observer) {
        if (!this.disposed) {
            this.paint_Protected(graphics, observer);
        }
    }

    protected abstract void paint_Protected(Graphics var1, ImageObserver var2);

    public void init(ASpriteSpec p) {
        this.spec = p;
        this.init_Protected(p);
    }

    protected abstract void init_Protected(ASpriteSpec var1);

    public ASpriteSpec spec() {
        return this.spec;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.disposed = true;
        this.observer.disposed(this);
    }

    public int y() {
        return this.y;
    }

    public int x() {
        return this.x;
    }

    public boolean touches(Rectangle rect) {
        int dx = this.x - (rect.x + rect.width / 2);
        int dy = this.y - (rect.y + rect.height / 2);
        return dx * dx <= rect.width * rect.width + this.width() * this.width() && dy * dy <= rect.height * rect.height + this.height() * this.height();
    }

    @Override
    public int compareTo(ASprite o) {
        return this.priority - o.priority;
    }

    public static class EventDispatcher
    implements IASpriteObserver {
        Set<IASpriteObserver> observers = new HashSet<IASpriteObserver>();
        Map<IASpriteObserver, Set<ASprite>> destinationMap = new HashMap<IASpriteObserver, Set<ASprite>>();

        @Override
        public void disposed(ASprite sprite) {
            for (IASpriteObserver cur : this.observers) {
                Set<ASprite> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(sprite)) continue;
                cur.disposed(sprite);
            }
        }

        @Override
        public void priorityChanged(ASprite sprite) {
            for (IASpriteObserver cur : this.observers) {
                Set<ASprite> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(sprite)) continue;
                cur.priorityChanged(sprite);
            }
        }

        @Override
        public void setVisible(ASprite sprite, boolean visible) {
            for (IASpriteObserver cur : this.observers) {
                Set<ASprite> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(sprite)) continue;
                cur.setVisible(sprite, visible);
            }
        }

        public Set<IASpriteObserver> oberversFor(ASprite sprite) {
            HashSet<IASpriteObserver> ret = new HashSet<IASpriteObserver>();
            for (IASpriteObserver cur : this.observers) {
                Set<ASprite> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(sprite)) continue;
                ret.add(cur);
            }
            return ret;
        }

        public void add(IASpriteObserver observer, ASprite sprite) {
            this.observers.add(observer);
            if (!this.destinationMap.containsKey(observer)) {
                this.destinationMap.put(observer, new HashSet());
            }
            Set<ASprite> destinations = this.destinationMap.get(observer);
            destinations.add(sprite);
        }

        public void remove(IASpriteObserver observer) {
            this.observers.remove(observer);
            if (!this.destinationMap.containsKey(observer)) {
                this.destinationMap.remove(observer);
            }
        }
    }
}

